/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.AuthorizeOAuthTokenResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.IssueOAuthTokenResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.OAuthTokenRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.OathClientResponse;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OAuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for authorizeOAuthToken
     * @param oauthTokenRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully issued a code. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call authorizeOAuthTokenCall(OAuthTokenRequest oauthTokenRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = oauthTokenRequest;

        // create path and map variables
        String localVarPath = "/v1/oauth/authorize";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call authorizeOAuthTokenValidateBeforeCall(OAuthTokenRequest oauthTokenRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'oauthTokenRequest' is set
        if (oauthTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'oauthTokenRequest' when calling authorizeOAuthToken(Async)");
        }

        return authorizeOAuthTokenCall(oauthTokenRequest, _callback);

    }

    /**
     * Authorize an OAuth Token
     * The operation issues an OAuth code which can be used in the OAuth code flow. 
     * @param oauthTokenRequest  (required)
     * @return AuthorizeOAuthTokenResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully issued a code. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    public AuthorizeOAuthTokenResponse authorizeOAuthToken(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        ApiResponse<AuthorizeOAuthTokenResponse> localVarResp = authorizeOAuthTokenWithHttpInfo(oauthTokenRequest);
        return localVarResp.getData();
    }

    /**
     * Authorize an OAuth Token
     * The operation issues an OAuth code which can be used in the OAuth code flow. 
     * @param oauthTokenRequest  (required)
     * @return ApiResponse&lt;AuthorizeOAuthTokenResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully issued a code. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<AuthorizeOAuthTokenResponse> authorizeOAuthTokenWithHttpInfo(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        okhttp3.Call localVarCall = authorizeOAuthTokenValidateBeforeCall(oauthTokenRequest, null);
        Type localVarReturnType = new TypeToken<AuthorizeOAuthTokenResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Authorize an OAuth Token (asynchronously)
     * The operation issues an OAuth code which can be used in the OAuth code flow. 
     * @param oauthTokenRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully issued a code. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call authorizeOAuthTokenAsync(OAuthTokenRequest oauthTokenRequest, final ApiCallback<AuthorizeOAuthTokenResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = authorizeOAuthTokenValidateBeforeCall(oauthTokenRequest, _callback);
        Type localVarReturnType = new TypeToken<AuthorizeOAuthTokenResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOAuthClient
     * @param clientId  (required)
     * @param responseType code or token (optional)
     * @param redirectUri Redirect URI of the OAuth flow (optional)
     * @param scope Requested scopes by the OAuth flow (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exist or you do not have access to the client.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOAuthClientCall(UUID clientId, String responseType, String redirectUri, String scope, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/oauth/clients/{client_id}"
            .replace("{" + "client_id" + "}", localVarApiClient.escapeString(clientId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (responseType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("response_type", responseType));
        }

        if (redirectUri != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("redirect_uri", redirectUri));
        }

        if (scope != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("scope", scope));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOAuthClientValidateBeforeCall(UUID clientId, String responseType, String redirectUri, String scope, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling getOAuthClient(Async)");
        }

        return getOAuthClientCall(clientId, responseType, redirectUri, scope, _callback);

    }

    /**
     * Get an OAuth client
     * The endpoint returns the details of OAuth client to display in the authorization page. 
     * @param clientId  (required)
     * @param responseType code or token (optional)
     * @param redirectUri Redirect URI of the OAuth flow (optional)
     * @param scope Requested scopes by the OAuth flow (optional)
     * @return OathClientResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exist or you do not have access to the client.  </td><td>  -  </td></tr>
     </table>
     */
    public OathClientResponse getOAuthClient(UUID clientId, String responseType, String redirectUri, String scope) throws ApiException {
        ApiResponse<OathClientResponse> localVarResp = getOAuthClientWithHttpInfo(clientId, responseType, redirectUri, scope);
        return localVarResp.getData();
    }

    /**
     * Get an OAuth client
     * The endpoint returns the details of OAuth client to display in the authorization page. 
     * @param clientId  (required)
     * @param responseType code or token (optional)
     * @param redirectUri Redirect URI of the OAuth flow (optional)
     * @param scope Requested scopes by the OAuth flow (optional)
     * @return ApiResponse&lt;OathClientResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exist or you do not have access to the client.  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<OathClientResponse> getOAuthClientWithHttpInfo(UUID clientId, String responseType, String redirectUri, String scope) throws ApiException {
        okhttp3.Call localVarCall = getOAuthClientValidateBeforeCall(clientId, responseType, redirectUri, scope, null);
        Type localVarReturnType = new TypeToken<OathClientResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an OAuth client (asynchronously)
     * The endpoint returns the details of OAuth client to display in the authorization page. 
     * @param clientId  (required)
     * @param responseType code or token (optional)
     * @param redirectUri Redirect URI of the OAuth flow (optional)
     * @param scope Requested scopes by the OAuth flow (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exist or you do not have access to the client.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOAuthClientAsync(UUID clientId, String responseType, String redirectUri, String scope, final ApiCallback<OathClientResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOAuthClientValidateBeforeCall(clientId, responseType, redirectUri, scope, _callback);
        Type localVarReturnType = new TypeToken<OathClientResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for issueOAuthToken
     * @param oauthTokenRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call issueOAuthTokenCall(OAuthTokenRequest oauthTokenRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = oauthTokenRequest;

        // create path and map variables
        String localVarPath = "/v1/oauth/token";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call issueOAuthTokenValidateBeforeCall(OAuthTokenRequest oauthTokenRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'oauthTokenRequest' is set
        if (oauthTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'oauthTokenRequest' when calling issueOAuthToken(Async)");
        }

        return issueOAuthTokenCall(oauthTokenRequest, _callback);

    }

    /**
     * Issue an OAuth token
     * The operation issues an OAuth code which can be used in the OAuth code flow. 
     * @param oauthTokenRequest  (required)
     * @return IssueOAuthTokenResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    public IssueOAuthTokenResponse issueOAuthToken(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        ApiResponse<IssueOAuthTokenResponse> localVarResp = issueOAuthTokenWithHttpInfo(oauthTokenRequest);
        return localVarResp.getData();
    }

    /**
     * Issue an OAuth token
     * The operation issues an OAuth code which can be used in the OAuth code flow. 
     * @param oauthTokenRequest  (required)
     * @return ApiResponse&lt;IssueOAuthTokenResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<IssueOAuthTokenResponse> issueOAuthTokenWithHttpInfo(OAuthTokenRequest oauthTokenRequest) throws ApiException {
        okhttp3.Call localVarCall = issueOAuthTokenValidateBeforeCall(oauthTokenRequest, null);
        Type localVarReturnType = new TypeToken<IssueOAuthTokenResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Issue an OAuth token (asynchronously)
     * The operation issues an OAuth code which can be used in the OAuth code flow. 
     * @param oauthTokenRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Redirect URI or scope is invalid.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call issueOAuthTokenAsync(OAuthTokenRequest oauthTokenRequest, final ApiCallback<IssueOAuthTokenResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = issueOAuthTokenValidateBeforeCall(oauthTokenRequest, _callback);
        Type localVarReturnType = new TypeToken<IssueOAuthTokenResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
