/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;



import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogosApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public LogosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getV1beta1LogosSymbol
     * @param symbol Stock or crypto symbol (e.g. AAPL, BTCUSD, etc.) (required)
     * @param placeholder True by default, will return sample placeholder images with the first letter of the asset symbol. If false, 404 will be returned for symbols which do not contain an image. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The API response will return the raw image as a binary </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1beta1LogosSymbolCall(String symbol, String placeholder, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta1/logos/{symbol}"
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (placeholder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("placeholder", placeholder));
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1beta1LogosSymbolValidateBeforeCall(String symbol, String placeholder, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling getV1beta1LogosSymbol(Async)");
        }

        return getV1beta1LogosSymbolCall(symbol, placeholder, _callback);

    }

    /**
     * Get Logo
     * Alpaca’s Logo API serves uniform logo images for select stock and crypto symbols.  Note: For Logo API pricing details, reach out to sales@alpaca.markets  The API response will return the raw image as a binary
     * @param symbol Stock or crypto symbol (e.g. AAPL, BTCUSD, etc.) (required)
     * @param placeholder True by default, will return sample placeholder images with the first letter of the asset symbol. If false, 404 will be returned for symbols which do not contain an image. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The API response will return the raw image as a binary </td><td>  -  </td></tr>
     </table>
     */
    public void getV1beta1LogosSymbol(String symbol, String placeholder) throws ApiException {
        getV1beta1LogosSymbolWithHttpInfo(symbol, placeholder);
    }

    /**
     * Get Logo
     * Alpaca’s Logo API serves uniform logo images for select stock and crypto symbols.  Note: For Logo API pricing details, reach out to sales@alpaca.markets  The API response will return the raw image as a binary
     * @param symbol Stock or crypto symbol (e.g. AAPL, BTCUSD, etc.) (required)
     * @param placeholder True by default, will return sample placeholder images with the first letter of the asset symbol. If false, 404 will be returned for symbols which do not contain an image. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The API response will return the raw image as a binary </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> getV1beta1LogosSymbolWithHttpInfo(String symbol, String placeholder) throws ApiException {
        okhttp3.Call localVarCall = getV1beta1LogosSymbolValidateBeforeCall(symbol, placeholder, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Get Logo (asynchronously)
     * Alpaca’s Logo API serves uniform logo images for select stock and crypto symbols.  Note: For Logo API pricing details, reach out to sales@alpaca.markets  The API response will return the raw image as a binary
     * @param symbol Stock or crypto symbol (e.g. AAPL, BTCUSD, etc.) (required)
     * @param placeholder True by default, will return sample placeholder images with the first letter of the asset symbol. If false, 404 will be returned for symbols which do not contain an image. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The API response will return the raw image as a binary </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1beta1LogosSymbolAsync(String symbol, String placeholder, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1beta1LogosSymbolValidateBeforeCall(symbol, placeholder, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
