/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.CIPInfo;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1AccountsAccountIdOnfidoSdkTokens200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.PatchV1AccountsAccountIdOnfidoSdkRequest;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KycApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public KycApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KycApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getV1AccountsAccountIdCip
     * @param accountId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsAccountIdCipCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/cip"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1AccountsAccountIdCipValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1AccountsAccountIdCip(Async)");
        }

        return getV1AccountsAccountIdCipCall(accountId, _callback);

    }

    /**
     * Retrieve CIP information
     * You can retrieve the CIP information you’ve submitted for a given account.
     * @param accountId  (required)
     * @return CIPInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CIPInfo getV1AccountsAccountIdCip(String accountId) throws ApiException {
        ApiResponse<CIPInfo> localVarResp = getV1AccountsAccountIdCipWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Retrieve CIP information
     * You can retrieve the CIP information you’ve submitted for a given account.
     * @param accountId  (required)
     * @return ApiResponse&lt;CIPInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<CIPInfo> getV1AccountsAccountIdCipWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getV1AccountsAccountIdCipValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<CIPInfo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve CIP information (asynchronously)
     * You can retrieve the CIP information you’ve submitted for a given account.
     * @param accountId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsAccountIdCipAsync(String accountId, final ApiCallback<CIPInfo> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1AccountsAccountIdCipValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<CIPInfo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1AccountsAccountIdOnfidoSdkTokens
     * @param accountId The account ID (required)
     * @param referrer The referrer URL of your web app or the application ID of your mobile app. If not passed in, will default to the * wildcard (optional)
     * @param platform Required if referrer provided. Enum values are either mobile or web (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Onfido applicant not yet created for account. If you haven’t already contacted Alapca to enable Onfido, please do so. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsAccountIdOnfidoSdkTokensCall(UUID accountId, String referrer, String platform, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/onfido/sdk/tokens"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referrer != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("referrer", referrer));
        }

        if (platform != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("platform", platform));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1AccountsAccountIdOnfidoSdkTokensValidateBeforeCall(UUID accountId, String referrer, String platform, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1AccountsAccountIdOnfidoSdkTokens(Async)");
        }

        return getV1AccountsAccountIdOnfidoSdkTokensCall(accountId, referrer, platform, _callback);

    }

    /**
     * Retrieve an Onfido SDK Token
     * Get an SDK token to activate the Onfido SDK flow within your app. You will have to keep track of the SDK token so you can pass it back when you upload the SDK outcome. We recommend storing the token in memory rather than persistent storage to reduce any unnecessary overhead in your app.
     * @param accountId The account ID (required)
     * @param referrer The referrer URL of your web app or the application ID of your mobile app. If not passed in, will default to the * wildcard (optional)
     * @param platform Required if referrer provided. Enum values are either mobile or web (optional)
     * @return GetV1AccountsAccountIdOnfidoSdkTokens200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Onfido applicant not yet created for account. If you haven’t already contacted Alapca to enable Onfido, please do so. </td><td>  -  </td></tr>
     </table>
     */
    public GetV1AccountsAccountIdOnfidoSdkTokens200Response getV1AccountsAccountIdOnfidoSdkTokens(UUID accountId, String referrer, String platform) throws ApiException {
        ApiResponse<GetV1AccountsAccountIdOnfidoSdkTokens200Response> localVarResp = getV1AccountsAccountIdOnfidoSdkTokensWithHttpInfo(accountId, referrer, platform);
        return localVarResp.getData();
    }

    /**
     * Retrieve an Onfido SDK Token
     * Get an SDK token to activate the Onfido SDK flow within your app. You will have to keep track of the SDK token so you can pass it back when you upload the SDK outcome. We recommend storing the token in memory rather than persistent storage to reduce any unnecessary overhead in your app.
     * @param accountId The account ID (required)
     * @param referrer The referrer URL of your web app or the application ID of your mobile app. If not passed in, will default to the * wildcard (optional)
     * @param platform Required if referrer provided. Enum values are either mobile or web (optional)
     * @return ApiResponse&lt;GetV1AccountsAccountIdOnfidoSdkTokens200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Onfido applicant not yet created for account. If you haven’t already contacted Alapca to enable Onfido, please do so. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetV1AccountsAccountIdOnfidoSdkTokens200Response> getV1AccountsAccountIdOnfidoSdkTokensWithHttpInfo(UUID accountId, String referrer, String platform) throws ApiException {
        okhttp3.Call localVarCall = getV1AccountsAccountIdOnfidoSdkTokensValidateBeforeCall(accountId, referrer, platform, null);
        Type localVarReturnType = new TypeToken<GetV1AccountsAccountIdOnfidoSdkTokens200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve an Onfido SDK Token (asynchronously)
     * Get an SDK token to activate the Onfido SDK flow within your app. You will have to keep track of the SDK token so you can pass it back when you upload the SDK outcome. We recommend storing the token in memory rather than persistent storage to reduce any unnecessary overhead in your app.
     * @param accountId The account ID (required)
     * @param referrer The referrer URL of your web app or the application ID of your mobile app. If not passed in, will default to the * wildcard (optional)
     * @param platform Required if referrer provided. Enum values are either mobile or web (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Onfido applicant not yet created for account. If you haven’t already contacted Alapca to enable Onfido, please do so. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsAccountIdOnfidoSdkTokensAsync(UUID accountId, String referrer, String platform, final ApiCallback<GetV1AccountsAccountIdOnfidoSdkTokens200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1AccountsAccountIdOnfidoSdkTokensValidateBeforeCall(accountId, referrer, platform, _callback);
        Type localVarReturnType = new TypeToken<GetV1AccountsAccountIdOnfidoSdkTokens200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for patchV1AccountsAccountIdOnfidoSdk
     * @param accountId  (required)
     * @param patchV1AccountsAccountIdOnfidoSdkRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found​ </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value for outcome. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchV1AccountsAccountIdOnfidoSdkCall(String accountId, PatchV1AccountsAccountIdOnfidoSdkRequest patchV1AccountsAccountIdOnfidoSdkRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = patchV1AccountsAccountIdOnfidoSdkRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/onfido/sdk"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchV1AccountsAccountIdOnfidoSdkValidateBeforeCall(String accountId, PatchV1AccountsAccountIdOnfidoSdkRequest patchV1AccountsAccountIdOnfidoSdkRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling patchV1AccountsAccountIdOnfidoSdk(Async)");
        }

        return patchV1AccountsAccountIdOnfidoSdkCall(accountId, patchV1AccountsAccountIdOnfidoSdkRequest, _callback);

    }

    /**
     * Update the Onfido SDK Outcome
     * This request allows you to send Alpaca the result of the Onfido SDK flow in your app. A notification of a successful outcome is required for Alpaca to continue the KYC process.
     * @param accountId  (required)
     * @param patchV1AccountsAccountIdOnfidoSdkRequest  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found​ </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value for outcome. </td><td>  -  </td></tr>
     </table>
     */
    public void patchV1AccountsAccountIdOnfidoSdk(String accountId, PatchV1AccountsAccountIdOnfidoSdkRequest patchV1AccountsAccountIdOnfidoSdkRequest) throws ApiException {
        patchV1AccountsAccountIdOnfidoSdkWithHttpInfo(accountId, patchV1AccountsAccountIdOnfidoSdkRequest);
    }

    /**
     * Update the Onfido SDK Outcome
     * This request allows you to send Alpaca the result of the Onfido SDK flow in your app. A notification of a successful outcome is required for Alpaca to continue the KYC process.
     * @param accountId  (required)
     * @param patchV1AccountsAccountIdOnfidoSdkRequest  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found​ </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value for outcome. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> patchV1AccountsAccountIdOnfidoSdkWithHttpInfo(String accountId, PatchV1AccountsAccountIdOnfidoSdkRequest patchV1AccountsAccountIdOnfidoSdkRequest) throws ApiException {
        okhttp3.Call localVarCall = patchV1AccountsAccountIdOnfidoSdkValidateBeforeCall(accountId, patchV1AccountsAccountIdOnfidoSdkRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update the Onfido SDK Outcome (asynchronously)
     * This request allows you to send Alpaca the result of the Onfido SDK flow in your app. A notification of a successful outcome is required for Alpaca to continue the KYC process.
     * @param accountId  (required)
     * @param patchV1AccountsAccountIdOnfidoSdkRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found​ </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value for outcome. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchV1AccountsAccountIdOnfidoSdkAsync(String accountId, PatchV1AccountsAccountIdOnfidoSdkRequest patchV1AccountsAccountIdOnfidoSdkRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = patchV1AccountsAccountIdOnfidoSdkValidateBeforeCall(accountId, patchV1AccountsAccountIdOnfidoSdkRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1AccountsAccountIdCip
     * @param accountId  (required)
     * @param ciPInfo  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1AccountsAccountIdCipCall(String accountId, CIPInfo ciPInfo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = ciPInfo;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/cip"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1AccountsAccountIdCipValidateBeforeCall(String accountId, CIPInfo ciPInfo, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postV1AccountsAccountIdCip(Async)");
        }

        return postV1AccountsAccountIdCipCall(accountId, ciPInfo, _callback);

    }

    /**
     * Upload CIP information
     * The customer identification program (CIP) API allows you to submit the CIP results received from your KYC provider.  The minimum requirements to open an individual financial account are delimited and you must verify the true identity of the account holder at account opening:  Name Date of birth Address Identification number (for a U.S. citizen, a taxpayer identification number)
     * @param accountId  (required)
     * @param ciPInfo  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public void postV1AccountsAccountIdCip(String accountId, CIPInfo ciPInfo) throws ApiException {
        postV1AccountsAccountIdCipWithHttpInfo(accountId, ciPInfo);
    }

    /**
     * Upload CIP information
     * The customer identification program (CIP) API allows you to submit the CIP results received from your KYC provider.  The minimum requirements to open an individual financial account are delimited and you must verify the true identity of the account holder at account opening:  Name Date of birth Address Identification number (for a U.S. citizen, a taxpayer identification number)
     * @param accountId  (required)
     * @param ciPInfo  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> postV1AccountsAccountIdCipWithHttpInfo(String accountId, CIPInfo ciPInfo) throws ApiException {
        okhttp3.Call localVarCall = postV1AccountsAccountIdCipValidateBeforeCall(accountId, ciPInfo, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Upload CIP information (asynchronously)
     * The customer identification program (CIP) API allows you to submit the CIP results received from your KYC provider.  The minimum requirements to open an individual financial account are delimited and you must verify the true identity of the account holder at account opening:  Name Date of birth Address Identification number (for a U.S. citizen, a taxpayer identification number)
     * @param accountId  (required)
     * @param ciPInfo  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1AccountsAccountIdCipAsync(String accountId, CIPInfo ciPInfo, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1AccountsAccountIdCipValidateBeforeCall(accountId, ciPInfo, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
