/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateJournalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Journal;
import java.time.LocalDate;
import net.jacobpeterson.alpaca.openapi.broker.model.ReverseBatchJournalRequest;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JournalsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public JournalsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JournalsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for createBatchJournal
     * @param batchJournalRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createBatchJournalCall(BatchJournalRequest batchJournalRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = batchJournalRequest;

        // create path and map variables
        String localVarPath = "/v1/journals/batch";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createBatchJournalValidateBeforeCall(BatchJournalRequest batchJournalRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'batchJournalRequest' is set
        if (batchJournalRequest == null) {
            throw new ApiException("Missing the required parameter 'batchJournalRequest' when calling createBatchJournal(Async)");
        }

        return createBatchJournalCall(batchJournalRequest, _callback);

    }

    /**
     * Create a Batch Journal Transaction (One-to-Many)
     * You can create a batch of journal requests by using this endpoint. This is enabled on JNLC type Journals for now only.  Every single request must be valid for the entire batch operation to succeed.  In the case of a successful request, the response will contain an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal.
     * @param batchJournalRequest  (required)
     * @return List&lt;BatchJournalResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal. </td><td>  -  </td></tr>
     </table>
     */
    public List<BatchJournalResponse> createBatchJournal(BatchJournalRequest batchJournalRequest) throws ApiException {
        ApiResponse<List<BatchJournalResponse>> localVarResp = createBatchJournalWithHttpInfo(batchJournalRequest);
        return localVarResp.getData();
    }

    /**
     * Create a Batch Journal Transaction (One-to-Many)
     * You can create a batch of journal requests by using this endpoint. This is enabled on JNLC type Journals for now only.  Every single request must be valid for the entire batch operation to succeed.  In the case of a successful request, the response will contain an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal.
     * @param batchJournalRequest  (required)
     * @return ApiResponse&lt;List&lt;BatchJournalResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<BatchJournalResponse>> createBatchJournalWithHttpInfo(BatchJournalRequest batchJournalRequest) throws ApiException {
        okhttp3.Call localVarCall = createBatchJournalValidateBeforeCall(batchJournalRequest, null);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Batch Journal Transaction (One-to-Many) (asynchronously)
     * You can create a batch of journal requests by using this endpoint. This is enabled on JNLC type Journals for now only.  Every single request must be valid for the entire batch operation to succeed.  In the case of a successful request, the response will contain an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal.
     * @param batchJournalRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> an array of journal objects with an extra attribute error_message in the case when a specific account fails to receive a journal. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createBatchJournalAsync(BatchJournalRequest batchJournalRequest, final ApiCallback<List<BatchJournalResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = createBatchJournalValidateBeforeCall(batchJournalRequest, _callback);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createJournal
     * @param createJournalRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The New Journal object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> One of the parameters is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The amount requested to move is not available. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> One of the account is not found. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createJournalCall(CreateJournalRequest createJournalRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createJournalRequest;

        // create path and map variables
        String localVarPath = "/v1/journals";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createJournalValidateBeforeCall(CreateJournalRequest createJournalRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createJournalRequest' is set
        if (createJournalRequest == null) {
            throw new ApiException("Missing the required parameter 'createJournalRequest' when calling createJournal(Async)");
        }

        return createJournalCall(createJournalRequest, _callback);

    }

    /**
     * Create a Journal
     * A journal can be JNLC (move cash) or JNLS (move shares), dictated by &#x60;entry_type&#x60;. Generally, journal requests are subject to approval and starts from the &#x60;pending&#x60; status. The status changes are propagated through the Event API. Under certain conditions agreed for the partner, such journal transactions that meet the criteria are executed right away. 
     * @param createJournalRequest  (required)
     * @return Journal
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The New Journal object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> One of the parameters is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The amount requested to move is not available. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> One of the account is not found. </td><td>  -  </td></tr>
     </table>
     */
    public Journal createJournal(CreateJournalRequest createJournalRequest) throws ApiException {
        ApiResponse<Journal> localVarResp = createJournalWithHttpInfo(createJournalRequest);
        return localVarResp.getData();
    }

    /**
     * Create a Journal
     * A journal can be JNLC (move cash) or JNLS (move shares), dictated by &#x60;entry_type&#x60;. Generally, journal requests are subject to approval and starts from the &#x60;pending&#x60; status. The status changes are propagated through the Event API. Under certain conditions agreed for the partner, such journal transactions that meet the criteria are executed right away. 
     * @param createJournalRequest  (required)
     * @return ApiResponse&lt;Journal&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The New Journal object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> One of the parameters is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The amount requested to move is not available. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> One of the account is not found. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Journal> createJournalWithHttpInfo(CreateJournalRequest createJournalRequest) throws ApiException {
        okhttp3.Call localVarCall = createJournalValidateBeforeCall(createJournalRequest, null);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Journal (asynchronously)
     * A journal can be JNLC (move cash) or JNLS (move shares), dictated by &#x60;entry_type&#x60;. Generally, journal requests are subject to approval and starts from the &#x60;pending&#x60; status. The status changes are propagated through the Event API. Under certain conditions agreed for the partner, such journal transactions that meet the criteria are executed right away. 
     * @param createJournalRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The New Journal object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> One of the parameters is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The amount requested to move is not available. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> One of the account is not found. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createJournalAsync(CreateJournalRequest createJournalRequest, final ApiCallback<Journal> _callback) throws ApiException {

        okhttp3.Call localVarCall = createJournalValidateBeforeCall(createJournalRequest, _callback);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteJournalById
     * @param journalId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> The cancel request succeeded. (No-content)  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The journal is not found.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The journal is not in the pending status.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteJournalByIdCall(UUID journalId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/journals/{journal_id}"
            .replace("{" + "journal_id" + "}", localVarApiClient.escapeString(journalId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteJournalByIdValidateBeforeCall(UUID journalId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'journalId' is set
        if (journalId == null) {
            throw new ApiException("Missing the required parameter 'journalId' when calling deleteJournalById(Async)");
        }

        return deleteJournalByIdCall(journalId, _callback);

    }

    /**
     * Cancel a Pending Journal
     * You can only delete a journal if the journal is still in a pending state, if a journal is executed you will not be able to delete. The alternative is to create a mirror journal entry to reverse the flow of funds.
     * @param journalId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> The cancel request succeeded. (No-content)  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The journal is not found.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The journal is not in the pending status.  </td><td>  -  </td></tr>
     </table>
     */
    public void deleteJournalById(UUID journalId) throws ApiException {
        deleteJournalByIdWithHttpInfo(journalId);
    }

    /**
     * Cancel a Pending Journal
     * You can only delete a journal if the journal is still in a pending state, if a journal is executed you will not be able to delete. The alternative is to create a mirror journal entry to reverse the flow of funds.
     * @param journalId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> The cancel request succeeded. (No-content)  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The journal is not found.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The journal is not in the pending status.  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteJournalByIdWithHttpInfo(UUID journalId) throws ApiException {
        okhttp3.Call localVarCall = deleteJournalByIdValidateBeforeCall(journalId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Cancel a Pending Journal (asynchronously)
     * You can only delete a journal if the journal is still in a pending state, if a journal is executed you will not be able to delete. The alternative is to create a mirror journal entry to reverse the flow of funds.
     * @param journalId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> The cancel request succeeded. (No-content)  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The journal is not found.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The journal is not in the pending status.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteJournalByIdAsync(UUID journalId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteJournalByIdValidateBeforeCall(journalId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllJournals
     * @param after By journal creation date. Format: 2020-01-01 (optional)
     * @param before By journal creation date. Format: 2020-01-01 (optional)
     * @param status See the JournalStatus model for more info (optional)
     * @param entryType JNLC or JNLS (optional)
     * @param toAccount The account id that received the journal (optional)
     * @param fromAccount The account id that initiated the journal (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllJournalsCall(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/journals";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (before != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("before", before));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (entryType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entry_type", entryType));
        }

        if (toAccount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_account", toAccount));
        }

        if (fromAccount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_account", fromAccount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllJournalsValidateBeforeCall(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount, final ApiCallback _callback) throws ApiException {
        return getAllJournalsCall(after, before, status, entryType, toAccount, fromAccount, _callback);

    }

    /**
     * Retrieve a List Journals
     * Returns an array of journal objects.
     * @param after By journal creation date. Format: 2020-01-01 (optional)
     * @param before By journal creation date. Format: 2020-01-01 (optional)
     * @param status See the JournalStatus model for more info (optional)
     * @param entryType JNLC or JNLS (optional)
     * @param toAccount The account id that received the journal (optional)
     * @param fromAccount The account id that initiated the journal (optional)
     * @return List&lt;Journal&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<Journal> getAllJournals(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount) throws ApiException {
        ApiResponse<List<Journal>> localVarResp = getAllJournalsWithHttpInfo(after, before, status, entryType, toAccount, fromAccount);
        return localVarResp.getData();
    }

    /**
     * Retrieve a List Journals
     * Returns an array of journal objects.
     * @param after By journal creation date. Format: 2020-01-01 (optional)
     * @param before By journal creation date. Format: 2020-01-01 (optional)
     * @param status See the JournalStatus model for more info (optional)
     * @param entryType JNLC or JNLS (optional)
     * @param toAccount The account id that received the journal (optional)
     * @param fromAccount The account id that initiated the journal (optional)
     * @return ApiResponse&lt;List&lt;Journal&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Journal>> getAllJournalsWithHttpInfo(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount) throws ApiException {
        okhttp3.Call localVarCall = getAllJournalsValidateBeforeCall(after, before, status, entryType, toAccount, fromAccount, null);
        Type localVarReturnType = new TypeToken<List<Journal>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a List Journals (asynchronously)
     * Returns an array of journal objects.
     * @param after By journal creation date. Format: 2020-01-01 (optional)
     * @param before By journal creation date. Format: 2020-01-01 (optional)
     * @param status See the JournalStatus model for more info (optional)
     * @param entryType JNLC or JNLS (optional)
     * @param toAccount The account id that received the journal (optional)
     * @param fromAccount The account id that initiated the journal (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllJournalsAsync(LocalDate after, LocalDate before, String status, String entryType, UUID toAccount, UUID fromAccount, final ApiCallback<List<Journal>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllJournalsValidateBeforeCall(after, before, status, entryType, toAccount, fromAccount, _callback);
        Type localVarReturnType = new TypeToken<List<Journal>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1JournalsJournalId
     * @param journalId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1JournalsJournalIdCall(UUID journalId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/journals/{journal_id}"
            .replace("{" + "journal_id" + "}", localVarApiClient.escapeString(journalId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1JournalsJournalIdValidateBeforeCall(UUID journalId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'journalId' is set
        if (journalId == null) {
            throw new ApiException("Missing the required parameter 'journalId' when calling getV1JournalsJournalId(Async)");
        }

        return getV1JournalsJournalIdCall(journalId, _callback);

    }

    /**
     * Retrieve a Single Journal Entry
     * You can query a specific journal entry that you submitted to Alpaca by passing into the query the journal_id.  Will return a journal entry if a journal entry with journal_id exists, otherwise will throw an error.
     * @param journalId  (required)
     * @return Journal
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Journal getV1JournalsJournalId(UUID journalId) throws ApiException {
        ApiResponse<Journal> localVarResp = getV1JournalsJournalIdWithHttpInfo(journalId);
        return localVarResp.getData();
    }

    /**
     * Retrieve a Single Journal Entry
     * You can query a specific journal entry that you submitted to Alpaca by passing into the query the journal_id.  Will return a journal entry if a journal entry with journal_id exists, otherwise will throw an error.
     * @param journalId  (required)
     * @return ApiResponse&lt;Journal&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Journal> getV1JournalsJournalIdWithHttpInfo(UUID journalId) throws ApiException {
        okhttp3.Call localVarCall = getV1JournalsJournalIdValidateBeforeCall(journalId, null);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a Single Journal Entry (asynchronously)
     * You can query a specific journal entry that you submitted to Alpaca by passing into the query the journal_id.  Will return a journal entry if a journal entry with journal_id exists, otherwise will throw an error.
     * @param journalId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1JournalsJournalIdAsync(UUID journalId, final ApiCallback<Journal> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1JournalsJournalIdValidateBeforeCall(journalId, _callback);
        Type localVarReturnType = new TypeToken<Journal>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1JournalsBatchReverseBatch
     * @param reverseBatchJournalRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid Request Body </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  Insufficient Balance (JNLC) or Insufficient Assets (JNLS) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1JournalsBatchReverseBatchCall(ReverseBatchJournalRequest reverseBatchJournalRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = reverseBatchJournalRequest;

        // create path and map variables
        String localVarPath = "/v1/journals/batch/reverse_batch";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1JournalsBatchReverseBatchValidateBeforeCall(ReverseBatchJournalRequest reverseBatchJournalRequest, final ApiCallback _callback) throws ApiException {
        return postV1JournalsBatchReverseBatchCall(reverseBatchJournalRequest, _callback);

    }

    /**
     * Create a Reverse Batch Journal Transaction (Many-to-One)
     * You can also create a batch journal request by using the following endpoint. This is enabled on JNLC for now only.  Note that if there is an invalid account_id the whole batch operation will be canceled. Every single request must be valid for the entire batch operation to succeed.  In the case of a successful request, the response will contain an array of journal objects with an extra attribute error_message in the case when a specific account fails to submit a journal.
     * @param reverseBatchJournalRequest  (optional)
     * @return List&lt;BatchJournalResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid Request Body </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  Insufficient Balance (JNLC) or Insufficient Assets (JNLS) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account not found </td><td>  -  </td></tr>
     </table>
     */
    public List<BatchJournalResponse> postV1JournalsBatchReverseBatch(ReverseBatchJournalRequest reverseBatchJournalRequest) throws ApiException {
        ApiResponse<List<BatchJournalResponse>> localVarResp = postV1JournalsBatchReverseBatchWithHttpInfo(reverseBatchJournalRequest);
        return localVarResp.getData();
    }

    /**
     * Create a Reverse Batch Journal Transaction (Many-to-One)
     * You can also create a batch journal request by using the following endpoint. This is enabled on JNLC for now only.  Note that if there is an invalid account_id the whole batch operation will be canceled. Every single request must be valid for the entire batch operation to succeed.  In the case of a successful request, the response will contain an array of journal objects with an extra attribute error_message in the case when a specific account fails to submit a journal.
     * @param reverseBatchJournalRequest  (optional)
     * @return ApiResponse&lt;List&lt;BatchJournalResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid Request Body </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  Insufficient Balance (JNLC) or Insufficient Assets (JNLS) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account not found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<BatchJournalResponse>> postV1JournalsBatchReverseBatchWithHttpInfo(ReverseBatchJournalRequest reverseBatchJournalRequest) throws ApiException {
        okhttp3.Call localVarCall = postV1JournalsBatchReverseBatchValidateBeforeCall(reverseBatchJournalRequest, null);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Reverse Batch Journal Transaction (Many-to-One) (asynchronously)
     * You can also create a batch journal request by using the following endpoint. This is enabled on JNLC for now only.  Note that if there is an invalid account_id the whole batch operation will be canceled. Every single request must be valid for the entire batch operation to succeed.  In the case of a successful request, the response will contain an array of journal objects with an extra attribute error_message in the case when a specific account fails to submit a journal.
     * @param reverseBatchJournalRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid Request Body </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  Insufficient Balance (JNLC) or Insufficient Assets (JNLS) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1JournalsBatchReverseBatchAsync(ReverseBatchJournalRequest reverseBatchJournalRequest, final ApiCallback<List<BatchJournalResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1JournalsBatchReverseBatchValidateBeforeCall(reverseBatchJournalRequest, _callback);
        Type localVarReturnType = new TypeToken<List<BatchJournalResponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
