/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.BatchCreateFundingWalletRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchCreateFundingWalletResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateFundingWalletWithdrawalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.DemoFundingTransfer;
import net.jacobpeterson.alpaca.openapi.broker.model.Error;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingDetailPaymentType;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWallet;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletRecipientBank;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletTransfer;
import net.jacobpeterson.alpaca.openapi.broker.model.ListFundingDetails;
import net.jacobpeterson.alpaca.openapi.broker.model.ListTransfersResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FundingWalletsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FundingWalletsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FundingWalletsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for batchCreateFundingWallets
     * @param batchCreateFundingWalletRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Funding wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call batchCreateFundingWalletsCall(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = batchCreateFundingWalletRequest;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/funding_wallet";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call batchCreateFundingWalletsValidateBeforeCall(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'batchCreateFundingWalletRequest' is set
        if (batchCreateFundingWalletRequest == null) {
            throw new ApiException("Missing the required parameter 'batchCreateFundingWalletRequest' when calling batchCreateFundingWallets(Async)");
        }

        return batchCreateFundingWalletsCall(batchCreateFundingWalletRequest, _callback);

    }

    /**
     * Batch create funding wallets
     * 
     * @param batchCreateFundingWalletRequest  (required)
     * @return BatchCreateFundingWalletResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Funding wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    public BatchCreateFundingWalletResponse batchCreateFundingWallets(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest) throws ApiException {
        ApiResponse<BatchCreateFundingWalletResponse> localVarResp = batchCreateFundingWalletsWithHttpInfo(batchCreateFundingWalletRequest);
        return localVarResp.getData();
    }

    /**
     * Batch create funding wallets
     * 
     * @param batchCreateFundingWalletRequest  (required)
     * @return ApiResponse&lt;BatchCreateFundingWalletResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Funding wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<BatchCreateFundingWalletResponse> batchCreateFundingWalletsWithHttpInfo(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest) throws ApiException {
        okhttp3.Call localVarCall = batchCreateFundingWalletsValidateBeforeCall(batchCreateFundingWalletRequest, null);
        Type localVarReturnType = new TypeToken<BatchCreateFundingWalletResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Batch create funding wallets (asynchronously)
     * 
     * @param batchCreateFundingWalletRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Funding wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call batchCreateFundingWalletsAsync(BatchCreateFundingWalletRequest batchCreateFundingWalletRequest, final ApiCallback<BatchCreateFundingWalletResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = batchCreateFundingWalletsValidateBeforeCall(batchCreateFundingWalletRequest, _callback);
        Type localVarReturnType = new TypeToken<BatchCreateFundingWalletResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createFundingWallet
     * @param accountId UUID alpaca account ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createFundingWalletCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createFundingWalletValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createFundingWallet(Async)");
        }

        return createFundingWalletCall(accountId, _callback);

    }

    /**
     * Creates a funding wallet
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return FundingWallet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    public FundingWallet createFundingWallet(String accountId) throws ApiException {
        ApiResponse<FundingWallet> localVarResp = createFundingWalletWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Creates a funding wallet
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return ApiResponse&lt;FundingWallet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<FundingWallet> createFundingWalletWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = createFundingWalletValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Creates a funding wallet (asynchronously)
     * 
     * @param accountId UUID alpaca account ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createFundingWalletAsync(String accountId, final ApiCallback<FundingWallet> _callback) throws ApiException {

        okhttp3.Call localVarCall = createFundingWalletValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createFundingWalletRecipientBank
     * @param accountId UUID alpaca account ID (required)
     * @param bankAccountHolderName Bank account holder&#39;s name. (required)
     * @param bankCountry Two-letter code for the country in which the beneficiary&#39;s bank account is held. (required)
     * @param currency Currency in which money is held in the beneficiary&#39;s bank account. ISO-3 currency code. (required)
     * @param bankName  (optional)
     * @param streetAddress First line of address. (optional)
     * @param accountNumber Bank account number. (optional)
     * @param routingCodeType Local payment routing system. If supplied, routing_code should also be supplied. (optional)
     * @param routingCode Routing code for routing_code_type. If supplied, routing_code_type should also be supplied. (optional)
     * @param bicSwift BIC/SWIFT code (optional)
     * @param iban IBAN code (optional)
     * @param accountType Bank account type. (optional)
     * @param city City (optional)
     * @param postalCode Postal code (optional)
     * @param stateOrProvince State or province. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createFundingWalletRecipientBankCall(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/recipient_bank"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (bankName != null) {
            localVarFormParams.put("bank_name", bankName);
        }

        if (bankAccountHolderName != null) {
            localVarFormParams.put("bank_account_holder_name", bankAccountHolderName);
        }

        if (bankCountry != null) {
            localVarFormParams.put("bank_country", bankCountry);
        }

        if (currency != null) {
            localVarFormParams.put("currency", currency);
        }

        if (streetAddress != null) {
            localVarFormParams.put("street_address", streetAddress);
        }

        if (accountNumber != null) {
            localVarFormParams.put("account_number", accountNumber);
        }

        if (routingCodeType != null) {
            localVarFormParams.put("routing_code_type", routingCodeType);
        }

        if (routingCode != null) {
            localVarFormParams.put("routing_code", routingCode);
        }

        if (bicSwift != null) {
            localVarFormParams.put("bic_swift", bicSwift);
        }

        if (iban != null) {
            localVarFormParams.put("iban", iban);
        }

        if (accountType != null) {
            localVarFormParams.put("account_type", accountType);
        }

        if (city != null) {
            localVarFormParams.put("city", city);
        }

        if (postalCode != null) {
            localVarFormParams.put("postal_code", postalCode);
        }

        if (stateOrProvince != null) {
            localVarFormParams.put("state_or_province", stateOrProvince);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createFundingWalletRecipientBankValidateBeforeCall(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createFundingWalletRecipientBank(Async)");
        }

        // verify the required parameter 'bankAccountHolderName' is set
        if (bankAccountHolderName == null) {
            throw new ApiException("Missing the required parameter 'bankAccountHolderName' when calling createFundingWalletRecipientBank(Async)");
        }

        // verify the required parameter 'bankCountry' is set
        if (bankCountry == null) {
            throw new ApiException("Missing the required parameter 'bankCountry' when calling createFundingWalletRecipientBank(Async)");
        }

        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling createFundingWalletRecipientBank(Async)");
        }

        return createFundingWalletRecipientBankCall(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince, _callback);

    }

    /**
     * Create a recipient bank
     * Creates a new recipient bank. Returns the new recipient bank entity on success. entity.
     * @param accountId UUID alpaca account ID (required)
     * @param bankAccountHolderName Bank account holder&#39;s name. (required)
     * @param bankCountry Two-letter code for the country in which the beneficiary&#39;s bank account is held. (required)
     * @param currency Currency in which money is held in the beneficiary&#39;s bank account. ISO-3 currency code. (required)
     * @param bankName  (optional)
     * @param streetAddress First line of address. (optional)
     * @param accountNumber Bank account number. (optional)
     * @param routingCodeType Local payment routing system. If supplied, routing_code should also be supplied. (optional)
     * @param routingCode Routing code for routing_code_type. If supplied, routing_code_type should also be supplied. (optional)
     * @param bicSwift BIC/SWIFT code (optional)
     * @param iban IBAN code (optional)
     * @param accountType Bank account type. (optional)
     * @param city City (optional)
     * @param postalCode Postal code (optional)
     * @param stateOrProvince State or province. (optional)
     * @return FundingWalletRecipientBank
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    public FundingWalletRecipientBank createFundingWalletRecipientBank(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince) throws ApiException {
        ApiResponse<FundingWalletRecipientBank> localVarResp = createFundingWalletRecipientBankWithHttpInfo(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince);
        return localVarResp.getData();
    }

    /**
     * Create a recipient bank
     * Creates a new recipient bank. Returns the new recipient bank entity on success. entity.
     * @param accountId UUID alpaca account ID (required)
     * @param bankAccountHolderName Bank account holder&#39;s name. (required)
     * @param bankCountry Two-letter code for the country in which the beneficiary&#39;s bank account is held. (required)
     * @param currency Currency in which money is held in the beneficiary&#39;s bank account. ISO-3 currency code. (required)
     * @param bankName  (optional)
     * @param streetAddress First line of address. (optional)
     * @param accountNumber Bank account number. (optional)
     * @param routingCodeType Local payment routing system. If supplied, routing_code should also be supplied. (optional)
     * @param routingCode Routing code for routing_code_type. If supplied, routing_code_type should also be supplied. (optional)
     * @param bicSwift BIC/SWIFT code (optional)
     * @param iban IBAN code (optional)
     * @param accountType Bank account type. (optional)
     * @param city City (optional)
     * @param postalCode Postal code (optional)
     * @param stateOrProvince State or province. (optional)
     * @return ApiResponse&lt;FundingWalletRecipientBank&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<FundingWalletRecipientBank> createFundingWalletRecipientBankWithHttpInfo(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince) throws ApiException {
        okhttp3.Call localVarCall = createFundingWalletRecipientBankValidateBeforeCall(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince, null);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a recipient bank (asynchronously)
     * Creates a new recipient bank. Returns the new recipient bank entity on success. entity.
     * @param accountId UUID alpaca account ID (required)
     * @param bankAccountHolderName Bank account holder&#39;s name. (required)
     * @param bankCountry Two-letter code for the country in which the beneficiary&#39;s bank account is held. (required)
     * @param currency Currency in which money is held in the beneficiary&#39;s bank account. ISO-3 currency code. (required)
     * @param bankName  (optional)
     * @param streetAddress First line of address. (optional)
     * @param accountNumber Bank account number. (optional)
     * @param routingCodeType Local payment routing system. If supplied, routing_code should also be supplied. (optional)
     * @param routingCode Routing code for routing_code_type. If supplied, routing_code_type should also be supplied. (optional)
     * @param bicSwift BIC/SWIFT code (optional)
     * @param iban IBAN code (optional)
     * @param accountType Bank account type. (optional)
     * @param city City (optional)
     * @param postalCode Postal code (optional)
     * @param stateOrProvince State or province. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createFundingWalletRecipientBankAsync(String accountId, String bankAccountHolderName, String bankCountry, String currency, String bankName, String streetAddress, String accountNumber, String routingCodeType, String routingCode, String bicSwift, String iban, String accountType, String city, String postalCode, String stateOrProvince, final ApiCallback<FundingWalletRecipientBank> _callback) throws ApiException {

        okhttp3.Call localVarCall = createFundingWalletRecipientBankValidateBeforeCall(accountId, bankAccountHolderName, bankCountry, currency, bankName, streetAddress, accountNumber, routingCodeType, routingCode, bicSwift, iban, accountType, city, postalCode, stateOrProvince, _callback);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createFundingWalletWithdrawal
     * @param accountId UUID alpaca account ID (required)
     * @param createFundingWalletWithdrawalRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createFundingWalletWithdrawalCall(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createFundingWalletWithdrawalRequest;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/withdrawal"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createFundingWalletWithdrawalValidateBeforeCall(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createFundingWalletWithdrawal(Async)");
        }

        // verify the required parameter 'createFundingWalletWithdrawalRequest' is set
        if (createFundingWalletWithdrawalRequest == null) {
            throw new ApiException("Missing the required parameter 'createFundingWalletWithdrawalRequest' when calling createFundingWalletWithdrawal(Async)");
        }

        return createFundingWalletWithdrawalCall(accountId, createFundingWalletWithdrawalRequest, _callback);

    }

    /**
     * Create a withdrawal
     * Creates a withdrawal
     * @param accountId UUID alpaca account ID (required)
     * @param createFundingWalletWithdrawalRequest  (required)
     * @return FundingWalletTransfer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    public FundingWalletTransfer createFundingWalletWithdrawal(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest) throws ApiException {
        ApiResponse<FundingWalletTransfer> localVarResp = createFundingWalletWithdrawalWithHttpInfo(accountId, createFundingWalletWithdrawalRequest);
        return localVarResp.getData();
    }

    /**
     * Create a withdrawal
     * Creates a withdrawal
     * @param accountId UUID alpaca account ID (required)
     * @param createFundingWalletWithdrawalRequest  (required)
     * @return ApiResponse&lt;FundingWalletTransfer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<FundingWalletTransfer> createFundingWalletWithdrawalWithHttpInfo(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest) throws ApiException {
        okhttp3.Call localVarCall = createFundingWalletWithdrawalValidateBeforeCall(accountId, createFundingWalletWithdrawalRequest, null);
        Type localVarReturnType = new TypeToken<FundingWalletTransfer>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a withdrawal (asynchronously)
     * Creates a withdrawal
     * @param accountId UUID alpaca account ID (required)
     * @param createFundingWalletWithdrawalRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createFundingWalletWithdrawalAsync(String accountId, CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest, final ApiCallback<FundingWalletTransfer> _callback) throws ApiException {

        okhttp3.Call localVarCall = createFundingWalletWithdrawalValidateBeforeCall(accountId, createFundingWalletWithdrawalRequest, _callback);
        Type localVarReturnType = new TypeToken<FundingWalletTransfer>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteFundingWalletRecipientBank
     * @param accountId UUID alpaca account ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteFundingWalletRecipientBankCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/recipient_bank"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteFundingWalletRecipientBankValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteFundingWalletRecipientBank(Async)");
        }

        return deleteFundingWalletRecipientBankCall(accountId, _callback);

    }

    /**
     * Delete a recipient bank
     * deletes a recipient bank.
     * @param accountId UUID alpaca account ID (required)
     * @return FundingWalletRecipientBank
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    public FundingWalletRecipientBank deleteFundingWalletRecipientBank(String accountId) throws ApiException {
        ApiResponse<FundingWalletRecipientBank> localVarResp = deleteFundingWalletRecipientBankWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Delete a recipient bank
     * deletes a recipient bank.
     * @param accountId UUID alpaca account ID (required)
     * @return ApiResponse&lt;FundingWalletRecipientBank&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<FundingWalletRecipientBank> deleteFundingWalletRecipientBankWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = deleteFundingWalletRecipientBankValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete a recipient bank (asynchronously)
     * deletes a recipient bank.
     * @param accountId UUID alpaca account ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteFundingWalletRecipientBankAsync(String accountId, final ApiCallback<FundingWalletRecipientBank> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteFundingWalletRecipientBankValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<FundingWalletRecipientBank>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for demoDepositFunding
     * @param demoFundingTransfer  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Demo deposit funding transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call demoDepositFundingCall(DemoFundingTransfer demoFundingTransfer, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = demoFundingTransfer;

        // create path and map variables
        String localVarPath = "/v1beta/demo/banking/funding";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call demoDepositFundingValidateBeforeCall(DemoFundingTransfer demoFundingTransfer, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'demoFundingTransfer' is set
        if (demoFundingTransfer == null) {
            throw new ApiException("Missing the required parameter 'demoFundingTransfer' when calling demoDepositFunding(Async)");
        }

        return demoDepositFundingCall(demoFundingTransfer, _callback);

    }

    /**
     * Create sandbox deposit transfer
     * 
     * @param demoFundingTransfer  (required)
     * @return DemoFundingTransfer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Demo deposit funding transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    public DemoFundingTransfer demoDepositFunding(DemoFundingTransfer demoFundingTransfer) throws ApiException {
        ApiResponse<DemoFundingTransfer> localVarResp = demoDepositFundingWithHttpInfo(demoFundingTransfer);
        return localVarResp.getData();
    }

    /**
     * Create sandbox deposit transfer
     * 
     * @param demoFundingTransfer  (required)
     * @return ApiResponse&lt;DemoFundingTransfer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Demo deposit funding transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<DemoFundingTransfer> demoDepositFundingWithHttpInfo(DemoFundingTransfer demoFundingTransfer) throws ApiException {
        okhttp3.Call localVarCall = demoDepositFundingValidateBeforeCall(demoFundingTransfer, null);
        Type localVarReturnType = new TypeToken<DemoFundingTransfer>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create sandbox deposit transfer (asynchronously)
     * 
     * @param demoFundingTransfer  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Demo deposit funding transfer </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call demoDepositFundingAsync(DemoFundingTransfer demoFundingTransfer, final ApiCallback<DemoFundingTransfer> _callback) throws ApiException {

        okhttp3.Call localVarCall = demoDepositFundingValidateBeforeCall(demoFundingTransfer, _callback);
        Type localVarReturnType = new TypeToken<DemoFundingTransfer>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFundingWallet
     * @param accountId UUID alpaca account ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getFundingWalletCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFundingWalletValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getFundingWallet(Async)");
        }

        return getFundingWalletCall(accountId, _callback);

    }

    /**
     * Retrieve funding wallet
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return FundingWallet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    public FundingWallet getFundingWallet(String accountId) throws ApiException {
        ApiResponse<FundingWallet> localVarResp = getFundingWalletWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Retrieve funding wallet
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return ApiResponse&lt;FundingWallet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<FundingWallet> getFundingWalletWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getFundingWalletValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve funding wallet (asynchronously)
     * 
     * @param accountId UUID alpaca account ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> funding wallet </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getFundingWalletAsync(String accountId, final ApiCallback<FundingWallet> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFundingWalletValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<FundingWallet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFundingWalletRecipientBank
     * @param accountId UUID alpaca account ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getFundingWalletRecipientBankCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/recipient_bank"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFundingWalletRecipientBankValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getFundingWalletRecipientBank(Async)");
        }

        return getFundingWalletRecipientBankCall(accountId, _callback);

    }

    /**
     * Retrieve recipient bank
     * 
     * @param accountId UUID alpaca account ID (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    public void getFundingWalletRecipientBank(String accountId) throws ApiException {
        getFundingWalletRecipientBankWithHttpInfo(accountId);
    }

    /**
     * Retrieve recipient bank
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> getFundingWalletRecipientBankWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getFundingWalletRecipientBankValidateBeforeCall(accountId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Retrieve recipient bank (asynchronously)
     * 
     * @param accountId UUID alpaca account ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> recipient bank </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Error response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getFundingWalletRecipientBankAsync(String accountId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFundingWalletRecipientBankValidateBeforeCall(accountId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFundingWalletTransfers
     * @param accountId UUID alpaca account ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> transfers </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getFundingWalletTransfersCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/transfers"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFundingWalletTransfersValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getFundingWalletTransfers(Async)");
        }

        return getFundingWalletTransfersCall(accountId, _callback);

    }

    /**
     * Retrieve funding wallet transfers
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return ListTransfersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> transfers </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    public ListTransfersResponse getFundingWalletTransfers(String accountId) throws ApiException {
        ApiResponse<ListTransfersResponse> localVarResp = getFundingWalletTransfersWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Retrieve funding wallet transfers
     * 
     * @param accountId UUID alpaca account ID (required)
     * @return ApiResponse&lt;ListTransfersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> transfers </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<ListTransfersResponse> getFundingWalletTransfersWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getFundingWalletTransfersValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<ListTransfersResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve funding wallet transfers (asynchronously)
     * 
     * @param accountId UUID alpaca account ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> transfers </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getFundingWalletTransfersAsync(String accountId, final ApiCallback<ListTransfersResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFundingWalletTransfersValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<ListTransfersResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listFundingDetails
     * @param accountId UUID alpaca account ID (required)
     * @param paymentType The type of SSI to be returned, priority (SWIFT) or regular (local). A null value returns all payment types. (optional)
     * @param currency Should be provided in ISO 4217 standard (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call listFundingDetailsCall(String accountId, FundingDetailPaymentType paymentType, String currency, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1beta/accounts/{account_id}/funding_wallet/funding_details"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (paymentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("payment_type", paymentType));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFundingDetailsValidateBeforeCall(String accountId, FundingDetailPaymentType paymentType, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listFundingDetails(Async)");
        }

        return listFundingDetailsCall(accountId, paymentType, currency, _callback);

    }

    /**
     * Retrieve funding details
     * Returns a list of funding details if it exists. Query parameters must be passed to create a new funding details object if none exist.
     * @param accountId UUID alpaca account ID (required)
     * @param paymentType The type of SSI to be returned, priority (SWIFT) or regular (local). A null value returns all payment types. (optional)
     * @param currency Should be provided in ISO 4217 standard (optional)
     * @return List&lt;ListFundingDetails&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    public List<ListFundingDetails> listFundingDetails(String accountId, FundingDetailPaymentType paymentType, String currency) throws ApiException {
        ApiResponse<List<ListFundingDetails>> localVarResp = listFundingDetailsWithHttpInfo(accountId, paymentType, currency);
        return localVarResp.getData();
    }

    /**
     * Retrieve funding details
     * Returns a list of funding details if it exists. Query parameters must be passed to create a new funding details object if none exist.
     * @param accountId UUID alpaca account ID (required)
     * @param paymentType The type of SSI to be returned, priority (SWIFT) or regular (local). A null value returns all payment types. (optional)
     * @param currency Should be provided in ISO 4217 standard (optional)
     * @return ApiResponse&lt;List&lt;ListFundingDetails&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<ListFundingDetails>> listFundingDetailsWithHttpInfo(String accountId, FundingDetailPaymentType paymentType, String currency) throws ApiException {
        okhttp3.Call localVarCall = listFundingDetailsValidateBeforeCall(accountId, paymentType, currency, null);
        Type localVarReturnType = new TypeToken<List<ListFundingDetails>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve funding details (asynchronously)
     * Returns a list of funding details if it exists. Query parameters must be passed to create a new funding details object if none exist.
     * @param accountId UUID alpaca account ID (required)
     * @param paymentType The type of SSI to be returned, priority (SWIFT) or regular (local). A null value returns all payment types. (optional)
     * @param currency Should be provided in ISO 4217 standard (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of wallets </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call listFundingDetailsAsync(String accountId, FundingDetailPaymentType paymentType, String currency, final ApiCallback<List<ListFundingDetails>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listFundingDetailsValidateBeforeCall(accountId, paymentType, currency, _callback);
        Type localVarReturnType = new TypeToken<List<ListFundingDetails>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
