/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.ACHRelationship;
import net.jacobpeterson.alpaca.openapi.broker.model.Bank;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateACHRelationshipRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateBankRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateTransferRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.DailyTradingLimit;
import net.jacobpeterson.alpaca.openapi.broker.model.Error;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1TransfersJitLedgerIdBalances200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.JITLedgerAccount;
import net.jacobpeterson.alpaca.openapi.broker.model.JITReport;
import java.time.LocalDate;
import net.jacobpeterson.alpaca.openapi.broker.model.Transfer;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FundingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FundingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FundingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for createACHRelationshipForAccount
     * @param accountId Account identifier. (required)
     * @param createACHRelationshipRequest Create ACH Relationship  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns the newly created ACH Relationship entity. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client is not authorized for this operation. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> The account already has an active relationship. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createACHRelationshipForAccountCall(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createACHRelationshipRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/ach_relationships"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createACHRelationshipForAccountValidateBeforeCall(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createACHRelationshipForAccount(Async)");
        }

        // verify the required parameter 'createACHRelationshipRequest' is set
        if (createACHRelationshipRequest == null) {
            throw new ApiException("Missing the required parameter 'createACHRelationshipRequest' when calling createACHRelationshipForAccount(Async)");
        }

        return createACHRelationshipForAccountCall(accountId, createACHRelationshipRequest, _callback);

    }

    /**
     * Create an ACH Relationship
     * Create a new ACHRelationship for an account  If successful, will return 200 code with a newly created ACH Relationship entity.
     * @param accountId Account identifier. (required)
     * @param createACHRelationshipRequest Create ACH Relationship  (required)
     * @return ACHRelationship
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns the newly created ACH Relationship entity. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client is not authorized for this operation. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> The account already has an active relationship. </td><td>  -  </td></tr>
     </table>
     */
    public ACHRelationship createACHRelationshipForAccount(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest) throws ApiException {
        ApiResponse<ACHRelationship> localVarResp = createACHRelationshipForAccountWithHttpInfo(accountId, createACHRelationshipRequest);
        return localVarResp.getData();
    }

    /**
     * Create an ACH Relationship
     * Create a new ACHRelationship for an account  If successful, will return 200 code with a newly created ACH Relationship entity.
     * @param accountId Account identifier. (required)
     * @param createACHRelationshipRequest Create ACH Relationship  (required)
     * @return ApiResponse&lt;ACHRelationship&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns the newly created ACH Relationship entity. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client is not authorized for this operation. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> The account already has an active relationship. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<ACHRelationship> createACHRelationshipForAccountWithHttpInfo(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest) throws ApiException {
        okhttp3.Call localVarCall = createACHRelationshipForAccountValidateBeforeCall(accountId, createACHRelationshipRequest, null);
        Type localVarReturnType = new TypeToken<ACHRelationship>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an ACH Relationship (asynchronously)
     * Create a new ACHRelationship for an account  If successful, will return 200 code with a newly created ACH Relationship entity.
     * @param accountId Account identifier. (required)
     * @param createACHRelationshipRequest Create ACH Relationship  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns the newly created ACH Relationship entity. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client is not authorized for this operation. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> The account already has an active relationship. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createACHRelationshipForAccountAsync(UUID accountId, CreateACHRelationshipRequest createACHRelationshipRequest, final ApiCallback<ACHRelationship> _callback) throws ApiException {

        okhttp3.Call localVarCall = createACHRelationshipForAccountValidateBeforeCall(accountId, createACHRelationshipRequest, _callback);
        Type localVarReturnType = new TypeToken<ACHRelationship>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createRecipientBank
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createRecipientBankCall(UUID accountId, CreateBankRequest createBankRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createBankRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createRecipientBankValidateBeforeCall(UUID accountId, CreateBankRequest createBankRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createRecipientBank(Async)");
        }

        // verify the required parameter 'createBankRequest' is set
        if (createBankRequest == null) {
            throw new ApiException("Missing the required parameter 'createBankRequest' when calling createRecipientBank(Async)");
        }

        return createRecipientBankCall(accountId, createBankRequest, _callback);

    }

    /**
     * Create a Bank Relationship for an Account
     * If successful, retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @return Bank
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    public Bank createRecipientBank(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        ApiResponse<Bank> localVarResp = createRecipientBankWithHttpInfo(accountId, createBankRequest);
        return localVarResp.getData();
    }

    /**
     * Create a Bank Relationship for an Account
     * If successful, retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @return ApiResponse&lt;Bank&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Bank> createRecipientBankWithHttpInfo(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        okhttp3.Call localVarCall = createRecipientBankValidateBeforeCall(accountId, createBankRequest, null);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Bank Relationship for an Account (asynchronously)
     * If successful, retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createRecipientBankAsync(UUID accountId, CreateBankRequest createBankRequest, final ApiCallback<Bank> _callback) throws ApiException {

        okhttp3.Call localVarCall = createRecipientBankValidateBeforeCall(accountId, createBankRequest, _callback);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTransferForAccount
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createTransferForAccountCall(UUID accountId, CreateTransferRequest createTransferRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createTransferRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/transfers"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTransferForAccountValidateBeforeCall(UUID accountId, CreateTransferRequest createTransferRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createTransferForAccount(Async)");
        }

        // verify the required parameter 'createTransferRequest' is set
        if (createTransferRequest == null) {
            throw new ApiException("Missing the required parameter 'createTransferRequest' when calling createTransferForAccount(Async)");
        }

        return createTransferForAccountCall(accountId, createTransferRequest, _callback);

    }

    /**
     * Request a New Transfer
     * Create a new transfer to an account to fund it.  In the sandbox environment, you can instantly deposit to or withdraw from an account with a virtual money amount. In the production environment, this endpoint is used only for requesting an outgoing (withdrawal) wire transfer at this moment. For the wire transfer (in production), you need to create a bank resource first using the Bank API. For more on how to fund an account in sandbox please check out this tutorial [here](https://alpaca.markets/learn/fund-broker-api/).
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @return Transfer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    public Transfer createTransferForAccount(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        ApiResponse<Transfer> localVarResp = createTransferForAccountWithHttpInfo(accountId, createTransferRequest);
        return localVarResp.getData();
    }

    /**
     * Request a New Transfer
     * Create a new transfer to an account to fund it.  In the sandbox environment, you can instantly deposit to or withdraw from an account with a virtual money amount. In the production environment, this endpoint is used only for requesting an outgoing (withdrawal) wire transfer at this moment. For the wire transfer (in production), you need to create a bank resource first using the Bank API. For more on how to fund an account in sandbox please check out this tutorial [here](https://alpaca.markets/learn/fund-broker-api/).
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @return ApiResponse&lt;Transfer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Transfer> createTransferForAccountWithHttpInfo(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        okhttp3.Call localVarCall = createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, null);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request a New Transfer (asynchronously)
     * Create a new transfer to an account to fund it.  In the sandbox environment, you can instantly deposit to or withdraw from an account with a virtual money amount. In the production environment, this endpoint is used only for requesting an outgoing (withdrawal) wire transfer at this moment. For the wire transfer (in production), you need to create a bank resource first using the Bank API. For more on how to fund an account in sandbox please check out this tutorial [here](https://alpaca.markets/learn/fund-broker-api/).
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createTransferForAccountAsync(UUID accountId, CreateTransferRequest createTransferRequest, final ApiCallback<Transfer> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, _callback);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteACHRelationshipFromAccount
     * @param accountId Account identifier. (required)
     * @param achRelationshipId ACH relationship identifier (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> the passed in account_id or relationship_id were invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Relationship Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteACHRelationshipFromAccountCall(UUID accountId, UUID achRelationshipId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/ach_relationships/{ach_relationship_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "ach_relationship_id" + "}", localVarApiClient.escapeString(achRelationshipId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteACHRelationshipFromAccountValidateBeforeCall(UUID accountId, UUID achRelationshipId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteACHRelationshipFromAccount(Async)");
        }

        // verify the required parameter 'achRelationshipId' is set
        if (achRelationshipId == null) {
            throw new ApiException("Missing the required parameter 'achRelationshipId' when calling deleteACHRelationshipFromAccount(Async)");
        }

        return deleteACHRelationshipFromAccountCall(accountId, achRelationshipId, _callback);

    }

    /**
     * Delete an existing ACH relationship
     * Delete an existing ACH relationship for an account
     * @param accountId Account identifier. (required)
     * @param achRelationshipId ACH relationship identifier (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> the passed in account_id or relationship_id were invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Relationship Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void deleteACHRelationshipFromAccount(UUID accountId, UUID achRelationshipId) throws ApiException {
        deleteACHRelationshipFromAccountWithHttpInfo(accountId, achRelationshipId);
    }

    /**
     * Delete an existing ACH relationship
     * Delete an existing ACH relationship for an account
     * @param accountId Account identifier. (required)
     * @param achRelationshipId ACH relationship identifier (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> the passed in account_id or relationship_id were invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Relationship Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteACHRelationshipFromAccountWithHttpInfo(UUID accountId, UUID achRelationshipId) throws ApiException {
        okhttp3.Call localVarCall = deleteACHRelationshipFromAccountValidateBeforeCall(accountId, achRelationshipId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an existing ACH relationship (asynchronously)
     * Delete an existing ACH relationship for an account
     * @param accountId Account identifier. (required)
     * @param achRelationshipId ACH relationship identifier (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> the passed in account_id or relationship_id were invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Relationship Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteACHRelationshipFromAccountAsync(UUID accountId, UUID achRelationshipId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteACHRelationshipFromAccountValidateBeforeCall(accountId, achRelationshipId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteRecipientBank
     * @param accountId Account identifier. (required)
     * @param bankId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No Bank Relationship with the id specified by bank_id was found for this Account </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteRecipientBankCall(UUID accountId, UUID bankId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks/{bank_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "bank_id" + "}", localVarApiClient.escapeString(bankId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteRecipientBankValidateBeforeCall(UUID accountId, UUID bankId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteRecipientBank(Async)");
        }

        // verify the required parameter 'bankId' is set
        if (bankId == null) {
            throw new ApiException("Missing the required parameter 'bankId' when calling deleteRecipientBank(Async)");
        }

        return deleteRecipientBankCall(accountId, bankId, _callback);

    }

    /**
     * Delete a Bank Relationship for an Account
     * If successful, deletes Bank Relationship for an account
     * @param accountId Account identifier. (required)
     * @param bankId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No Bank Relationship with the id specified by bank_id was found for this Account </td><td>  -  </td></tr>
     </table>
     */
    public void deleteRecipientBank(UUID accountId, UUID bankId) throws ApiException {
        deleteRecipientBankWithHttpInfo(accountId, bankId);
    }

    /**
     * Delete a Bank Relationship for an Account
     * If successful, deletes Bank Relationship for an account
     * @param accountId Account identifier. (required)
     * @param bankId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No Bank Relationship with the id specified by bank_id was found for this Account </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteRecipientBankWithHttpInfo(UUID accountId, UUID bankId) throws ApiException {
        okhttp3.Call localVarCall = deleteRecipientBankValidateBeforeCall(accountId, bankId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete a Bank Relationship for an Account (asynchronously)
     * If successful, deletes Bank Relationship for an account
     * @param accountId Account identifier. (required)
     * @param bankId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No Bank Relationship with the id specified by bank_id was found for this Account </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteRecipientBankAsync(UUID accountId, UUID bankId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteRecipientBankValidateBeforeCall(accountId, bankId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTransfer
     * @param accountId Account identifier. (required)
     * @param transferId Tranfer identifier (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Transfer Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteTransferCall(UUID accountId, UUID transferId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/transfers/{transfer_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "transfer_id" + "}", localVarApiClient.escapeString(transferId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTransferValidateBeforeCall(UUID accountId, UUID transferId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteTransfer(Async)");
        }

        // verify the required parameter 'transferId' is set
        if (transferId == null) {
            throw new ApiException("Missing the required parameter 'transferId' when calling deleteTransfer(Async)");
        }

        return deleteTransferCall(accountId, transferId, _callback);

    }

    /**
     * Request to Close a Transfer
     * Request to close a transfer
     * @param accountId Account identifier. (required)
     * @param transferId Tranfer identifier (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Transfer Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTransfer(UUID accountId, UUID transferId) throws ApiException {
        deleteTransferWithHttpInfo(accountId, transferId);
    }

    /**
     * Request to Close a Transfer
     * Request to close a transfer
     * @param accountId Account identifier. (required)
     * @param transferId Tranfer identifier (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Transfer Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteTransferWithHttpInfo(UUID accountId, UUID transferId) throws ApiException {
        okhttp3.Call localVarCall = deleteTransferValidateBeforeCall(accountId, transferId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Request to Close a Transfer (asynchronously)
     * Request to close a transfer
     * @param accountId Account identifier. (required)
     * @param transferId Tranfer identifier (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Transfer Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteTransferAsync(UUID accountId, UUID transferId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTransferValidateBeforeCall(accountId, transferId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountACHRelationships
     * @param accountId Account identifier. (required)
     * @param statuses Comma-separated status values (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountACHRelationshipsCall(UUID accountId, String statuses, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/ach_relationships"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (statuses != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("statuses", statuses));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountACHRelationshipsValidateBeforeCall(UUID accountId, String statuses, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountACHRelationships(Async)");
        }

        return getAccountACHRelationshipsCall(accountId, statuses, _callback);

    }

    /**
     * Retrieve ACH Relationships for an account
     * Returns a list of ACH Relationships for an account
     * @param accountId Account identifier. (required)
     * @param statuses Comma-separated status values (optional)
     * @return List&lt;ACHRelationship&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public List<ACHRelationship> getAccountACHRelationships(UUID accountId, String statuses) throws ApiException {
        ApiResponse<List<ACHRelationship>> localVarResp = getAccountACHRelationshipsWithHttpInfo(accountId, statuses);
        return localVarResp.getData();
    }

    /**
     * Retrieve ACH Relationships for an account
     * Returns a list of ACH Relationships for an account
     * @param accountId Account identifier. (required)
     * @param statuses Comma-separated status values (optional)
     * @return ApiResponse&lt;List&lt;ACHRelationship&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<ACHRelationship>> getAccountACHRelationshipsWithHttpInfo(UUID accountId, String statuses) throws ApiException {
        okhttp3.Call localVarCall = getAccountACHRelationshipsValidateBeforeCall(accountId, statuses, null);
        Type localVarReturnType = new TypeToken<List<ACHRelationship>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve ACH Relationships for an account (asynchronously)
     * Returns a list of ACH Relationships for an account
     * @param accountId Account identifier. (required)
     * @param statuses Comma-separated status values (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountACHRelationshipsAsync(UUID accountId, String statuses, final ApiCallback<List<ACHRelationship>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountACHRelationshipsValidateBeforeCall(accountId, statuses, _callback);
        Type localVarReturnType = new TypeToken<List<ACHRelationship>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRecipientBanks
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getRecipientBanksCall(UUID accountId, String status, String bankName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (bankName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("bank_name", bankName));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRecipientBanksValidateBeforeCall(UUID accountId, String status, String bankName, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getRecipientBanks(Async)");
        }

        return getRecipientBanksCall(accountId, status, bankName, _callback);

    }

    /**
     * Retrieve Bank Relationships for an Account
     * Retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @return List&lt;Bank&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    public List<Bank> getRecipientBanks(UUID accountId, String status, String bankName) throws ApiException {
        ApiResponse<List<Bank>> localVarResp = getRecipientBanksWithHttpInfo(accountId, status, bankName);
        return localVarResp.getData();
    }

    /**
     * Retrieve Bank Relationships for an Account
     * Retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @return ApiResponse&lt;List&lt;Bank&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Bank>> getRecipientBanksWithHttpInfo(UUID accountId, String status, String bankName) throws ApiException {
        okhttp3.Call localVarCall = getRecipientBanksValidateBeforeCall(accountId, status, bankName, null);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Bank Relationships for an Account (asynchronously)
     * Retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getRecipientBanksAsync(UUID accountId, String status, String bankName, final ApiCallback<List<Bank>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRecipientBanksValidateBeforeCall(accountId, status, bankName, _callback);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTransfersForAccount
     * @param accountId Account identifier. (required)
     * @param direction INCOMING or OUTGOING (optional)
     * @param limit  (optional)
     * @param offset  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getTransfersForAccountCall(UUID accountId, String direction, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/transfers"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (direction != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("direction", direction));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTransfersForAccountValidateBeforeCall(UUID accountId, String direction, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getTransfersForAccount(Async)");
        }

        return getTransfersForAccountCall(accountId, direction, limit, offset, _callback);

    }

    /**
     * Retrieve List of Transfers for an Account.
     * You can query a list of transfers for an account.   You can filter requested transfers by values such as direction and status.  Returns a list of transfer entities ordered by created_at 
     * @param accountId Account identifier. (required)
     * @param direction INCOMING or OUTGOING (optional)
     * @param limit  (optional)
     * @param offset  (optional)
     * @return List&lt;Transfer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
     </table>
     */
    public List<Transfer> getTransfersForAccount(UUID accountId, String direction, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<Transfer>> localVarResp = getTransfersForAccountWithHttpInfo(accountId, direction, limit, offset);
        return localVarResp.getData();
    }

    /**
     * Retrieve List of Transfers for an Account.
     * You can query a list of transfers for an account.   You can filter requested transfers by values such as direction and status.  Returns a list of transfer entities ordered by created_at 
     * @param accountId Account identifier. (required)
     * @param direction INCOMING or OUTGOING (optional)
     * @param limit  (optional)
     * @param offset  (optional)
     * @return ApiResponse&lt;List&lt;Transfer&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Transfer>> getTransfersForAccountWithHttpInfo(UUID accountId, String direction, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = getTransfersForAccountValidateBeforeCall(accountId, direction, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<Transfer>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve List of Transfers for an Account. (asynchronously)
     * You can query a list of transfers for an account.   You can filter requested transfers by values such as direction and status.  Returns a list of transfer entities ordered by created_at 
     * @param accountId Account identifier. (required)
     * @param direction INCOMING or OUTGOING (optional)
     * @param limit  (optional)
     * @param offset  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getTransfersForAccountAsync(UUID accountId, String direction, Integer limit, Integer offset, final ApiCallback<List<Transfer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTransfersForAccountValidateBeforeCall(accountId, direction, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<Transfer>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1TransfersJitLedgerIdBalances
     * @param ledgerId  (required)
     * @param startDate The start date (inclusive) of the ledgerbalances and activities. (optional)
     * @param endDate The end date (inclusive) of the ledgerbalances and activities. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitLedgerIdBalancesCall(String ledgerId, LocalDate startDate, LocalDate endDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/transfers/jit/{ledger_id}/balances"
            .replace("{" + "ledger_id" + "}", localVarApiClient.escapeString(ledgerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_date", startDate));
        }

        if (endDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_date", endDate));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1TransfersJitLedgerIdBalancesValidateBeforeCall(String ledgerId, LocalDate startDate, LocalDate endDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'ledgerId' is set
        if (ledgerId == null) {
            throw new ApiException("Missing the required parameter 'ledgerId' when calling getV1TransfersJitLedgerIdBalances(Async)");
        }

        return getV1TransfersJitLedgerIdBalancesCall(ledgerId, startDate, endDate, _callback);

    }

    /**
     * Retrieve JIT Ledger Balances
     * Returns an array of objects that correspond to each ledger account.
     * @param ledgerId  (required)
     * @param startDate The start date (inclusive) of the ledgerbalances and activities. (optional)
     * @param endDate The end date (inclusive) of the ledgerbalances and activities. (optional)
     * @return GetV1TransfersJitLedgerIdBalances200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GetV1TransfersJitLedgerIdBalances200Response getV1TransfersJitLedgerIdBalances(String ledgerId, LocalDate startDate, LocalDate endDate) throws ApiException {
        ApiResponse<GetV1TransfersJitLedgerIdBalances200Response> localVarResp = getV1TransfersJitLedgerIdBalancesWithHttpInfo(ledgerId, startDate, endDate);
        return localVarResp.getData();
    }

    /**
     * Retrieve JIT Ledger Balances
     * Returns an array of objects that correspond to each ledger account.
     * @param ledgerId  (required)
     * @param startDate The start date (inclusive) of the ledgerbalances and activities. (optional)
     * @param endDate The end date (inclusive) of the ledgerbalances and activities. (optional)
     * @return ApiResponse&lt;GetV1TransfersJitLedgerIdBalances200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetV1TransfersJitLedgerIdBalances200Response> getV1TransfersJitLedgerIdBalancesWithHttpInfo(String ledgerId, LocalDate startDate, LocalDate endDate) throws ApiException {
        okhttp3.Call localVarCall = getV1TransfersJitLedgerIdBalancesValidateBeforeCall(ledgerId, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<GetV1TransfersJitLedgerIdBalances200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve JIT Ledger Balances (asynchronously)
     * Returns an array of objects that correspond to each ledger account.
     * @param ledgerId  (required)
     * @param startDate The start date (inclusive) of the ledgerbalances and activities. (optional)
     * @param endDate The end date (inclusive) of the ledgerbalances and activities. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitLedgerIdBalancesAsync(String ledgerId, LocalDate startDate, LocalDate endDate, final ApiCallback<GetV1TransfersJitLedgerIdBalances200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1TransfersJitLedgerIdBalancesValidateBeforeCall(ledgerId, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<GetV1TransfersJitLedgerIdBalances200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1TransfersJitLedgers
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitLedgersCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/transfers/jit/ledgers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1TransfersJitLedgersValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getV1TransfersJitLedgersCall(_callback);

    }

    /**
     * Retrieve JIT Ledgers
     * Returns an array of objects that correspond to each ledger account, each of whichcontain the following attributes.
     * @return List&lt;JITLedgerAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<JITLedgerAccount> getV1TransfersJitLedgers() throws ApiException {
        ApiResponse<List<JITLedgerAccount>> localVarResp = getV1TransfersJitLedgersWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Retrieve JIT Ledgers
     * Returns an array of objects that correspond to each ledger account, each of whichcontain the following attributes.
     * @return ApiResponse&lt;List&lt;JITLedgerAccount&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<JITLedgerAccount>> getV1TransfersJitLedgersWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getV1TransfersJitLedgersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<JITLedgerAccount>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve JIT Ledgers (asynchronously)
     * Returns an array of objects that correspond to each ledger account, each of whichcontain the following attributes.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitLedgersAsync(final ApiCallback<List<JITLedgerAccount>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1TransfersJitLedgersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<JITLedgerAccount>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1TransfersJitLimits
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the JIT Securities Daily Trading Limit Object based off of real time calculations. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitLimitsCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/transfers/jit/limits";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1TransfersJitLimitsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getV1TransfersJitLimitsCall(_callback);

    }

    /**
     * Retrieve Daily Trading Limits
     * The JIT Securities daily trading limit is set at the correspondent level and is used as the limit for the total amount due to Alpaca on the date of settlement. The limit in use returns the real time usage of this limit and is calculated by taking the net of trade and non-trade activity inflows and outflows. If the limit in use reaches the daily net limit, further purchasing activity will be halted, however, the limit can be adjusted by reaching out to Alpaca with the proposed new limit and the reason for the change.
     * @return DailyTradingLimit
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the JIT Securities Daily Trading Limit Object based off of real time calculations. </td><td>  -  </td></tr>
     </table>
     */
    public DailyTradingLimit getV1TransfersJitLimits() throws ApiException {
        ApiResponse<DailyTradingLimit> localVarResp = getV1TransfersJitLimitsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Retrieve Daily Trading Limits
     * The JIT Securities daily trading limit is set at the correspondent level and is used as the limit for the total amount due to Alpaca on the date of settlement. The limit in use returns the real time usage of this limit and is calculated by taking the net of trade and non-trade activity inflows and outflows. If the limit in use reaches the daily net limit, further purchasing activity will be halted, however, the limit can be adjusted by reaching out to Alpaca with the proposed new limit and the reason for the change.
     * @return ApiResponse&lt;DailyTradingLimit&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the JIT Securities Daily Trading Limit Object based off of real time calculations. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<DailyTradingLimit> getV1TransfersJitLimitsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getV1TransfersJitLimitsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<DailyTradingLimit>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Daily Trading Limits (asynchronously)
     * The JIT Securities daily trading limit is set at the correspondent level and is used as the limit for the total amount due to Alpaca on the date of settlement. The limit in use returns the real time usage of this limit and is calculated by taking the net of trade and non-trade activity inflows and outflows. If the limit in use reaches the daily net limit, further purchasing activity will be halted, however, the limit can be adjusted by reaching out to Alpaca with the proposed new limit and the reason for the change.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the JIT Securities Daily Trading Limit Object based off of real time calculations. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitLimitsAsync(final ApiCallback<DailyTradingLimit> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1TransfersJitLimitsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<DailyTradingLimit>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1TransfersJitReports
     * @param reportType The type of report you want to get. (required)
     * @param systemDate Date of file generation. (required)
     * @param assetClass The asset class to retrieve for. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitReportsCall(String reportType, LocalDate systemDate, String assetClass, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/transfers/jit/reports";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (reportType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("report_type", reportType));
        }

        if (systemDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("system_date", systemDate));
        }

        if (assetClass != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asset_class", assetClass));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1TransfersJitReportsValidateBeforeCall(String reportType, LocalDate systemDate, String assetClass, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'reportType' is set
        if (reportType == null) {
            throw new ApiException("Missing the required parameter 'reportType' when calling getV1TransfersJitReports(Async)");
        }

        // verify the required parameter 'systemDate' is set
        if (systemDate == null) {
            throw new ApiException("Missing the required parameter 'systemDate' when calling getV1TransfersJitReports(Async)");
        }

        return getV1TransfersJitReportsCall(reportType, systemDate, assetClass, _callback);

    }

    /**
     * Retrieve JIT Reports
     * Returns all JIT reports
     * @param reportType The type of report you want to get. (required)
     * @param systemDate Date of file generation. (required)
     * @param assetClass The asset class to retrieve for. (optional)
     * @return JITReport
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public JITReport getV1TransfersJitReports(String reportType, LocalDate systemDate, String assetClass) throws ApiException {
        ApiResponse<JITReport> localVarResp = getV1TransfersJitReportsWithHttpInfo(reportType, systemDate, assetClass);
        return localVarResp.getData();
    }

    /**
     * Retrieve JIT Reports
     * Returns all JIT reports
     * @param reportType The type of report you want to get. (required)
     * @param systemDate Date of file generation. (required)
     * @param assetClass The asset class to retrieve for. (optional)
     * @return ApiResponse&lt;JITReport&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<JITReport> getV1TransfersJitReportsWithHttpInfo(String reportType, LocalDate systemDate, String assetClass) throws ApiException {
        okhttp3.Call localVarCall = getV1TransfersJitReportsValidateBeforeCall(reportType, systemDate, assetClass, null);
        Type localVarReturnType = new TypeToken<JITReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve JIT Reports (asynchronously)
     * Returns all JIT reports
     * @param reportType The type of report you want to get. (required)
     * @param systemDate Date of file generation. (required)
     * @param assetClass The asset class to retrieve for. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TransfersJitReportsAsync(String reportType, LocalDate systemDate, String assetClass, final ApiCallback<JITReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1TransfersJitReportsValidateBeforeCall(reportType, systemDate, assetClass, _callback);
        Type localVarReturnType = new TypeToken<JITReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
