/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatusEvent;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatusEvent;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.broker.model.SubscribeToAdminActionSSE200ResponseInner;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEvent;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEventV2;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferStatusEvent;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public EventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for getV1EventsNta
     * @param id  (optional)
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param includePreprocessing  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getV1EventsNtaCall(String id, String since, String until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, Boolean includePreprocessing, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/events/nta";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (sinceUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_ulid", sinceUlid));
        }

        if (untilUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_ulid", untilUlid));
        }

        if (includePreprocessing != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("include_preprocessing", includePreprocessing));
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1EventsNtaValidateBeforeCall(String id, String since, String until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, Boolean includePreprocessing, final ApiCallback _callback) throws ApiException {
        return getV1EventsNtaCall(id, since, until, sinceId, untilId, sinceUlid, untilUlid, includePreprocessing, _callback);

    }

    /**
     * Subscribe to Non-Trading Activities Events (SSE)
     * You can listen to when NTAs are pushed such as CSDs, JNLC (journals) or FEEs.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)&#39;
     * @param id  (optional)
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param includePreprocessing  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public void getV1EventsNta(String id, String since, String until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, Boolean includePreprocessing) throws ApiException {
        getV1EventsNtaWithHttpInfo(id, since, until, sinceId, untilId, sinceUlid, untilUlid, includePreprocessing);
    }

    /**
     * Subscribe to Non-Trading Activities Events (SSE)
     * You can listen to when NTAs are pushed such as CSDs, JNLC (journals) or FEEs.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)&#39;
     * @param id  (optional)
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param includePreprocessing  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> getV1EventsNtaWithHttpInfo(String id, String since, String until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, Boolean includePreprocessing) throws ApiException {
        okhttp3.Call localVarCall = getV1EventsNtaValidateBeforeCall(id, since, until, sinceId, untilId, sinceUlid, untilUlid, includePreprocessing, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Subscribe to Non-Trading Activities Events (SSE) (asynchronously)
     * You can listen to when NTAs are pushed such as CSDs, JNLC (journals) or FEEs.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)&#39;
     * @param id  (optional)
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param includePreprocessing  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getV1EventsNtaAsync(String id, String since, String until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, Boolean includePreprocessing, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1EventsNtaValidateBeforeCall(id, since, until, sinceId, untilId, sinceUlid, untilUlid, includePreprocessing, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeToAdminActionSSE
     * @param since Format: RFC3339 or YYYY-MM-DD (optional)
     * @param until Format: RFC3339 or YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToAdminActionSSECall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2beta1/events/admin-actions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeToAdminActionSSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback _callback) throws ApiException {
        return subscribeToAdminActionSSECall(since, until, sinceId, untilId, _callback);

    }

    /**
     * Subscribe to Admin Action Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  This endpoint streams events related to administrative actions performed by our systems.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Warning: Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API.  In case the client code is generated from this OAS spec, don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang forever waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific endpoint until the OAS-3 standards come to a consensus on how to represent this behavior in OAS-3.  ---  **Event Types**  - **LegacyNote:** Old free text based admin notes - **Liquidation:** Event for a position liquidation which initialized by an admin - **TransactionCancel:** Event for a manually cancelled transaction
     * @param since Format: RFC3339 or YYYY-MM-DD (optional)
     * @param until Format: RFC3339 or YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @return List&lt;SubscribeToAdminActionSSE200ResponseInner&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<SubscribeToAdminActionSSE200ResponseInner> subscribeToAdminActionSSE(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        ApiResponse<List<SubscribeToAdminActionSSE200ResponseInner>> localVarResp = subscribeToAdminActionSSEWithHttpInfo(since, until, sinceId, untilId);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Admin Action Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  This endpoint streams events related to administrative actions performed by our systems.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Warning: Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API.  In case the client code is generated from this OAS spec, don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang forever waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific endpoint until the OAS-3 standards come to a consensus on how to represent this behavior in OAS-3.  ---  **Event Types**  - **LegacyNote:** Old free text based admin notes - **Liquidation:** Event for a position liquidation which initialized by an admin - **TransactionCancel:** Event for a manually cancelled transaction
     * @param since Format: RFC3339 or YYYY-MM-DD (optional)
     * @param until Format: RFC3339 or YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @return ApiResponse&lt;List&lt;SubscribeToAdminActionSSE200ResponseInner&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<SubscribeToAdminActionSSE200ResponseInner>> subscribeToAdminActionSSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        okhttp3.Call localVarCall = subscribeToAdminActionSSEValidateBeforeCall(since, until, sinceId, untilId, null);
        Type localVarReturnType = new TypeToken<List<SubscribeToAdminActionSSE200ResponseInner>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Admin Action Events (SSE) (asynchronously)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  This endpoint streams events related to administrative actions performed by our systems.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Warning: Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API.  In case the client code is generated from this OAS spec, don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang forever waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific endpoint until the OAS-3 standards come to a consensus on how to represent this behavior in OAS-3.  ---  **Event Types**  - **LegacyNote:** Old free text based admin notes - **Liquidation:** Event for a position liquidation which initialized by an admin - **TransactionCancel:** Event for a manually cancelled transaction
     * @param since Format: RFC3339 or YYYY-MM-DD (optional)
     * @param until Format: RFC3339 or YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToAdminActionSSEAsync(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback<List<SubscribeToAdminActionSSE200ResponseInner>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeToAdminActionSSEValidateBeforeCall(since, until, sinceId, untilId, _callback);
        Type localVarReturnType = new TypeToken<List<SubscribeToAdminActionSSE200ResponseInner>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeToJournalStatusSSE
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToJournalStatusSSECall(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/events/journals/status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (sinceUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_ulid", sinceUlid));
        }

        if (untilUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_ulid", untilUlid));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeToJournalStatusSSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, final ApiCallback _callback) throws ApiException {
        return subscribeToJournalStatusSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, _callback);

    }

    /**
     * Subscribe to Journal Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to journal status updates as they get processed by our backoffice.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3. 
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @return List&lt;JournalStatusEvent&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<JournalStatusEvent> subscribeToJournalStatusSSE(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id) throws ApiException {
        ApiResponse<List<JournalStatusEvent>> localVarResp = subscribeToJournalStatusSSEWithHttpInfo(since, until, sinceId, untilId, sinceUlid, untilUlid, id);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Journal Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to journal status updates as they get processed by our backoffice.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3. 
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @return ApiResponse&lt;List&lt;JournalStatusEvent&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<JournalStatusEvent>> subscribeToJournalStatusSSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id) throws ApiException {
        okhttp3.Call localVarCall = subscribeToJournalStatusSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, null);
        Type localVarReturnType = new TypeToken<List<JournalStatusEvent>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Journal Events (SSE) (asynchronously)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to journal status updates as they get processed by our backoffice.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3. 
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToJournalStatusSSEAsync(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, final ApiCallback<List<JournalStatusEvent>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeToJournalStatusSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, _callback);
        Type localVarReturnType = new TypeToken<List<JournalStatusEvent>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeToTradeSSE
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToTradeSSECall(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/events/trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (sinceUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_ulid", sinceUlid));
        }

        if (untilUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_ulid", untilUlid));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeToTradeSSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, final ApiCallback _callback) throws ApiException {
        return subscribeToTradeSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, _callback);

    }

    /**
     * Subscribe to Trade Events (SSE) (Legacy)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Deprecation note**  Legacy event id (integer based) is unavailable for new broker partners, and it will be deprecated for existing brokers as well. This deprecation is includes the &#x60;since_id&#x60; and &#x60;until_id&#x60; query parameter and the &#x60;event_id&#x60; field in the response.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @return List&lt;TradeUpdateEvent&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<TradeUpdateEvent> subscribeToTradeSSE(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid) throws ApiException {
        ApiResponse<List<TradeUpdateEvent>> localVarResp = subscribeToTradeSSEWithHttpInfo(since, until, sinceId, untilId, sinceUlid, untilUlid);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Trade Events (SSE) (Legacy)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Deprecation note**  Legacy event id (integer based) is unavailable for new broker partners, and it will be deprecated for existing brokers as well. This deprecation is includes the &#x60;since_id&#x60; and &#x60;until_id&#x60; query parameter and the &#x60;event_id&#x60; field in the response.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @return ApiResponse&lt;List&lt;TradeUpdateEvent&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TradeUpdateEvent>> subscribeToTradeSSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid) throws ApiException {
        okhttp3.Call localVarCall = subscribeToTradeSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, null);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEvent>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Trade Events (SSE) (Legacy) (asynchronously)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Deprecation note**  Legacy event id (integer based) is unavailable for new broker partners, and it will be deprecated for existing brokers as well. This deprecation is includes the &#x60;since_id&#x60; and &#x60;until_id&#x60; query parameter and the &#x60;event_id&#x60; field in the response.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToTradeSSEAsync(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, final ApiCallback<List<TradeUpdateEvent>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeToTradeSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, _callback);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEvent>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeToTradeV2SSE
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToTradeV2SSECall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2beta1/events/trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeToTradeV2SSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback _callback) throws ApiException {
        return subscribeToTradeV2SSECall(since, until, sinceId, untilId, _callback);

    }

    /**
     * Subscribe to Trade Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Legacy trade events API**  The legacy trade events API is available for compatibility reasons at:  &#x60;GET /v1/events/trades&#x60;  Broker partners are recommended to upgrade to the /v2beta1/events/trades endpoint, which provides faster event delivery times.  The legacy trade events api works the same way as the new one with the exception of the event_id which is an integer except of an ULID. This results in the request’s since_id and until_id are also being integers. This integer is monotonically increasing over time for events.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected.   - timestamp: The time at which the rejection occurred. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @return List&lt;TradeUpdateEventV2&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<TradeUpdateEventV2> subscribeToTradeV2SSE(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        ApiResponse<List<TradeUpdateEventV2>> localVarResp = subscribeToTradeV2SSEWithHttpInfo(since, until, sinceId, untilId);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Trade Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Legacy trade events API**  The legacy trade events API is available for compatibility reasons at:  &#x60;GET /v1/events/trades&#x60;  Broker partners are recommended to upgrade to the /v2beta1/events/trades endpoint, which provides faster event delivery times.  The legacy trade events api works the same way as the new one with the exception of the event_id which is an integer except of an ULID. This results in the request’s since_id and until_id are also being integers. This integer is monotonically increasing over time for events.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected.   - timestamp: The time at which the rejection occurred. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @return ApiResponse&lt;List&lt;TradeUpdateEventV2&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TradeUpdateEventV2>> subscribeToTradeV2SSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        okhttp3.Call localVarCall = subscribeToTradeV2SSEValidateBeforeCall(since, until, sinceId, untilId, null);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEventV2>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Trade Events (SSE) (asynchronously)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Legacy trade events API**  The legacy trade events API is available for compatibility reasons at:  &#x60;GET /v1/events/trades&#x60;  Broker partners are recommended to upgrade to the /v2beta1/events/trades endpoint, which provides faster event delivery times.  The legacy trade events api works the same way as the new one with the exception of the event_id which is an integer except of an ULID. This results in the request’s since_id and until_id are also being integers. This integer is monotonically increasing over time for events.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected.   - timestamp: The time at which the rejection occurred. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToTradeV2SSEAsync(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback<List<TradeUpdateEventV2>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeToTradeV2SSEValidateBeforeCall(since, until, sinceId, untilId, _callback);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEventV2>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeToTransferStatusSSE
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToTransferStatusSSECall(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/events/transfers/status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (sinceUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_ulid", sinceUlid));
        }

        if (untilUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_ulid", untilUlid));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeToTransferStatusSSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, final ApiCallback _callback) throws ApiException {
        return subscribeToTransferStatusSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, _callback);

    }

    /**
     * Subscribe to Transfer Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to transfer status updates as they get processed by our backoffice, for both end-user and firm accounts.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @return List&lt;TransferStatusEvent&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<TransferStatusEvent> subscribeToTransferStatusSSE(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid) throws ApiException {
        ApiResponse<List<TransferStatusEvent>> localVarResp = subscribeToTransferStatusSSEWithHttpInfo(since, until, sinceId, untilId, sinceUlid, untilUlid);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Transfer Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to transfer status updates as they get processed by our backoffice, for both end-user and firm accounts.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @return ApiResponse&lt;List&lt;TransferStatusEvent&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransferStatusEvent>> subscribeToTransferStatusSSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid) throws ApiException {
        okhttp3.Call localVarCall = subscribeToTransferStatusSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, null);
        Type localVarReturnType = new TypeToken<List<TransferStatusEvent>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Transfer Events (SSE) (asynchronously)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to transfer status updates as they get processed by our backoffice, for both end-user and firm accounts.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeToTransferStatusSSEAsync(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, final ApiCallback<List<TransferStatusEvent>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeToTransferStatusSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, _callback);
        Type localVarReturnType = new TypeToken<List<TransferStatusEvent>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for suscribeToAccountStatusSSE
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call suscribeToAccountStatusSSECall(LocalDate since, LocalDate until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/events/accounts/status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (sinceUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_ulid", sinceUlid));
        }

        if (untilUlid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_ulid", untilUlid));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call suscribeToAccountStatusSSEValidateBeforeCall(LocalDate since, LocalDate until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, final ApiCallback _callback) throws ApiException {
        return suscribeToAccountStatusSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, _callback);

    }

    /**
     * Subscribe to Account Status Events (SSE)
     * Events API provide event push as well as historical queries via SSE (server sent events).  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3. 
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @return List&lt;AccountStatusEvent&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<AccountStatusEvent> suscribeToAccountStatusSSE(LocalDate since, LocalDate until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id) throws ApiException {
        ApiResponse<List<AccountStatusEvent>> localVarResp = suscribeToAccountStatusSSEWithHttpInfo(since, until, sinceId, untilId, sinceUlid, untilUlid, id);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Account Status Events (SSE)
     * Events API provide event push as well as historical queries via SSE (server sent events).  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3. 
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @return ApiResponse&lt;List&lt;AccountStatusEvent&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<AccountStatusEvent>> suscribeToAccountStatusSSEWithHttpInfo(LocalDate since, LocalDate until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id) throws ApiException {
        okhttp3.Call localVarCall = suscribeToAccountStatusSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, null);
        Type localVarReturnType = new TypeToken<List<AccountStatusEvent>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Account Status Events (SSE) (asynchronously)
     * Events API provide event push as well as historical queries via SSE (server sent events).  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since_ulid&#x60; required if &#x60;until_ulid&#x60; specified - &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60;  can’t be used at the same time Behavior: - if &#x60;since&#x60;, &#x60;since_id&#x60; or &#x60;since_ulid&#x60; not specified this will not return any historic data - if &#x60;until&#x60;, &#x60;until_id&#x60; or &#x60;until_ulid&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3. 
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param sinceUlid  (optional)
     * @param untilUlid  (optional)
     * @param id  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call suscribeToAccountStatusSSEAsync(LocalDate since, LocalDate until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, final ApiCallback<List<AccountStatusEvent>> _callback) throws ApiException {

        okhttp3.Call localVarCall = suscribeToAccountStatusSSEValidateBeforeCall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, _callback);
        Type localVarReturnType = new TypeToken<List<AccountStatusEvent>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
