/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.DocumentInner;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentUploadRequest;
import java.time.LocalDate;
import java.util.Set;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for downloadDocFromAccount
     * @param accountId Account identifier. (required)
     * @param documentId Document identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document is not found. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call downloadDocFromAccountCall(UUID accountId, UUID documentId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/documents/{document_id}/download"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadDocFromAccountValidateBeforeCall(UUID accountId, UUID documentId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling downloadDocFromAccount(Async)");
        }

        // verify the required parameter 'documentId' is set
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling downloadDocFromAccount(Async)");
        }

        return downloadDocFromAccountCall(accountId, documentId, _callback);

    }

    /**
     * Download a Document File for an Account
     * This endpoint allows you to download a document identified by the document_id passed in the header. The returned document is in PDF format.  The operation returns a pre-signed downloadable link as a redirect with HTTP status code 301 if one is found.  You can retrieve a JSON version of a monthly statement by passing in the header accept: application/json header. 
     * @param accountId Account identifier. (required)
     * @param documentId Document identifier. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document is not found. </td><td>  -  </td></tr>
     </table>
     */
    public void downloadDocFromAccount(UUID accountId, UUID documentId) throws ApiException {
        downloadDocFromAccountWithHttpInfo(accountId, documentId);
    }

    /**
     * Download a Document File for an Account
     * This endpoint allows you to download a document identified by the document_id passed in the header. The returned document is in PDF format.  The operation returns a pre-signed downloadable link as a redirect with HTTP status code 301 if one is found.  You can retrieve a JSON version of a monthly statement by passing in the header accept: application/json header. 
     * @param accountId Account identifier. (required)
     * @param documentId Document identifier. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document is not found. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> downloadDocFromAccountWithHttpInfo(UUID accountId, UUID documentId) throws ApiException {
        okhttp3.Call localVarCall = downloadDocFromAccountValidateBeforeCall(accountId, documentId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Download a Document File for an Account (asynchronously)
     * This endpoint allows you to download a document identified by the document_id passed in the header. The returned document is in PDF format.  The operation returns a pre-signed downloadable link as a redirect with HTTP status code 301 if one is found.  You can retrieve a JSON version of a monthly statement by passing in the header accept: application/json header. 
     * @param accountId Account identifier. (required)
     * @param documentId Document identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document is not found. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call downloadDocFromAccountAsync(UUID accountId, UUID documentId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadDocFromAccountValidateBeforeCall(accountId, documentId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadDocumentById
     * @param documentId Document identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document was not found. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call downloadDocumentByIdCall(UUID documentId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/documents/{document_id}"
            .replace("{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadDocumentByIdValidateBeforeCall(UUID documentId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'documentId' is set
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling downloadDocumentById(Async)");
        }

        return downloadDocumentByIdCall(documentId, _callback);

    }

    /**
     * Download a Document File Directly
     * The operation returns a pre-signed downloadable link as a redirect with HTTP status code 301 if one is found. 
     * @param documentId Document identifier. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document was not found. </td><td>  -  </td></tr>
     </table>
     */
    public void downloadDocumentById(UUID documentId) throws ApiException {
        downloadDocumentByIdWithHttpInfo(documentId);
    }

    /**
     * Download a Document File Directly
     * The operation returns a pre-signed downloadable link as a redirect with HTTP status code 301 if one is found. 
     * @param documentId Document identifier. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document was not found. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> downloadDocumentByIdWithHttpInfo(UUID documentId) throws ApiException {
        okhttp3.Call localVarCall = downloadDocumentByIdValidateBeforeCall(documentId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Download a Document File Directly (asynchronously)
     * The operation returns a pre-signed downloadable link as a redirect with HTTP status code 301 if one is found. 
     * @param documentId Document identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirect to the pre-signed download link for the document PDF file.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The document was not found. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call downloadDocumentByIdAsync(UUID documentId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadDocumentByIdValidateBeforeCall(documentId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDocsForAccount
     * @param accountId Account identifier. (required)
     * @param start optional date value to filter the list (inclusive). (optional)
     * @param end optional date value to filter the list (inclusive). (optional)
     * @param type See DocumentType model for reference and explanation of values (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getDocsForAccountCall(UUID accountId, LocalDate start, LocalDate end, String type, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/documents"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDocsForAccountValidateBeforeCall(UUID accountId, LocalDate start, LocalDate end, String type, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getDocsForAccount(Async)");
        }

        return getDocsForAccountCall(accountId, start, end, type, _callback);

    }

    /**
     * Retrieve a List of Account Documents
     * This endpoint allows you to query all the documents that belong to a certain account. You can filter by date, or type of document.
     * @param accountId Account identifier. (required)
     * @param start optional date value to filter the list (inclusive). (optional)
     * @param end optional date value to filter the list (inclusive). (optional)
     * @param type See DocumentType model for reference and explanation of values (optional)
     * @return List&lt;Set&lt;DocumentInner&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    public List<Set<DocumentInner>> getDocsForAccount(UUID accountId, LocalDate start, LocalDate end, String type) throws ApiException {
        ApiResponse<List<Set<DocumentInner>>> localVarResp = getDocsForAccountWithHttpInfo(accountId, start, end, type);
        return localVarResp.getData();
    }

    /**
     * Retrieve a List of Account Documents
     * This endpoint allows you to query all the documents that belong to a certain account. You can filter by date, or type of document.
     * @param accountId Account identifier. (required)
     * @param start optional date value to filter the list (inclusive). (optional)
     * @param end optional date value to filter the list (inclusive). (optional)
     * @param type See DocumentType model for reference and explanation of values (optional)
     * @return ApiResponse&lt;List&lt;Set&lt;DocumentInner&gt;&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Set<DocumentInner>>> getDocsForAccountWithHttpInfo(UUID accountId, LocalDate start, LocalDate end, String type) throws ApiException {
        okhttp3.Call localVarCall = getDocsForAccountValidateBeforeCall(accountId, start, end, type, null);
        Type localVarReturnType = new TypeToken<List<Set<DocumentInner>>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a List of Account Documents (asynchronously)
     * This endpoint allows you to query all the documents that belong to a certain account. You can filter by date, or type of document.
     * @param accountId Account identifier. (required)
     * @param start optional date value to filter the list (inclusive). (optional)
     * @param end optional date value to filter the list (inclusive). (optional)
     * @param type See DocumentType model for reference and explanation of values (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getDocsForAccountAsync(UUID accountId, LocalDate start, LocalDate end, String type, final ApiCallback<List<Set<DocumentInner>>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDocsForAccountValidateBeforeCall(accountId, start, end, type, _callback);
        Type localVarReturnType = new TypeToken<List<Set<DocumentInner>>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1AccountsAccountIdDocumentsW8benDocumentIdDownload
     * @param accountId The id for the related Account (required)
     * @param documentId The id for the W8Ben you wish to download (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirects to a presigned download link for the document PDF. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Document Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadCall(String accountId, String documentId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/documents/w8ben/{document_id}/download"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadValidateBeforeCall(String accountId, String documentId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1AccountsAccountIdDocumentsW8benDocumentIdDownload(Async)");
        }

        // verify the required parameter 'documentId' is set
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getV1AccountsAccountIdDocumentsW8benDocumentIdDownload(Async)");
        }

        return getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadCall(accountId, documentId, _callback);

    }

    /**
     * Download the W8Ben document
     * This endpoint allows you to download a W8ben identified by the document_id passed as a path parameter. The returned document is in PDF format.  You can retrieve a JSON version of a monthly statement by passing in the header accept: application/json header.  For certain individuals, a W-8 BEN form should be submitted at onboarding. If the individual is not a registered U.S. taxpayer (not subject to a W-9), the W-8 BEN form may need to be submitted. The IRS explains which individuals this applies to and provides instructions on completing the form. Every three years, in addition to the calendar year it was signed, a new W-8 BEN form must be submitted.  The form can be submitted in JSON, JSONC, PNG, JPEG or PDF. If submitting it in JSON, please see the W-8 BEN completed with the corresponding field names for the API here.  Note: The dates collected on the form are in a slightly different format than how they need to be submitted via Accounts API. It is requested by the user on the form in MM-DD-YYYY, but should be submitted as YYYY-MM-DD.
     * @param accountId The id for the related Account (required)
     * @param documentId The id for the W8Ben you wish to download (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirects to a presigned download link for the document PDF. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Document Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void getV1AccountsAccountIdDocumentsW8benDocumentIdDownload(String accountId, String documentId) throws ApiException {
        getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadWithHttpInfo(accountId, documentId);
    }

    /**
     * Download the W8Ben document
     * This endpoint allows you to download a W8ben identified by the document_id passed as a path parameter. The returned document is in PDF format.  You can retrieve a JSON version of a monthly statement by passing in the header accept: application/json header.  For certain individuals, a W-8 BEN form should be submitted at onboarding. If the individual is not a registered U.S. taxpayer (not subject to a W-9), the W-8 BEN form may need to be submitted. The IRS explains which individuals this applies to and provides instructions on completing the form. Every three years, in addition to the calendar year it was signed, a new W-8 BEN form must be submitted.  The form can be submitted in JSON, JSONC, PNG, JPEG or PDF. If submitting it in JSON, please see the W-8 BEN completed with the corresponding field names for the API here.  Note: The dates collected on the form are in a slightly different format than how they need to be submitted via Accounts API. It is requested by the user on the form in MM-DD-YYYY, but should be submitted as YYYY-MM-DD.
     * @param accountId The id for the related Account (required)
     * @param documentId The id for the W8Ben you wish to download (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirects to a presigned download link for the document PDF. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Document Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadWithHttpInfo(String accountId, String documentId) throws ApiException {
        okhttp3.Call localVarCall = getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadValidateBeforeCall(accountId, documentId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Download the W8Ben document (asynchronously)
     * This endpoint allows you to download a W8ben identified by the document_id passed as a path parameter. The returned document is in PDF format.  You can retrieve a JSON version of a monthly statement by passing in the header accept: application/json header.  For certain individuals, a W-8 BEN form should be submitted at onboarding. If the individual is not a registered U.S. taxpayer (not subject to a W-9), the W-8 BEN form may need to be submitted. The IRS explains which individuals this applies to and provides instructions on completing the form. Every three years, in addition to the calendar year it was signed, a new W-8 BEN form must be submitted.  The form can be submitted in JSON, JSONC, PNG, JPEG or PDF. If submitting it in JSON, please see the W-8 BEN completed with the corresponding field names for the API here.  Note: The dates collected on the form are in a slightly different format than how they need to be submitted via Accounts API. It is requested by the user on the form in MM-DD-YYYY, but should be submitted as YYYY-MM-DD.
     * @param accountId The id for the related Account (required)
     * @param documentId The id for the W8Ben you wish to download (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 301 </td><td> Redirects to a presigned download link for the document PDF. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Document Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadAsync(String accountId, String documentId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1AccountsAccountIdDocumentsW8benDocumentIdDownloadValidateBeforeCall(accountId, documentId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for uploadDocToAccount
     * @param accountId Account identifier. (required)
     * @param documentUploadRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. The body in the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. No account was found for this account_id </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call uploadDocToAccountCall(UUID accountId, DocumentUploadRequest documentUploadRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = documentUploadRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/documents/upload"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call uploadDocToAccountValidateBeforeCall(UUID accountId, DocumentUploadRequest documentUploadRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling uploadDocToAccount(Async)");
        }

        // verify the required parameter 'documentUploadRequest' is set
        if (documentUploadRequest == null) {
            throw new ApiException("Missing the required parameter 'documentUploadRequest' when calling uploadDocToAccount(Async)");
        }

        return uploadDocToAccountCall(accountId, documentUploadRequest, _callback);

    }

    /**
     * Upload a Document to Existing Account
     * Upload a document to be attached to an account.  Documents are binary objects whose contents are encoded in base64. Each encoded content size is limited to 10MB if you use Alpaca for KYCaaS. If you perform your own KYC there are no document size limitations.
     * @param accountId Account identifier. (required)
     * @param documentUploadRequest  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. The body in the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. No account was found for this account_id </td><td>  -  </td></tr>
     </table>
     */
    public void uploadDocToAccount(UUID accountId, DocumentUploadRequest documentUploadRequest) throws ApiException {
        uploadDocToAccountWithHttpInfo(accountId, documentUploadRequest);
    }

    /**
     * Upload a Document to Existing Account
     * Upload a document to be attached to an account.  Documents are binary objects whose contents are encoded in base64. Each encoded content size is limited to 10MB if you use Alpaca for KYCaaS. If you perform your own KYC there are no document size limitations.
     * @param accountId Account identifier. (required)
     * @param documentUploadRequest  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. The body in the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. No account was found for this account_id </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> uploadDocToAccountWithHttpInfo(UUID accountId, DocumentUploadRequest documentUploadRequest) throws ApiException {
        okhttp3.Call localVarCall = uploadDocToAccountValidateBeforeCall(accountId, documentUploadRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Upload a Document to Existing Account (asynchronously)
     * Upload a document to be attached to an account.  Documents are binary objects whose contents are encoded in base64. Each encoded content size is limited to 10MB if you use Alpaca for KYCaaS. If you perform your own KYC there are no document size limitations.
     * @param accountId Account identifier. (required)
     * @param documentUploadRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. The body in the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. No account was found for this account_id </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call uploadDocToAccountAsync(UUID accountId, DocumentUploadRequest documentUploadRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = uploadDocToAccountValidateBeforeCall(accountId, documentUploadRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
