/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.Announcement;
import net.jacobpeterson.alpaca.openapi.broker.model.Error;
import java.time.LocalDate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorporateActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CorporateActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporateActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getCorporateAnnouncements
     * @param caTypes A comma-delimited list of CorporateActionType values (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType An emum of possible ways to use the &#x60;since&#x60; and &#x60;until&#x60; parameters to search by.  the types are:  - **declaration_date**: The date of the preliminary announcement details or the date that any subsequent term updates took place. - **ex_date**: The date on which any security purchasing activity will not result in a corporate action entitlement. Any selling activity that takes place on or after this date will result in a corporate action entitlement. - **record_date**: The date the company checks its records to determine who is shareholder in order to allocate entitlements. - **payable_date**: The date that the stock and cash positions will update according to the account positions as of the record date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getCorporateAnnouncementsCall(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/corporate_actions/announcements";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (caTypes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ca_types", caTypes));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (symbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbol", symbol));
        }

        if (cusip != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cusip", cusip));
        }

        if (dateType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date_type", dateType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporateAnnouncementsValidateBeforeCall(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'caTypes' is set
        if (caTypes == null) {
            throw new ApiException("Missing the required parameter 'caTypes' when calling getCorporateAnnouncements(Async)");
        }

        // verify the required parameter 'since' is set
        if (since == null) {
            throw new ApiException("Missing the required parameter 'since' when calling getCorporateAnnouncements(Async)");
        }

        // verify the required parameter 'until' is set
        if (until == null) {
            throw new ApiException("Missing the required parameter 'until' when calling getCorporateAnnouncements(Async)");
        }

        return getCorporateAnnouncementsCall(caTypes, since, until, symbol, cusip, dateType, _callback);

    }

    /**
     * Retrieve Announcements
     * This enables searching for an array of corporate action announcements based on criteria.
     * @param caTypes A comma-delimited list of CorporateActionType values (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType An emum of possible ways to use the &#x60;since&#x60; and &#x60;until&#x60; parameters to search by.  the types are:  - **declaration_date**: The date of the preliminary announcement details or the date that any subsequent term updates took place. - **ex_date**: The date on which any security purchasing activity will not result in a corporate action entitlement. Any selling activity that takes place on or after this date will result in a corporate action entitlement. - **record_date**: The date the company checks its records to determine who is shareholder in order to allocate entitlements. - **payable_date**: The date that the stock and cash positions will update according to the account positions as of the record date. (optional)
     * @return List&lt;Announcement&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
     </table>
     */
    public List<Announcement> getCorporateAnnouncements(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType) throws ApiException {
        ApiResponse<List<Announcement>> localVarResp = getCorporateAnnouncementsWithHttpInfo(caTypes, since, until, symbol, cusip, dateType);
        return localVarResp.getData();
    }

    /**
     * Retrieve Announcements
     * This enables searching for an array of corporate action announcements based on criteria.
     * @param caTypes A comma-delimited list of CorporateActionType values (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType An emum of possible ways to use the &#x60;since&#x60; and &#x60;until&#x60; parameters to search by.  the types are:  - **declaration_date**: The date of the preliminary announcement details or the date that any subsequent term updates took place. - **ex_date**: The date on which any security purchasing activity will not result in a corporate action entitlement. Any selling activity that takes place on or after this date will result in a corporate action entitlement. - **record_date**: The date the company checks its records to determine who is shareholder in order to allocate entitlements. - **payable_date**: The date that the stock and cash positions will update according to the account positions as of the record date. (optional)
     * @return ApiResponse&lt;List&lt;Announcement&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Announcement>> getCorporateAnnouncementsWithHttpInfo(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType) throws ApiException {
        okhttp3.Call localVarCall = getCorporateAnnouncementsValidateBeforeCall(caTypes, since, until, symbol, cusip, dateType, null);
        Type localVarReturnType = new TypeToken<List<Announcement>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Announcements (asynchronously)
     * This enables searching for an array of corporate action announcements based on criteria.
     * @param caTypes A comma-delimited list of CorporateActionType values (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType An emum of possible ways to use the &#x60;since&#x60; and &#x60;until&#x60; parameters to search by.  the types are:  - **declaration_date**: The date of the preliminary announcement details or the date that any subsequent term updates took place. - **ex_date**: The date on which any security purchasing activity will not result in a corporate action entitlement. Any selling activity that takes place on or after this date will result in a corporate action entitlement. - **record_date**: The date the company checks its records to determine who is shareholder in order to allocate entitlements. - **payable_date**: The date that the stock and cash positions will update according to the account positions as of the record date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getCorporateAnnouncementsAsync(String caTypes, LocalDate since, LocalDate until, String symbol, String cusip, String dateType, final ApiCallback<List<Announcement>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporateAnnouncementsValidateBeforeCall(caTypes, since, until, symbol, cusip, dateType, _callback);
        Type localVarReturnType = new TypeToken<List<Announcement>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGETV1CorporateActionsAnnouncementsId
     * @param id The id of the corporate action announcement to be returned. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Announcement object. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The body in the request is not valid </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> A server error occurred. Please contact Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getGETV1CorporateActionsAnnouncementsIdCall(String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/corporate_actions/announcements/{id}"
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGETV1CorporateActionsAnnouncementsIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getGETV1CorporateActionsAnnouncementsId(Async)");
        }

        return getGETV1CorporateActionsAnnouncementsIdCall(id, _callback);

    }

    /**
     * Retrieve a Specific Announcement
     * This enables searching for a specific corporate action announcement.
     * @param id The id of the corporate action announcement to be returned. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Announcement object. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The body in the request is not valid </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> A server error occurred. Please contact Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    public void getGETV1CorporateActionsAnnouncementsId(String id) throws ApiException {
        getGETV1CorporateActionsAnnouncementsIdWithHttpInfo(id);
    }

    /**
     * Retrieve a Specific Announcement
     * This enables searching for a specific corporate action announcement.
     * @param id The id of the corporate action announcement to be returned. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Announcement object. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The body in the request is not valid </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> A server error occurred. Please contact Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> getGETV1CorporateActionsAnnouncementsIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getGETV1CorporateActionsAnnouncementsIdValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Retrieve a Specific Announcement (asynchronously)
     * This enables searching for a specific corporate action announcement.
     * @param id The id of the corporate action announcement to be returned. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Announcement object. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The body in the request is not valid </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid input value. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> A server error occurred. Please contact Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getGETV1CorporateActionsAnnouncementsIdAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGETV1CorporateActionsAnnouncementsIdValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
