/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.Clock;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClockApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ClockApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClockApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for queryMarketClock
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The current market&#39;s timestamp </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call queryMarketClockCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/clock";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryMarketClockValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return queryMarketClockCall(_callback);

    }

    /**
     * Retrieve the Market Clock
     * The Clock API serves the current market timestamp, whether or not the market is currently open, as well as the times of the next market open and close.
     * @return Clock
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The current market&#39;s timestamp </td><td>  -  </td></tr>
     </table>
     */
    public Clock queryMarketClock() throws ApiException {
        ApiResponse<Clock> localVarResp = queryMarketClockWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Retrieve the Market Clock
     * The Clock API serves the current market timestamp, whether or not the market is currently open, as well as the times of the next market open and close.
     * @return ApiResponse&lt;Clock&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The current market&#39;s timestamp </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Clock> queryMarketClockWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = queryMarketClockValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Clock>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve the Market Clock (asynchronously)
     * The Clock API serves the current market timestamp, whether or not the market is currently open, as well as the times of the next market open and close.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The current market&#39;s timestamp </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call queryMarketClockAsync(final ApiCallback<Clock> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryMarketClockValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Clock>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
