/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.Calendar;
import java.time.LocalDate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalendarApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CalendarApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CalendarApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for queryMarketCalendar
     * @param start The first date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param end The last date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param dateType ‘trading’ or ‘settlement’. Default value is ‘trading’. Indicates to filter by trade date or settlement date if start or end are specified. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the calendar object </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call queryMarketCalendarCall(LocalDate start, LocalDate end, String dateType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/calendar";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (dateType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date_type", dateType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryMarketCalendarValidateBeforeCall(LocalDate start, LocalDate end, String dateType, final ApiCallback _callback) throws ApiException {
        return queryMarketCalendarCall(start, end, dateType, _callback);

    }

    /**
     * Retrieve the Market Calendar
     * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.
     * @param start The first date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param end The last date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param dateType ‘trading’ or ‘settlement’. Default value is ‘trading’. Indicates to filter by trade date or settlement date if start or end are specified. (optional)
     * @return List&lt;Calendar&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the calendar object </td><td>  -  </td></tr>
     </table>
     */
    public List<Calendar> queryMarketCalendar(LocalDate start, LocalDate end, String dateType) throws ApiException {
        ApiResponse<List<Calendar>> localVarResp = queryMarketCalendarWithHttpInfo(start, end, dateType);
        return localVarResp.getData();
    }

    /**
     * Retrieve the Market Calendar
     * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.
     * @param start The first date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param end The last date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param dateType ‘trading’ or ‘settlement’. Default value is ‘trading’. Indicates to filter by trade date or settlement date if start or end are specified. (optional)
     * @return ApiResponse&lt;List&lt;Calendar&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the calendar object </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Calendar>> queryMarketCalendarWithHttpInfo(LocalDate start, LocalDate end, String dateType) throws ApiException {
        okhttp3.Call localVarCall = queryMarketCalendarValidateBeforeCall(start, end, dateType, null);
        Type localVarReturnType = new TypeToken<List<Calendar>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve the Market Calendar (asynchronously)
     * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.
     * @param start The first date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param end The last date to retrieve data for. (Inclusive) in YYYY-MM-DD format (optional)
     * @param dateType ‘trading’ or ‘settlement’. Default value is ‘trading’. Indicates to filter by trade date or settlement date if start or end are specified. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the calendar object </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call queryMarketCalendarAsync(LocalDate start, LocalDate end, String dateType, final ApiCallback<List<Calendar>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryMarketCalendarValidateBeforeCall(start, end, dateType, _callback);
        Type localVarReturnType = new TypeToken<List<Calendar>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
