/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.Asset;
import java.math.BigDecimal;
import net.jacobpeterson.alpaca.openapi.broker.model.Error;
import net.jacobpeterson.alpaca.openapi.broker.model.GetOptionsContracts200Response;
import java.time.LocalDate;
import net.jacobpeterson.alpaca.openapi.broker.model.OptionContract;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AssetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getAssetBySymbolOrId
     * @param symbolOrAssetId you can use either the asset&#39;s Id or the symbol to search (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns asset </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Asset not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAssetBySymbolOrIdCall(String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/assets/{symbol_or_asset_id}"
            .replace("{" + "symbol_or_asset_id" + "}", localVarApiClient.escapeString(symbolOrAssetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAssetBySymbolOrIdValidateBeforeCall(String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrAssetId' is set
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getAssetBySymbolOrId(Async)");
        }

        return getAssetBySymbolOrIdCall(symbolOrAssetId, _callback);

    }

    /**
     * Retrieve an Asset by ID
     * Returns the requested asset, if found
     * @param symbolOrAssetId you can use either the asset&#39;s Id or the symbol to search (required)
     * @return Asset
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns asset </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Asset not found </td><td>  -  </td></tr>
     </table>
     */
    public Asset getAssetBySymbolOrId(String symbolOrAssetId) throws ApiException {
        ApiResponse<Asset> localVarResp = getAssetBySymbolOrIdWithHttpInfo(symbolOrAssetId);
        return localVarResp.getData();
    }

    /**
     * Retrieve an Asset by ID
     * Returns the requested asset, if found
     * @param symbolOrAssetId you can use either the asset&#39;s Id or the symbol to search (required)
     * @return ApiResponse&lt;Asset&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns asset </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Asset not found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Asset> getAssetBySymbolOrIdWithHttpInfo(String symbolOrAssetId) throws ApiException {
        okhttp3.Call localVarCall = getAssetBySymbolOrIdValidateBeforeCall(symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Asset>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve an Asset by ID (asynchronously)
     * Returns the requested asset, if found
     * @param symbolOrAssetId you can use either the asset&#39;s Id or the symbol to search (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns asset </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Asset not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAssetBySymbolOrIdAsync(String symbolOrAssetId, final ApiCallback<Asset> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAssetBySymbolOrIdValidateBeforeCall(symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Asset>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAssets
     * @param status Asset status to filter by, will default to &#x60;all&#x60; (optional, default to all)
     * @param assetClass Asset class to filter by, &#x60;us_equity&#x60; or &#x60;crypto&#x60;. Defaults to &#x60;us_equity&#x60; (optional, default to us_equity)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAssetsCall(String status, String assetClass, List<String> attributes, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/assets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (assetClass != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asset_class", assetClass));
        }

        if (attributes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "attributes", attributes));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAssetsValidateBeforeCall(String status, String assetClass, List<String> attributes, final ApiCallback _callback) throws ApiException {
        return getAssetsCall(status, assetClass, attributes, _callback);

    }

    /**
     * Retrieve All Assets
     * Returns all assets
     * @param status Asset status to filter by, will default to &#x60;all&#x60; (optional, default to all)
     * @param assetClass Asset class to filter by, &#x60;us_equity&#x60; or &#x60;crypto&#x60;. Defaults to &#x60;us_equity&#x60; (optional, default to us_equity)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @return List&lt;Asset&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects. </td><td>  -  </td></tr>
     </table>
     */
    public List<Asset> getAssets(String status, String assetClass, List<String> attributes) throws ApiException {
        ApiResponse<List<Asset>> localVarResp = getAssetsWithHttpInfo(status, assetClass, attributes);
        return localVarResp.getData();
    }

    /**
     * Retrieve All Assets
     * Returns all assets
     * @param status Asset status to filter by, will default to &#x60;all&#x60; (optional, default to all)
     * @param assetClass Asset class to filter by, &#x60;us_equity&#x60; or &#x60;crypto&#x60;. Defaults to &#x60;us_equity&#x60; (optional, default to us_equity)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;Asset&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Asset>> getAssetsWithHttpInfo(String status, String assetClass, List<String> attributes) throws ApiException {
        okhttp3.Call localVarCall = getAssetsValidateBeforeCall(status, assetClass, attributes, null);
        Type localVarReturnType = new TypeToken<List<Asset>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve All Assets (asynchronously)
     * Returns all assets
     * @param status Asset status to filter by, will default to &#x60;all&#x60; (optional, default to all)
     * @param assetClass Asset class to filter by, &#x60;us_equity&#x60; or &#x60;crypto&#x60;. Defaults to &#x60;us_equity&#x60; (optional, default to us_equity)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAssetsAsync(String status, String assetClass, List<String> attributes, final ApiCallback<List<Asset>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAssetsValidateBeforeCall(status, assetClass, attributes, _callback);
        Type localVarReturnType = new TypeToken<List<Asset>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOptionContractSymbolOrId
     * @param symbolOrId The contract symbol or ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionContractSymbolOrIdCall(String symbolOrId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/options/contracts/{symbol_or_id}"
            .replace("{" + "symbol_or_id" + "}", localVarApiClient.escapeString(symbolOrId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionContractSymbolOrIdValidateBeforeCall(String symbolOrId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrId' is set
        if (symbolOrId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrId' when calling getOptionContractSymbolOrId(Async)");
        }

        return getOptionContractSymbolOrIdCall(symbolOrId, _callback);

    }

    /**
     * Get an option contract by ID or Symbol (BETA)
     * Get an option contract by symbol or contract ID. The symbol or id should be passed in as a path parameter.
     * @param symbolOrId The contract symbol or ID. (required)
     * @return OptionContract
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public OptionContract getOptionContractSymbolOrId(String symbolOrId) throws ApiException {
        ApiResponse<OptionContract> localVarResp = getOptionContractSymbolOrIdWithHttpInfo(symbolOrId);
        return localVarResp.getData();
    }

    /**
     * Get an option contract by ID or Symbol (BETA)
     * Get an option contract by symbol or contract ID. The symbol or id should be passed in as a path parameter.
     * @param symbolOrId The contract symbol or ID. (required)
     * @return ApiResponse&lt;OptionContract&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<OptionContract> getOptionContractSymbolOrIdWithHttpInfo(String symbolOrId) throws ApiException {
        okhttp3.Call localVarCall = getOptionContractSymbolOrIdValidateBeforeCall(symbolOrId, null);
        Type localVarReturnType = new TypeToken<OptionContract>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an option contract by ID or Symbol (BETA) (asynchronously)
     * Get an option contract by symbol or contract ID. The symbol or id should be passed in as a path parameter.
     * @param symbolOrId The contract symbol or ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionContractSymbolOrIdAsync(String symbolOrId, final ApiCallback<OptionContract> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOptionContractSymbolOrIdValidateBeforeCall(symbolOrId, _callback);
        Type localVarReturnType = new TypeToken<OptionContract>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOptionsContracts
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionsContractsCall(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/options/contracts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (underlyingSymbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying_symbol", underlyingSymbol));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (expirationDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_date", expirationDate));
        }

        if (expirationDateGte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_date_gte", expirationDateGte));
        }

        if (expirationDateLte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_date_lte", expirationDateLte));
        }

        if (rootSymbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("root_symbol", rootSymbol));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (style != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("style", style));
        }

        if (strikePriceGte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("strike_price_gte", strikePriceGte));
        }

        if (strikePriceLte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("strike_price_lte", strikePriceLte));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsContractsValidateBeforeCall(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlyingSymbol' is set
        if (underlyingSymbol == null) {
            throw new ApiException("Missing the required parameter 'underlyingSymbol' when calling getOptionsContracts(Async)");
        }

        return getOptionsContractsCall(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit, _callback);

    }

    /**
     * Get Option Contracts (BETA)
     * This endpoint allows you to retrieve a list of option contracts based on various filtering criteria.  By default only active contracts that expire before the upcoming weekend are returned. 
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @return GetOptionsContracts200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    public GetOptionsContracts200Response getOptionsContracts(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit) throws ApiException {
        ApiResponse<GetOptionsContracts200Response> localVarResp = getOptionsContractsWithHttpInfo(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit);
        return localVarResp.getData();
    }

    /**
     * Get Option Contracts (BETA)
     * This endpoint allows you to retrieve a list of option contracts based on various filtering criteria.  By default only active contracts that expire before the upcoming weekend are returned. 
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @return ApiResponse&lt;GetOptionsContracts200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetOptionsContracts200Response> getOptionsContractsWithHttpInfo(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = getOptionsContractsValidateBeforeCall(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit, null);
        Type localVarReturnType = new TypeToken<GetOptionsContracts200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Option Contracts (BETA) (asynchronously)
     * This endpoint allows you to retrieve a list of option contracts based on various filtering criteria.  By default only active contracts that expire before the upcoming weekend are returned. 
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionsContractsAsync(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit, final ApiCallback<GetOptionsContracts200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOptionsContractsValidateBeforeCall(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit, _callback);
        Type localVarReturnType = new TypeToken<GetOptionsContracts200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
