/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.Account;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountCreationRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountExtended;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountUpdateRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Activity;
import net.jacobpeterson.alpaca.openapi.broker.model.Bank;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateBankRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateTransferRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Error;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.broker.model.OptionsApprovalRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.OptionsApprovalResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeAccount;
import net.jacobpeterson.alpaca.openapi.broker.model.Transfer;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for createAccount
     * @param accountCreationRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> There is already an existing account registered with the same email address. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> One of the input values is not a valid value. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createAccountCall(AccountCreationRequest accountCreationRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = accountCreationRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createAccountValidateBeforeCall(AccountCreationRequest accountCreationRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountCreationRequest' is set
        if (accountCreationRequest == null) {
            throw new ApiException("Missing the required parameter 'accountCreationRequest' when calling createAccount(Async)");
        }

        return createAccountCall(accountCreationRequest, _callback);

    }

    /**
     * Create an Account
     * Submit an account application with KYC information. This will create a trading account for the end user. The account status may or may not be ACTIVE immediately and you will receive account status updates on the event API. 
     * @param accountCreationRequest  (required)
     * @return Account
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> There is already an existing account registered with the same email address. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> One of the input values is not a valid value. </td><td>  -  </td></tr>
     </table>
     */
    public Account createAccount(AccountCreationRequest accountCreationRequest) throws ApiException {
        ApiResponse<Account> localVarResp = createAccountWithHttpInfo(accountCreationRequest);
        return localVarResp.getData();
    }

    /**
     * Create an Account
     * Submit an account application with KYC information. This will create a trading account for the end user. The account status may or may not be ACTIVE immediately and you will receive account status updates on the event API. 
     * @param accountCreationRequest  (required)
     * @return ApiResponse&lt;Account&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> There is already an existing account registered with the same email address. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> One of the input values is not a valid value. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Account> createAccountWithHttpInfo(AccountCreationRequest accountCreationRequest) throws ApiException {
        okhttp3.Call localVarCall = createAccountValidateBeforeCall(accountCreationRequest, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an Account (asynchronously)
     * Submit an account application with KYC information. This will create a trading account for the end user. The account status may or may not be ACTIVE immediately and you will receive account status updates on the event API. 
     * @param accountCreationRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> There is already an existing account registered with the same email address. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> One of the input values is not a valid value. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createAccountAsync(AccountCreationRequest accountCreationRequest, final ApiCallback<Account> _callback) throws ApiException {

        okhttp3.Call localVarCall = createAccountValidateBeforeCall(accountCreationRequest, _callback);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createRecipientBank
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createRecipientBankCall(UUID accountId, CreateBankRequest createBankRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createBankRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createRecipientBankValidateBeforeCall(UUID accountId, CreateBankRequest createBankRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createRecipientBank(Async)");
        }

        // verify the required parameter 'createBankRequest' is set
        if (createBankRequest == null) {
            throw new ApiException("Missing the required parameter 'createBankRequest' when calling createRecipientBank(Async)");
        }

        return createRecipientBankCall(accountId, createBankRequest, _callback);

    }

    /**
     * Create a Bank Relationship for an Account
     * If successful, retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @return Bank
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    public Bank createRecipientBank(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        ApiResponse<Bank> localVarResp = createRecipientBankWithHttpInfo(accountId, createBankRequest);
        return localVarResp.getData();
    }

    /**
     * Create a Bank Relationship for an Account
     * If successful, retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @return ApiResponse&lt;Bank&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Bank> createRecipientBankWithHttpInfo(UUID accountId, CreateBankRequest createBankRequest) throws ApiException {
        okhttp3.Call localVarCall = createRecipientBankValidateBeforeCall(accountId, createBankRequest, null);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a Bank Relationship for an Account (asynchronously)
     * If successful, retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param createBankRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The created Bank relationship </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A Bank relationship already exists for this account </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createRecipientBankAsync(UUID accountId, CreateBankRequest createBankRequest, final ApiCallback<Bank> _callback) throws ApiException {

        okhttp3.Call localVarCall = createRecipientBankValidateBeforeCall(accountId, createBankRequest, _callback);
        Type localVarReturnType = new TypeToken<Bank>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTransferForAccount
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createTransferForAccountCall(UUID accountId, CreateTransferRequest createTransferRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createTransferRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/transfers"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTransferForAccountValidateBeforeCall(UUID accountId, CreateTransferRequest createTransferRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createTransferForAccount(Async)");
        }

        // verify the required parameter 'createTransferRequest' is set
        if (createTransferRequest == null) {
            throw new ApiException("Missing the required parameter 'createTransferRequest' when calling createTransferForAccount(Async)");
        }

        return createTransferForAccountCall(accountId, createTransferRequest, _callback);

    }

    /**
     * Request a New Transfer
     * Create a new transfer to an account to fund it.  In the sandbox environment, you can instantly deposit to or withdraw from an account with a virtual money amount. In the production environment, this endpoint is used only for requesting an outgoing (withdrawal) wire transfer at this moment. For the wire transfer (in production), you need to create a bank resource first using the Bank API. For more on how to fund an account in sandbox please check out this tutorial [here](https://alpaca.markets/learn/fund-broker-api/).
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @return Transfer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    public Transfer createTransferForAccount(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        ApiResponse<Transfer> localVarResp = createTransferForAccountWithHttpInfo(accountId, createTransferRequest);
        return localVarResp.getData();
    }

    /**
     * Request a New Transfer
     * Create a new transfer to an account to fund it.  In the sandbox environment, you can instantly deposit to or withdraw from an account with a virtual money amount. In the production environment, this endpoint is used only for requesting an outgoing (withdrawal) wire transfer at this moment. For the wire transfer (in production), you need to create a bank resource first using the Bank API. For more on how to fund an account in sandbox please check out this tutorial [here](https://alpaca.markets/learn/fund-broker-api/).
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @return ApiResponse&lt;Transfer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Transfer> createTransferForAccountWithHttpInfo(UUID accountId, CreateTransferRequest createTransferRequest) throws ApiException {
        okhttp3.Call localVarCall = createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, null);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request a New Transfer (asynchronously)
     * Create a new transfer to an account to fund it.  In the sandbox environment, you can instantly deposit to or withdraw from an account with a virtual money amount. In the production environment, this endpoint is used only for requesting an outgoing (withdrawal) wire transfer at this moment. For the wire transfer (in production), you need to create a bank resource first using the Bank API. For more on how to fund an account in sandbox please check out this tutorial [here](https://alpaca.markets/learn/fund-broker-api/).
     * @param accountId Account identifier. (required)
     * @param createTransferRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully requested a transfer. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createTransferForAccountAsync(UUID accountId, CreateTransferRequest createTransferRequest, final ApiCallback<Transfer> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTransferForAccountValidateBeforeCall(accountId, createTransferRequest, _callback);
        Type localVarReturnType = new TypeToken<Transfer>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccount
     * @param accountId Account identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Will return an AccountExtended if an account with account_id exists, otherwise will throw an error. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountValidateBeforeCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccount(Async)");
        }

        return getAccountCall(accountId, _callback);

    }

    /**
     * Get An Account by ID
     * You can query a specific account that you submitted to Alpaca by passing into the query the account_id associated with the account you’re retrieving. 
     * @param accountId Account identifier. (required)
     * @return AccountExtended
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Will return an AccountExtended if an account with account_id exists, otherwise will throw an error. </td><td>  -  </td></tr>
     </table>
     */
    public AccountExtended getAccount(UUID accountId) throws ApiException {
        ApiResponse<AccountExtended> localVarResp = getAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Get An Account by ID
     * You can query a specific account that you submitted to Alpaca by passing into the query the account_id associated with the account you’re retrieving. 
     * @param accountId Account identifier. (required)
     * @return ApiResponse&lt;AccountExtended&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Will return an AccountExtended if an account with account_id exists, otherwise will throw an error. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<AccountExtended> getAccountWithHttpInfo(UUID accountId) throws ApiException {
        okhttp3.Call localVarCall = getAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get An Account by ID (asynchronously)
     * You can query a specific account that you submitted to Alpaca by passing into the query the account_id associated with the account you’re retrieving. 
     * @param accountId Account identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Will return an AccountExtended if an account with account_id exists, otherwise will throw an error. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountAsync(UUID accountId, final ApiCallback<AccountExtended> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountActivities
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. Cannot be used with date. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The Activity ID of the end of your current page of results.  (optional)
     * @param category The main activity category to get. Can be one of &#x60;trade_activity&#x60; or &#x60;non_trade_activity&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesCall(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/activities";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accountId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("account_id", accountId));
        }

        if (date != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date", date));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (direction != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("direction", direction));
        }

        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_size", pageSize));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountActivitiesValidateBeforeCall(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category, final ApiCallback _callback) throws ApiException {
        return getAccountActivitiesCall(accountId, date, until, after, direction, pageSize, pageToken, category, _callback);

    }

    /**
     * Retrieve Account Activities
     * Returns an array of Activities  Notes: * Pagination is handled using the &#x60;page_token&#x60; and &#x60;page_size&#x60; parameters. * &#x60;page_token&#x60; represents the ID of the end of your current page of results.   for example if in your first response the id of the last Activiy item returned in the array was &#x60;20220203000000000::045b3b8d-c566-4bef-b741-2bf598dd6ae7&#x60;, you&#39;d pass that value as &#x60;page_token&#x60; to get the next page of results  * If specified with a &#x60;direction&#x60; of &#x60;desc&#x60;, for example, the results will end before the activity with the specified ID. * If specified with a &#x60;direction&#x60; of &#x60;asc&#x60;, results will begin with the activity immediately after the one specified. * &#x60;page_size&#x60; is the maximum number of entries to return in the response. * If &#x60;date&#x60; is not specified, the default and maximum value is 100. * If &#x60;date&#x60; is specified, the default behavior is to return all results, and there is no maximum page size.
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. Cannot be used with date. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The Activity ID of the end of your current page of results.  (optional)
     * @param category The main activity category to get. Can be one of &#x60;trade_activity&#x60; or &#x60;non_trade_activity&#x60;. (optional)
     * @return List&lt;Activity&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public List<Activity> getAccountActivities(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        ApiResponse<List<Activity>> localVarResp = getAccountActivitiesWithHttpInfo(accountId, date, until, after, direction, pageSize, pageToken, category);
        return localVarResp.getData();
    }

    /**
     * Retrieve Account Activities
     * Returns an array of Activities  Notes: * Pagination is handled using the &#x60;page_token&#x60; and &#x60;page_size&#x60; parameters. * &#x60;page_token&#x60; represents the ID of the end of your current page of results.   for example if in your first response the id of the last Activiy item returned in the array was &#x60;20220203000000000::045b3b8d-c566-4bef-b741-2bf598dd6ae7&#x60;, you&#39;d pass that value as &#x60;page_token&#x60; to get the next page of results  * If specified with a &#x60;direction&#x60; of &#x60;desc&#x60;, for example, the results will end before the activity with the specified ID. * If specified with a &#x60;direction&#x60; of &#x60;asc&#x60;, results will begin with the activity immediately after the one specified. * &#x60;page_size&#x60; is the maximum number of entries to return in the response. * If &#x60;date&#x60; is not specified, the default and maximum value is 100. * If &#x60;date&#x60; is specified, the default behavior is to return all results, and there is no maximum page size.
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. Cannot be used with date. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The Activity ID of the end of your current page of results.  (optional)
     * @param category The main activity category to get. Can be one of &#x60;trade_activity&#x60; or &#x60;non_trade_activity&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;Activity&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Activity>> getAccountActivitiesWithHttpInfo(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        okhttp3.Call localVarCall = getAccountActivitiesValidateBeforeCall(accountId, date, until, after, direction, pageSize, pageToken, category, null);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Account Activities (asynchronously)
     * Returns an array of Activities  Notes: * Pagination is handled using the &#x60;page_token&#x60; and &#x60;page_size&#x60; parameters. * &#x60;page_token&#x60; represents the ID of the end of your current page of results.   for example if in your first response the id of the last Activiy item returned in the array was &#x60;20220203000000000::045b3b8d-c566-4bef-b741-2bf598dd6ae7&#x60;, you&#39;d pass that value as &#x60;page_token&#x60; to get the next page of results  * If specified with a &#x60;direction&#x60; of &#x60;desc&#x60;, for example, the results will end before the activity with the specified ID. * If specified with a &#x60;direction&#x60; of &#x60;asc&#x60;, results will begin with the activity immediately after the one specified. * &#x60;page_size&#x60; is the maximum number of entries to return in the response. * If &#x60;date&#x60; is not specified, the default and maximum value is 100. * If &#x60;date&#x60; is specified, the default behavior is to return all results, and there is no maximum page size.
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. Cannot be used with date. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The Activity ID of the end of your current page of results.  (optional)
     * @param category The main activity category to get. Can be one of &#x60;trade_activity&#x60; or &#x60;non_trade_activity&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesAsync(UUID accountId, String date, String until, String after, String direction, Integer pageSize, String pageToken, String category, final ApiCallback<List<Activity>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountActivitiesValidateBeforeCall(accountId, date, until, after, direction, pageSize, pageToken, category, _callback);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountActivitiesByType
     * @param activityType see ActivityType model for details about what the different types mean (required)
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The ID of the end of your current page of results (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesByTypeCall(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/activities/{activity_type}"
            .replace("{" + "activity_type" + "}", localVarApiClient.escapeString(activityType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accountId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("account_id", accountId));
        }

        if (date != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date", date));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (direction != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("direction", direction));
        }

        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_size", pageSize));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountActivitiesByTypeValidateBeforeCall(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'activityType' is set
        if (activityType == null) {
            throw new ApiException("Missing the required parameter 'activityType' when calling getAccountActivitiesByType(Async)");
        }

        return getAccountActivitiesByTypeCall(activityType, accountId, date, until, after, direction, pageSize, pageToken, _callback);

    }

    /**
     * Retrieve Specific Account Activities
     * Retrieves an Array of Activies by type  If {activity_type} is provided as part of the URL, category cannot be provided as query parameter. They are mutually exclusive.  Notes: * Pagination is handled using the &#x60;page_token&#x60; and &#x60;page_size&#x60; parameters. * &#x60;page_token&#x60; represents the ID of the end of your current page of results.   for example if in your first response the id of the last Activiy item returned in the array was &#x60;20220203000000000::045b3b8d-c566-4bef-b741-2bf598dd6ae7&#x60;, you&#39;d pass that value as &#x60;page_token&#x60; to get the next page of results  * If specified with a &#x60;direction&#x60; of &#x60;desc&#x60;, for example, the results will end before the activity with the specified ID. * If specified with a &#x60;direction&#x60; of &#x60;asc&#x60;, results will begin with the activity immediately after the one specified. * &#x60;page_size&#x60; is the maximum number of entries to return in the response. * If &#x60;date&#x60; is not specified, the default and maximum value is 100. * If &#x60;date&#x60; is specified, the default behavior is to return all results, and there is no maximum page size.
     * @param activityType see ActivityType model for details about what the different types mean (required)
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The ID of the end of your current page of results (optional)
     * @return List&lt;Activity&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public List<Activity> getAccountActivitiesByType(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken) throws ApiException {
        ApiResponse<List<Activity>> localVarResp = getAccountActivitiesByTypeWithHttpInfo(activityType, accountId, date, until, after, direction, pageSize, pageToken);
        return localVarResp.getData();
    }

    /**
     * Retrieve Specific Account Activities
     * Retrieves an Array of Activies by type  If {activity_type} is provided as part of the URL, category cannot be provided as query parameter. They are mutually exclusive.  Notes: * Pagination is handled using the &#x60;page_token&#x60; and &#x60;page_size&#x60; parameters. * &#x60;page_token&#x60; represents the ID of the end of your current page of results.   for example if in your first response the id of the last Activiy item returned in the array was &#x60;20220203000000000::045b3b8d-c566-4bef-b741-2bf598dd6ae7&#x60;, you&#39;d pass that value as &#x60;page_token&#x60; to get the next page of results  * If specified with a &#x60;direction&#x60; of &#x60;desc&#x60;, for example, the results will end before the activity with the specified ID. * If specified with a &#x60;direction&#x60; of &#x60;asc&#x60;, results will begin with the activity immediately after the one specified. * &#x60;page_size&#x60; is the maximum number of entries to return in the response. * If &#x60;date&#x60; is not specified, the default and maximum value is 100. * If &#x60;date&#x60; is specified, the default behavior is to return all results, and there is no maximum page size.
     * @param activityType see ActivityType model for details about what the different types mean (required)
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The ID of the end of your current page of results (optional)
     * @return ApiResponse&lt;List&lt;Activity&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Activity>> getAccountActivitiesByTypeWithHttpInfo(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken) throws ApiException {
        okhttp3.Call localVarCall = getAccountActivitiesByTypeValidateBeforeCall(activityType, accountId, date, until, after, direction, pageSize, pageToken, null);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Specific Account Activities (asynchronously)
     * Retrieves an Array of Activies by type  If {activity_type} is provided as part of the URL, category cannot be provided as query parameter. They are mutually exclusive.  Notes: * Pagination is handled using the &#x60;page_token&#x60; and &#x60;page_size&#x60; parameters. * &#x60;page_token&#x60; represents the ID of the end of your current page of results.   for example if in your first response the id of the last Activiy item returned in the array was &#x60;20220203000000000::045b3b8d-c566-4bef-b741-2bf598dd6ae7&#x60;, you&#39;d pass that value as &#x60;page_token&#x60; to get the next page of results  * If specified with a &#x60;direction&#x60; of &#x60;desc&#x60;, for example, the results will end before the activity with the specified ID. * If specified with a &#x60;direction&#x60; of &#x60;asc&#x60;, results will begin with the activity immediately after the one specified. * &#x60;page_size&#x60; is the maximum number of entries to return in the response. * If &#x60;date&#x60; is not specified, the default and maximum value is 100. * If &#x60;date&#x60; is specified, the default behavior is to return all results, and there is no maximum page size.
     * @param activityType see ActivityType model for details about what the different types mean (required)
     * @param accountId id of a single account to filter by (optional)
     * @param date Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param until Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param after Both formats YYYY-MM-DD and YYYY-MM-DDTHH:MM:SSZ supported. (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param pageSize The maximum number of entries to return in the response (optional, default to 100)
     * @param pageToken The ID of the end of your current page of results (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesByTypeAsync(String activityType, UUID accountId, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, final ApiCallback<List<Activity>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountActivitiesByTypeValidateBeforeCall(activityType, accountId, date, until, after, direction, pageSize, pageToken, _callback);
        Type localVarReturnType = new TypeToken<List<Activity>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllAccounts
     * @param query Pass space-delimited tokens. The response will contain accounts that match with each of the tokens (logical AND). A match means the token is present in either the account’s associated account number, phone number, name, or e-mail address (logical OR). (optional)
     * @param createdAfter Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param createdBefore Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param status See the AccountStatus model for values (optional)
     * @param sort The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param entities Comma-delimited entity names to include in the response (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a list of Account model up to 1000 items per query order by created_at. To scroll the result, please use the created_after parameter.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllAccountsCall(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (createdAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("created_after", createdAfter));
        }

        if (createdBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("created_before", createdBefore));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (entities != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entities", entities));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllAccountsValidateBeforeCall(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities, final ApiCallback _callback) throws ApiException {
        return getAllAccountsCall(query, createdAfter, createdBefore, status, sort, entities, _callback);

    }

    /**
     * Get All Accounts
     * Retrieves all accounts found by the query&#39;
     * @param query Pass space-delimited tokens. The response will contain accounts that match with each of the tokens (logical AND). A match means the token is present in either the account’s associated account number, phone number, name, or e-mail address (logical OR). (optional)
     * @param createdAfter Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param createdBefore Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param status See the AccountStatus model for values (optional)
     * @param sort The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param entities Comma-delimited entity names to include in the response (optional)
     * @return List&lt;Account&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a list of Account model up to 1000 items per query order by created_at. To scroll the result, please use the created_after parameter.  </td><td>  -  </td></tr>
     </table>
     */
    public List<Account> getAllAccounts(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities) throws ApiException {
        ApiResponse<List<Account>> localVarResp = getAllAccountsWithHttpInfo(query, createdAfter, createdBefore, status, sort, entities);
        return localVarResp.getData();
    }

    /**
     * Get All Accounts
     * Retrieves all accounts found by the query&#39;
     * @param query Pass space-delimited tokens. The response will contain accounts that match with each of the tokens (logical AND). A match means the token is present in either the account’s associated account number, phone number, name, or e-mail address (logical OR). (optional)
     * @param createdAfter Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param createdBefore Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param status See the AccountStatus model for values (optional)
     * @param sort The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param entities Comma-delimited entity names to include in the response (optional)
     * @return ApiResponse&lt;List&lt;Account&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a list of Account model up to 1000 items per query order by created_at. To scroll the result, please use the created_after parameter.  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Account>> getAllAccountsWithHttpInfo(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities) throws ApiException {
        okhttp3.Call localVarCall = getAllAccountsValidateBeforeCall(query, createdAfter, createdBefore, status, sort, entities, null);
        Type localVarReturnType = new TypeToken<List<Account>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get All Accounts (asynchronously)
     * Retrieves all accounts found by the query&#39;
     * @param query Pass space-delimited tokens. The response will contain accounts that match with each of the tokens (logical AND). A match means the token is present in either the account’s associated account number, phone number, name, or e-mail address (logical OR). (optional)
     * @param createdAfter Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param createdBefore Inclusive of timestamp. Example: 2019-10-12T07:20:50.52Z (optional)
     * @param status See the AccountStatus model for values (optional)
     * @param sort The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param entities Comma-delimited entity names to include in the response (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a list of Account model up to 1000 items per query order by created_at. To scroll the result, please use the created_after parameter.  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllAccountsAsync(String query, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String status, String sort, String entities, final ApiCallback<List<Account>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllAccountsValidateBeforeCall(query, createdAfter, createdBefore, status, sort, entities, _callback);
        Type localVarReturnType = new TypeToken<List<Account>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRecipientBanks
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getRecipientBanksCall(UUID accountId, String status, String bankName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/recipient_banks"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (bankName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("bank_name", bankName));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRecipientBanksValidateBeforeCall(UUID accountId, String status, String bankName, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getRecipientBanks(Async)");
        }

        return getRecipientBanksCall(accountId, status, bankName, _callback);

    }

    /**
     * Retrieve Bank Relationships for an Account
     * Retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @return List&lt;Bank&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    public List<Bank> getRecipientBanks(UUID accountId, String status, String bankName) throws ApiException {
        ApiResponse<List<Bank>> localVarResp = getRecipientBanksWithHttpInfo(accountId, status, bankName);
        return localVarResp.getData();
    }

    /**
     * Retrieve Bank Relationships for an Account
     * Retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @return ApiResponse&lt;List&lt;Bank&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Bank>> getRecipientBanksWithHttpInfo(UUID accountId, String status, String bankName) throws ApiException {
        okhttp3.Call localVarCall = getRecipientBanksValidateBeforeCall(accountId, status, bankName, null);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Bank Relationships for an Account (asynchronously)
     * Retrieves Bank Relationships for an account
     * @param accountId Account identifier. (required)
     * @param status  (optional)
     * @param bankName  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of Bank relationships attached to this Account.  An empty array will be returned if no Bank relationships have been attached to this account </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The body in the request is not valid. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getRecipientBanksAsync(UUID accountId, String status, String bankName, final ApiCallback<List<Bank>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRecipientBanksValidateBeforeCall(accountId, status, bankName, _callback);
        Type localVarReturnType = new TypeToken<List<Bank>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTradingAccount
     * @param accountId Account identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getTradingAccountCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/account"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTradingAccountValidateBeforeCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getTradingAccount(Async)");
        }

        return getTradingAccountCall(accountId, _callback);

    }

    /**
     * Retrieve Trading Details for an Account
     * As a broker you can view more trading details about your users.  The response is a Trading Account model.
     * @param accountId Account identifier. (required)
     * @return TradeAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TradeAccount getTradingAccount(UUID accountId) throws ApiException {
        ApiResponse<TradeAccount> localVarResp = getTradingAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Retrieve Trading Details for an Account
     * As a broker you can view more trading details about your users.  The response is a Trading Account model.
     * @param accountId Account identifier. (required)
     * @return ApiResponse&lt;TradeAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<TradeAccount> getTradingAccountWithHttpInfo(UUID accountId) throws ApiException {
        okhttp3.Call localVarCall = getTradingAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<TradeAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Trading Details for an Account (asynchronously)
     * As a broker you can view more trading details about your users.  The response is a Trading Account model.
     * @param accountId Account identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getTradingAccountAsync(UUID accountId, final ApiCallback<TradeAccount> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTradingAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<TradeAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for patchAccount
     * @param accountId Account identifier. (required)
     * @param accountUpdateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> ​ The request body contains an attribute that is not permitted to be updated or you are attempting to set an invalid value. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchAccountCall(UUID accountId, AccountUpdateRequest accountUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = accountUpdateRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchAccountValidateBeforeCall(UUID accountId, AccountUpdateRequest accountUpdateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling patchAccount(Async)");
        }

        // verify the required parameter 'accountUpdateRequest' is set
        if (accountUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'accountUpdateRequest' when calling patchAccount(Async)");
        }

        return patchAccountCall(accountId, accountUpdateRequest, _callback);

    }

    /**
     * Update an Account
     * This operation updates account information.  If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model.
     * @param accountId Account identifier. (required)
     * @param accountUpdateRequest  (required)
     * @return AccountExtended
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> ​ The request body contains an attribute that is not permitted to be updated or you are attempting to set an invalid value. </td><td>  -  </td></tr>
     </table>
     */
    public AccountExtended patchAccount(UUID accountId, AccountUpdateRequest accountUpdateRequest) throws ApiException {
        ApiResponse<AccountExtended> localVarResp = patchAccountWithHttpInfo(accountId, accountUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update an Account
     * This operation updates account information.  If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model.
     * @param accountId Account identifier. (required)
     * @param accountUpdateRequest  (required)
     * @return ApiResponse&lt;AccountExtended&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> ​ The request body contains an attribute that is not permitted to be updated or you are attempting to set an invalid value. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<AccountExtended> patchAccountWithHttpInfo(UUID accountId, AccountUpdateRequest accountUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = patchAccountValidateBeforeCall(accountId, accountUpdateRequest, null);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update an Account (asynchronously)
     * This operation updates account information.  If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model.
     * @param accountId Account identifier. (required)
     * @param accountUpdateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If all parameters are valid and updates have been made, it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The post body is not well formed. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> ​ The request body contains an attribute that is not permitted to be updated or you are attempting to set an invalid value. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchAccountAsync(UUID accountId, AccountUpdateRequest accountUpdateRequest, final ApiCallback<AccountExtended> _callback) throws ApiException {

        okhttp3.Call localVarCall = patchAccountValidateBeforeCall(accountId, accountUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<AccountExtended>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postPOSTV1AccountsAccountIdActionsReopen
     * @param accountId The id of the account to be reopened. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If the request is succesfully processed it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postPOSTV1AccountsAccountIdActionsReopenCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/actions/reopen"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postPOSTV1AccountsAccountIdActionsReopenValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postPOSTV1AccountsAccountIdActionsReopen(Async)");
        }

        return postPOSTV1AccountsAccountIdActionsReopenCall(accountId, _callback);

    }

    /**
     * Reopen a Closed Account
     * This operation re-activates an account that is in the &#x60;ACCOUNT_CLOSED&#x60; status. Currently, this is only available if you are working with the CIP API setup and it requires a CIP document to be uploaded to the account within at least 30 days of the attempt to reopen the account.
     * @param accountId The id of the account to be reopened. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If the request is succesfully processed it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void postPOSTV1AccountsAccountIdActionsReopen(String accountId) throws ApiException {
        postPOSTV1AccountsAccountIdActionsReopenWithHttpInfo(accountId);
    }

    /**
     * Reopen a Closed Account
     * This operation re-activates an account that is in the &#x60;ACCOUNT_CLOSED&#x60; status. Currently, this is only available if you are working with the CIP API setup and it requires a CIP document to be uploaded to the account within at least 30 days of the attempt to reopen the account.
     * @param accountId The id of the account to be reopened. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If the request is succesfully processed it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> postPOSTV1AccountsAccountIdActionsReopenWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = postPOSTV1AccountsAccountIdActionsReopenValidateBeforeCall(accountId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Reopen a Closed Account (asynchronously)
     * This operation re-activates an account that is in the &#x60;ACCOUNT_CLOSED&#x60; status. Currently, this is only available if you are working with the CIP API setup and it requires a CIP document to be uploaded to the account within at least 30 days of the attempt to reopen the account.
     * @param accountId The id of the account to be reopened. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> If the request is succesfully processed it returns with status code 200. The response is the account model. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postPOSTV1AccountsAccountIdActionsReopenAsync(String accountId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = postPOSTV1AccountsAccountIdActionsReopenValidateBeforeCall(accountId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1AccountsAccountIdActionsClose
     * @param accountId The id of the account to be closed (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1AccountsAccountIdActionsCloseCall(String accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/actions/close"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1AccountsAccountIdActionsCloseValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postV1AccountsAccountIdActionsClose(Async)");
        }

        return postV1AccountsAccountIdActionsCloseCall(accountId, _callback);

    }

    /**
     * Close an Account
     * This operation closes an active account. The underlying records and information of the account are not deleted by this operation.  **Before closing an account, you are responsible for closing all the positions and withdrawing all the money associated with that account. Learn more in the Positions Documentation.**
     * @param accountId The id of the account to be closed (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void postV1AccountsAccountIdActionsClose(String accountId) throws ApiException {
        postV1AccountsAccountIdActionsCloseWithHttpInfo(accountId);
    }

    /**
     * Close an Account
     * This operation closes an active account. The underlying records and information of the account are not deleted by this operation.  **Before closing an account, you are responsible for closing all the positions and withdrawing all the money associated with that account. Learn more in the Positions Documentation.**
     * @param accountId The id of the account to be closed (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> postV1AccountsAccountIdActionsCloseWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = postV1AccountsAccountIdActionsCloseValidateBeforeCall(accountId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Close an Account (asynchronously)
     * This operation closes an active account. The underlying records and information of the account are not deleted by this operation.  **Before closing an account, you are responsible for closing all the positions and withdrawing all the money associated with that account. Learn more in the Positions Documentation.**
     * @param accountId The id of the account to be closed (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1AccountsAccountIdActionsCloseAsync(String accountId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1AccountsAccountIdActionsCloseValidateBeforeCall(accountId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestOptionsForAccount
     * @param accountId Account identifier. (required)
     * @param optionsApprovalRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was submitted successfully. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request body is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The request body did not pass all validations. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call requestOptionsForAccountCall(UUID accountId, OptionsApprovalRequest optionsApprovalRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = optionsApprovalRequest;

        // create path and map variables
        String localVarPath = "/v1/accounts/{account_id}/options/approval"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestOptionsForAccountValidateBeforeCall(UUID accountId, OptionsApprovalRequest optionsApprovalRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling requestOptionsForAccount(Async)");
        }

        // verify the required parameter 'optionsApprovalRequest' is set
        if (optionsApprovalRequest == null) {
            throw new ApiException("Missing the required parameter 'optionsApprovalRequest' when calling requestOptionsForAccount(Async)");
        }

        return requestOptionsForAccountCall(accountId, optionsApprovalRequest, _callback);

    }

    /**
     * Request options trading for an account (BETA)
     * This endpoint requests options trading for an account. Following submission, an assigned administrator will review the request.  Upon approval, the account&#39;s options_approved_level parameter will be modified, granting the account the ability to participate in options trading. Note: This endpoint is only available for partners who have been enabled for Options BETA.
     * @param accountId Account identifier. (required)
     * @param optionsApprovalRequest  (required)
     * @return OptionsApprovalResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was submitted successfully. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request body is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The request body did not pass all validations. </td><td>  -  </td></tr>
     </table>
     */
    public OptionsApprovalResponse requestOptionsForAccount(UUID accountId, OptionsApprovalRequest optionsApprovalRequest) throws ApiException {
        ApiResponse<OptionsApprovalResponse> localVarResp = requestOptionsForAccountWithHttpInfo(accountId, optionsApprovalRequest);
        return localVarResp.getData();
    }

    /**
     * Request options trading for an account (BETA)
     * This endpoint requests options trading for an account. Following submission, an assigned administrator will review the request.  Upon approval, the account&#39;s options_approved_level parameter will be modified, granting the account the ability to participate in options trading. Note: This endpoint is only available for partners who have been enabled for Options BETA.
     * @param accountId Account identifier. (required)
     * @param optionsApprovalRequest  (required)
     * @return ApiResponse&lt;OptionsApprovalResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was submitted successfully. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request body is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The request body did not pass all validations. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<OptionsApprovalResponse> requestOptionsForAccountWithHttpInfo(UUID accountId, OptionsApprovalRequest optionsApprovalRequest) throws ApiException {
        okhttp3.Call localVarCall = requestOptionsForAccountValidateBeforeCall(accountId, optionsApprovalRequest, null);
        Type localVarReturnType = new TypeToken<OptionsApprovalResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request options trading for an account (BETA) (asynchronously)
     * This endpoint requests options trading for an account. Following submission, an assigned administrator will review the request.  Upon approval, the account&#39;s options_approved_level parameter will be modified, granting the account the ability to participate in options trading. Note: This endpoint is only available for partners who have been enabled for Options BETA.
     * @param accountId Account identifier. (required)
     * @param optionsApprovalRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was submitted successfully. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request body is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Client does not exists, you do not have access to the client, or “client_secret” is incorrect.  </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The request body did not pass all validations. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call requestOptionsForAccountAsync(UUID accountId, OptionsApprovalRequest optionsApprovalRequest, final ApiCallback<OptionsApprovalResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestOptionsForAccountValidateBeforeCall(accountId, optionsApprovalRequest, _callback);
        Type localVarReturnType = new TypeToken<OptionsApprovalResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
