/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;

import okio.ByteString;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;
import java.util.TimeZone;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    private static final StdDateFormat sdf = new StdDateFormat()
        .withTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()))
        .withColonInTimeZone(true);
    private static final DateTimeFormatter dtf = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
                .registerTypeSelector(net.jacobpeterson.alpaca.openapi.broker.model.JournalResource.class, new TypeSelector<net.jacobpeterson.alpaca.openapi.broker.model.JournalResource>() {
                    @Override
                    public Class<? extends net.jacobpeterson.alpaca.openapi.broker.model.JournalResource> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("JNLC", net.jacobpeterson.alpaca.openapi.broker.model.JNLC.class);
                        classByDiscriminatorValue.put("JNLS", net.jacobpeterson.alpaca.openapi.broker.model.JNLS.class);
                        classByDiscriminatorValue.put("JournalResource", net.jacobpeterson.alpaca.openapi.broker.model.JournalResource.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "entry_type"));
                    }
          })
                .registerTypeSelector(net.jacobpeterson.alpaca.openapi.broker.model.TransferData.class, new TypeSelector<net.jacobpeterson.alpaca.openapi.broker.model.TransferData>() {
                    @Override
                    public Class<? extends net.jacobpeterson.alpaca.openapi.broker.model.TransferData> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("TransferData", net.jacobpeterson.alpaca.openapi.broker.model.TransferData.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "transfer_type"));
                    }
          })
                .registerTypeSelector(net.jacobpeterson.alpaca.openapi.broker.model.TransferResource.class, new TypeSelector<net.jacobpeterson.alpaca.openapi.broker.model.TransferResource>() {
                    @Override
                    public Class<? extends net.jacobpeterson.alpaca.openapi.broker.model.TransferResource> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("TransferResource", net.jacobpeterson.alpaca.openapi.broker.model.TransferResource.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "type"));
                    }
          })
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    static {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ACHRelationship.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Account.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountBeneficiary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountConfigurations.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountCreationRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountDocument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountExtended.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountStatusEvent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AccountUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Activity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ActivityItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionBelongsTo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionContextLiquidationContext.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionContextTransactionCancelContext.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionCreatedBy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionEventGeneral.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionLegacyNote.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionLiquidation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminActionTransactionCancel.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AdminConfigurations.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AggregatePositionResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Agreement.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Announcement.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ApplicationDocument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Asset.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.AuthorizeOAuthTokenResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Bank.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.BankInformation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.BatchCreateFundingWalletRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.BatchCreateFundingWalletResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalRequestEntriesInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CIPDocument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CIPIdentity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CIPInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CIPKYC.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CIPPhoto.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CIPWatchlist.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Calendar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Clock.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Contact.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CountryInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateACHRelationshipRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateBankRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateFundingWalletWithdrawalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateJournalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequestStopLoss.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequestTakeProfit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateTransferRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CreateWatchlistRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.CustodialAccountMinorIdentity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.DailyTradingLimit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.DemoFundingTransfer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.DisclosureContextAnnotation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Disclosures.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.DocumentInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.DocumentUpload.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.DocumentUploadRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.FundingDetail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.FundingWallet.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletRecipientBank.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.FundingWalletTransfer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetOptionsContracts200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetV1AccountsAccountIdOnfidoSdkTokens200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetV1AccountsPositions200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetV1ReportingEodPositions200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetV1ReportingEodPositionsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetV1TradingAccountsAccountIdOrdersEstimationRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.GetV1TransfersJitLedgerIdBalances200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Identity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.IssueOAuthTokenResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JITLedgerAccount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JITReport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JNLC.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JNLS.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Journal.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JournalData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JournalResource.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.JournalStatusEvent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.KYCResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ListFundingDetails.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ListTransfersResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.NonTradeActivity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.OAuthTokenRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.OathClientResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.OptionContract.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.OptionsApprovalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.OptionsApprovalResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Order.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.OrderClosedResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PatchV1AccountsAccountIdOnfidoSdkRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PatchV1RebalancingPortfoliosPortfolioIdRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Portfolio.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PortfolioHistory.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PortfolioRun.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PortfolioRunStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PortfolioSubscription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PortfolioWeights.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Position.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PositionClosedResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PostV1RebalancingPortfoliosRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PostV1RebalancingRunsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PostV1RebalancingSubscriptionsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.RebalancingConditions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.RestrictToLiquidationReasons.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.RetrieveJITReportRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ReverseBatchJournalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.ReverseBatchJournalRequestEntriesInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.SkippedOrder.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.SubscribeToAdminActionSSE200ResponseInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TradeAccount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TradeActivity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEvent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEventV2.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Transaction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Transfer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TransferData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TransferFee.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TransferResource.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TransferStatusEvent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.USDBalances.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.USDPosition.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.UntypedACHTransferData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.UntypedTransferData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.UntypedWireTransferData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.UpdateOrderRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Usd.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.W8benDocument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new net.jacobpeterson.alpaca.openapi.broker.model.Watchlist.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(sdf.parse(date).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, DateTimeFormatter will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toInstant().atOffset(ZoneOffset.UTC).format(dtf);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return sdf.parse(date);
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
