/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.test.live;

import java.time.ZonedDateTime;
import java.util.List;
import net.jacobpeterson.alpaca.AlpacaAPI;
import net.jacobpeterson.alpaca.model.endpoint.account.Account;
import net.jacobpeterson.alpaca.model.endpoint.accountactivities.AccountActivity;
import net.jacobpeterson.alpaca.model.endpoint.accountactivities.NonTradeActivity;
import net.jacobpeterson.alpaca.model.endpoint.accountactivities.TradeActivity;
import net.jacobpeterson.alpaca.model.endpoint.accountactivities.enums.ActivityType;
import net.jacobpeterson.alpaca.model.endpoint.accountconfiguration.AccountConfiguration;
import net.jacobpeterson.alpaca.model.endpoint.accountconfiguration.enums.DTBPCheck;
import net.jacobpeterson.alpaca.model.endpoint.accountconfiguration.enums.TradeConfirmEmail;
import net.jacobpeterson.alpaca.model.endpoint.clock.Clock;
import net.jacobpeterson.alpaca.model.endpoint.common.enums.SortDirection;
import net.jacobpeterson.alpaca.model.endpoint.orders.Order;
import net.jacobpeterson.alpaca.model.endpoint.orders.enums.CurrentOrderStatus;
import net.jacobpeterson.alpaca.rest.AlpacaClientException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class AlpacaAPITest {
    private static final Logger LOGGER;
    private static final int RATE_LIMIT_MILLIS = 200;
    private static AlpacaAPI alpacaAPI;
    private static boolean marketOpen;
    private static AccountConfiguration accountConfiguration;

    @BeforeAll
    public static void beforeAll() {
        alpacaAPI = new AlpacaAPI();
        marketOpen = false;
    }

    @BeforeEach
    public void beforeEach() {
    }

    @AfterEach
    public void afterEach() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException exception) {
            Assertions.fail((String)"Interrupted when tearing down!");
        }
    }

    @Test
    @org.junit.jupiter.api.Order(value=1)
    public void testClockEndpointGet() throws AlpacaClientException {
        Clock clock = alpacaAPI.clock().get();
        Assertions.assertNotNull((Object)clock);
        LOGGER.debug("{}", (Object)clock);
        Assertions.assertNotNull((Object)clock.getTimestamp());
        Assertions.assertNotNull((Object)clock.getIsOpen());
        Assertions.assertNotNull((Object)clock.getNextOpen());
        Assertions.assertNotNull((Object)clock.getNextClose());
        marketOpen = clock.getIsOpen();
        if (marketOpen) {
            LOGGER.info("Market is currently open! All live endpoints will be tested.");
        } else {
            LOGGER.info("Market is currently closed! Only some live endpoints will be tested.");
        }
    }

    @Test
    public void testAccountEndpointGet() throws AlpacaClientException, NumberFormatException {
        Account account = alpacaAPI.account().get();
        Assertions.assertNotNull((Object)account);
        LOGGER.debug("{}", (Object)account);
        Double.parseDouble(account.getCash());
        Double.parseDouble(account.getPortfolioValue());
        Double.parseDouble(account.getLongMarketValue());
        Double.parseDouble(account.getShortMarketValue());
        Double.parseDouble(account.getEquity());
        Double.parseDouble(account.getLastEquity());
        Double.parseDouble(account.getBuyingPower());
        Double.parseDouble(account.getInitialMargin());
        Double.parseDouble(account.getMaintenanceMargin());
        Double.parseDouble(account.getLastMaintenanceMargin());
        Double.parseDouble(account.getDaytradingBuyingPower());
        Double.parseDouble(account.getRegtBuyingPower());
        Assertions.assertNotNull((Object)account.getId());
        Assertions.assertNotNull((Object)account.getAccountNumber());
        Assertions.assertNotNull((Object)account.getStatus());
        Assertions.assertNotNull((Object)account.getCurrency());
        Assertions.assertNotNull((Object)account.getPatternDayTrader());
        Assertions.assertNotNull((Object)account.getTradeSuspendedByUser());
        Assertions.assertNotNull((Object)account.getTradingBlocked());
        Assertions.assertNotNull((Object)account.getTransfersBlocked());
        Assertions.assertNotNull((Object)account.getAccountBlocked());
        Assertions.assertNotNull((Object)account.getCreatedAt());
        Assertions.assertNotNull((Object)account.getShortingEnabled());
        Assertions.assertNotNull((Object)account.getMultiplier());
        Assertions.assertNotNull((Object)account.getSma());
        Assertions.assertNotNull((Object)account.getDaytradeCount());
    }

    @Test
    public void testAccountActivitiesEndpointGetOneActivityExistsUntilNow() throws AlpacaClientException {
        List accountActivities = alpacaAPI.accountActivities().get(null, ZonedDateTime.now(), null, SortDirection.ASCENDING, Integer.valueOf(1), null, (ActivityType[])null);
        Assertions.assertNotNull((Object)accountActivities);
        Assertions.assertFalse((boolean)accountActivities.isEmpty());
        accountActivities.forEach(accountActivity -> LOGGER.debug(accountActivity.toString()));
        AccountActivity accountActivity2 = (AccountActivity)accountActivities.get(0);
        if (accountActivity2 instanceof TradeActivity) {
            TradeActivity tradeActivity = (TradeActivity)accountActivity2;
            Assertions.assertNotNull((Object)tradeActivity.getActivityType());
            Assertions.assertNotNull((Object)tradeActivity.getId());
            Assertions.assertNotNull((Object)tradeActivity.getCumulativeQuantity());
            Assertions.assertNotNull((Object)tradeActivity.getRemainingQuantity());
            Assertions.assertNotNull((Object)tradeActivity.getPrice());
            Assertions.assertNotNull((Object)tradeActivity.getQuantity());
            Assertions.assertNotNull((Object)tradeActivity.getSide());
            Assertions.assertNotNull((Object)tradeActivity.getSymbol());
            Assertions.assertNotNull((Object)tradeActivity.getTransactionTime());
            Assertions.assertNotNull((Object)tradeActivity.getOrderId());
            Assertions.assertNotNull((Object)tradeActivity.getType());
        } else if (accountActivity2 instanceof NonTradeActivity) {
            NonTradeActivity nonTradeActivity = (NonTradeActivity)accountActivity2;
            Assertions.assertNotNull((Object)nonTradeActivity.getActivityType());
            Assertions.assertNotNull((Object)nonTradeActivity.getId());
            Assertions.assertNotNull((Object)nonTradeActivity.getDate());
            Assertions.assertNotNull((Object)nonTradeActivity.getNetAmount());
            Assertions.assertNotNull((Object)nonTradeActivity.getSymbol());
            Assertions.assertNotNull((Object)nonTradeActivity.getQuantity());
            Assertions.assertNotNull((Object)nonTradeActivity.getPerShareAmount());
            Assertions.assertNotNull((Object)nonTradeActivity.getDescription());
        }
    }

    @Test
    @org.junit.jupiter.api.Order(value=1)
    public void testAccountConfigurationEndpointGet() throws AlpacaClientException {
        AccountConfiguration accountConfiguration = alpacaAPI.accountConfiguration().get();
        Assertions.assertNotNull((Object)accountConfiguration);
        LOGGER.debug("{}", (Object)accountConfiguration);
        Assertions.assertNotNull((Object)accountConfiguration.getDtbpCheck());
        Assertions.assertNotNull((Object)accountConfiguration.getTradeConfirmEmail());
        Assertions.assertNotNull((Object)accountConfiguration.getSuspendTrade());
        Assertions.assertNotNull((Object)accountConfiguration.getNoShorting());
        AlpacaAPITest.accountConfiguration = accountConfiguration;
    }

    @Test
    @org.junit.jupiter.api.Order(value=2)
    public void testAccountConfigurationEndpointSet() throws AlpacaClientException {
        if (accountConfiguration == null) {
            AccountConfiguration newAccountConfiguration = new AccountConfiguration(DTBPCheck.BOTH, TradeConfirmEmail.NONE, Boolean.valueOf(false), Boolean.valueOf(false));
            LOGGER.info("Settings Account Configuration to: {}", (Object)newAccountConfiguration);
            alpacaAPI.accountConfiguration().set(newAccountConfiguration);
        } else {
            alpacaAPI.accountConfiguration().set(accountConfiguration);
        }
    }

    @Test
    public void testOrdersEndpointGetOneOrderExistsUntilNow() throws AlpacaClientException {
        List orders = alpacaAPI.orders().get(CurrentOrderStatus.ALL, Integer.valueOf(1), null, ZonedDateTime.now(), SortDirection.ASCENDING, Boolean.valueOf(true), null);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertFalse((boolean)orders.isEmpty());
        orders.forEach(order -> LOGGER.debug("{}", order));
        Order order2 = (Order)orders.get(0);
        Assertions.assertNotNull((Object)order2.getId());
        Assertions.assertNotNull((Object)order2.getClientOrderId());
        Assertions.assertNotNull((Object)order2.getCreatedAt());
        Assertions.assertNotNull((Object)order2.getUpdatedAt());
        Assertions.assertNotNull((Object)order2.getSubmittedAt());
        Assertions.assertNotNull((Object)order2.getAssetId());
        Assertions.assertNotNull((Object)order2.getSymbol());
        Assertions.assertNotNull((Object)order2.getAssetClass());
        Assertions.assertNotNull((Object)order2.getQuantity());
        Assertions.assertNotNull((Object)order2.getFilledQuantity());
        Assertions.assertNotNull((Object)order2.getType());
        Assertions.assertNotNull((Object)order2.getSide());
        Assertions.assertNotNull((Object)order2.getTimeInForce());
        Assertions.assertNotNull((Object)order2.getStatus());
        Assertions.assertNotNull((Object)order2.getExtendedHours());
    }

    static {
        System.setProperty("org.slf4j.simpleLogger.log.net.jacobpeterson", "trace");
        LOGGER = LoggerFactory.getLogger(AlpacaAPITest.class);
    }
}

