package net.jackadull.specdriven.specification.requirement

import net.jackadull.specdriven.specification.model.{ExpectationModel, RequirementModel}

import scala.language.postfixOps

trait SpecDrivenWhen extends SpecDrivenRequirementResources {
  trait When_calling_cleanUp_in_the_requirement[+O] extends SpecDrivenRequirementStep with ContainsRequirement[O] {
    override def perform() {requirement cleanUp()}
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "calling `cleanUp()` in the requirement"
  }

  trait When_calling_perform_in_the_requirement[+O] extends SpecDrivenRequirementStep with ContainsRequirement[O] {
    override def perform() {requirement perform()}
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "calling `perform()` in the requirement"
  }

  trait When_taking_the_complete_phrase_of_the_requirement extends SpecDrivenRequirementStep with ContainsRequirement[Int] with ContainsTheValue {
    override def theValue:Any = requirement completePhrase
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "taking the *Complete Phrase* of the requirement"
  }

  trait When_taking_the_expectation_number[+O] extends SpecDrivenRequirementStep with ContainsExpectation[O] with ContainsRequirement[O] {
    def expectationNumberToTake:Int
    override def expectation:ExpectationModel[O] = requirement.expectations(expectationNumberToTake - 1)
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ s"taking expectation number $expectationNumberToTake"
  }

  trait When_taking_the_expectations_description[+O] extends SpecDrivenRequirementStep with ContainsExpectation[O] with ContainsTheValue {
    override def theValue:Any = expectation description
  }

  trait When_taking_the_expectations_outcome[+O] extends SpecDrivenRequirementStep with ContainsExpectation[O] with ContainsTheValue {
    override def theValue:Any = expectation outcome()
  }

  trait When_taking_the_given_and_when_setup_of_the_requirement extends SpecDrivenRequirementStep with ContainsRequirement[Int] with ContainsTheValue {
    override def theValue:Any = requirement givenAndWhenSetup
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "taking the *Given and When Setup* of the requirement"
  }

  trait When_taking_the_number_of_expectations_of_the_requirement[+O] extends SpecDrivenRequirementStep with ContainsRequirement[O] with ContainsTheValue {
    override def theValue:Any = (requirement expectations) size
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "taking the number of expectations of the requirement"
  }

  trait When_taking_the_requirement_number[+O] extends SpecDrivenRequirementStep with ContainsRequirement[O] with ContainsSpecification[O] {
    def requirementNumberToTake:Int
    override def requirement:RequirementModel[O] = specification.requirements(requirementNumberToTake - 1)
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ s"taking requirment number $requirementNumberToTake"
  }

  trait When_taking_the_requirements_title[+O] extends SpecDrivenRequirementStep with ContainsRequirement[O] with ContainsTheValue {
    override def theValue:Any = requirement requirementTitle
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "taking the requirement's title"
  }

  trait When_taking_the_specifications_title[+O] extends SpecDrivenRequirementStep with ContainsSpecification[O] with ContainsTheValue {
    override def theValue:Any = specification specificationTitle
    override def whenDescriptions:Seq[String] = super.whenDescriptions :+ "taking the specification's title"
  }
}
