package net.jackadull.specdriven.specification.requirement
import net.jackadull.specdriven.requirement.Expectation
import net.jackadull.specdriven.specification.model.SpecificationModel

import scala.language.postfixOps

trait SpecDrivenThen extends SpecDrivenRequirementResources {
  trait Then_the_cleanup_counter_is extends SpecDrivenRequirementStep with ContainsCallbackCounters {
    def expectedCleanUpCounter:Int
    override def expectations:Seq[Expectation[Either[String,Unit]]] =
      super.expectations :+ Expectation(s"the cleanUp counter is $expectedCleanUpCounter") {cleanUpCounter get match {
        case expected if expected==expectedCleanUpCounter ⇒ Right(())
        case unexpected ⇒ Left(s"expected a cleanUp counter of $expectedCleanUpCounter, but got $unexpected")
      }}
  }

  trait Then_the_perform_counter_is extends SpecDrivenRequirementStep with ContainsCallbackCounters {
    def expectedPerformCounter:Int
    override def expectations:Seq[Expectation[Either[String,Unit]]] =
      super.expectations :+ Expectation(s"the perform counter is $expectedPerformCounter") {performCounter get match {
        case expected if expected==expectedPerformCounter ⇒ Right(())
        case unexpected ⇒ Left(s"expected a perform counter of $expectedPerformCounter, but got $unexpected")
      }}
  }

  trait Then_the_specifications_are_the_same_except_for_string_outcomes[+O] extends SpecDrivenRequirementStep with ContainsAnotherSpecification[String] with ContainsSpecification[O] {
    override def expectations:Seq[Expectation[Either[String,Unit]]] =
      super.expectations :+ Expectation("both specifications are the same, except for the toString-ed outcomes")(checkSameness(specification, otherSpecification))
  }

  trait Then_the_value_is extends SpecDrivenRequirementStep with ContainsTheValue {
    def expectedValue:Any
    override def expectations:Seq[Expectation[Either[String,Unit]]] =
      super.expectations :+ Expectation(s"the value is '$expectedValue'") {theValue match {
        case expected if expected==expectedValue ⇒ Right(())
        case unexpected ⇒ Left(s"expected '$expectedValue', but found '$unexpected'")
      }}
  }

  private def checkSameness[O](spec1:SpecificationModel[O], spec2:SpecificationModel[String]):Either[String,Unit] =
    if((spec1 specificationTitle) != (spec2 specificationTitle)) Left(s"specification titles are different: '${spec1 specificationTitle}' vs. '${spec2 specificationTitle}'")
    else if(((spec1 requirements) size) != ((spec2 requirements) size)) Left(s"specifications have different number of requirements: ${spec1.requirements size} vs. ${spec2.requirements size}")
    else (((spec1 requirements) zip (spec2 requirements)) zipWithIndex).foldLeft[Either[String,Unit]](Right(())) {
      case (l@Left(_), _) ⇒ l
      case (Right(()), ((req1, req2), reqIndex)) ⇒
        if((req1 requirementTitle) != (req2 requirementTitle)) Left(s"requirements at index $reqIndex have different titles: '${req1 requirementTitle}' vs. '${req2 requirementTitle}'")
        else if((req1 givenAndWhenSetup) != (req2 givenAndWhenSetup)) Left(s"requirements at index $reqIndex have different 'given and when setups': '${req1 givenAndWhenSetup}' vs. '${req2 givenAndWhenSetup}'")
        else if((req1 completePhrase) != (req2 completePhrase)) Left(s"requirements at index $reqIndex have different 'complete phrases': '${req1 completePhrase}' vs. '${req2 completePhrase}'")
        else if(((req1 expectations) size) != ((req2 expectations) size)) Left(s"requirements at index $reqIndex have different number of expectations: ${req1.expectations size} vs. ${req2.expectations size}")
        else (((req1 expectations) zip (req2 expectations)) zipWithIndex).foldLeft[Either[String,Unit]](Right(())) {
          case (l@Left(_), _) ⇒ l
          case (Right(()), ((exp1, exp2), expIndex)) ⇒
            if((exp1 description) != (exp2 description)) Left(s"expections at index $expIndex of requirements at index $reqIndex have different descriptions: '${exp1 description}' vs. '${exp2 description}'")
            else {
              val str1 = s"${exp1 outcome()}"
              val str2 = s"${exp2 outcome()}"
              if(str1 != str2) Left(s"expectations at index $expIndex of requirements at index $reqIndex have different (toString-ed) outcomes: '$str1' vs. '$str2'")
              else Right(())
            }
        }
    }
}
