package net.jackadull.specdriven.specification.requirement

import java.util.concurrent.atomic.AtomicInteger

import net.jackadull.specdriven.requirement.RequirementResources
import net.jackadull.specdriven.specification.model.{ExpectationModel, RequirementModel, SpecificationModel}

trait SpecDrivenRequirementResources extends RequirementResources {
  def newDemoSpecification(cleanUpCallback:()⇒Unit, performCallback:()⇒Unit):SpecificationModel[Int]

  trait ContainsAnotherSpecification[+O] {def otherSpecification:SpecificationModel[O] = unassigned("otherSpecification")}
  trait ContainsCallbackCounters {
    val cleanUpCounter = new AtomicInteger
    val performCounter = new AtomicInteger
  }
  trait ContainsExpectation[+O] {def expectation:ExpectationModel[O] = unassigned("expectation")}
  trait ContainsRequirement[+O] {def requirement:RequirementModel[O] = unassigned("requirement")}
  trait ContainsSpecification[+O] {def specification:SpecificationModel[O] = unassigned("specification")}
  trait ContainsTheValue {def theValue:Any = unassigned("theValue")}
}
