package net.jackadull.specdriven.specification.requirement

import net.jackadull.specdriven.specification.model.SpecificationModel

import scala.language.postfixOps

trait SpecDrivenGiven extends SpecDrivenRequirementResources {
  trait Given_another_specification_that_is_mapped_to_string[+O] extends SpecDrivenRequirementStep with ContainsAnotherSpecification[String] with ContainsSpecification[O] {
    override def givenDescriptions:Seq[String] = super.givenDescriptions :+ "another specification that is the first with outcomes mapped to strings"
    override lazy val otherSpecification:SpecificationModel[String] = specification map {_ toString}
  }

  trait Given_the_demo_specification extends SpecDrivenRequirementStep with ContainsSpecification[Int] with ContainsCallbackCounters {
    private lazy val demoSpec:SpecificationModel[Int] = newDemoSpecification(()⇒cleanUpCounter.incrementAndGet(), ()⇒performCounter.incrementAndGet())
    override def givenDescriptions:Seq[String] = super.givenDescriptions :+ "the demo specification"
    override def specification:SpecificationModel[Int] = demoSpec
  }
}
