package net.jackadull.specdriven.specification

import net.jackadull.specdriven.Specification
import net.jackadull.specdriven.requirement.Requirement
import net.jackadull.specdriven.specification.model.SpecificationModel
import net.jackadull.specdriven.specification.requirement.{SpecDrivenGiven, SpecDrivenThen, SpecDrivenWhen}

import scala.language.higherKinds

trait SpecDrivenSpecification extends Specification[Either[String,Unit]] with SpecDrivenGiven with SpecDrivenWhen with SpecDrivenThen {
  def newDemoSpecification(cleanUpCallback:()⇒Unit, performCallback:()⇒Unit):SpecificationModel[Int]

  def requirements:Seq[Requirement[Either[String,Unit]]] = Seq(
    new Requirement[Either[String,Unit]]
    with Given_the_demo_specification
    with When_taking_the_specifications_title[Int]
    with Then_the_value_is {
      def expectedValue = "Demo Specification"
      def requirementTitle:String = s"The title of the demo specification is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
    with Given_the_demo_specification
    with When_taking_the_requirement_number[Int]
    with When_taking_the_requirements_title[Int]
    with Then_the_value_is {
      def expectedValue = "First Requirement"
      def requirementNumberToTake = 1
      def requirementTitle:String = s"The title of the first requirement is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
    with Given_the_demo_specification
    with When_taking_the_requirement_number[Int]
    with When_taking_the_complete_phrase_of_the_requirement
    with Then_the_value_is {
      def expectedValue = "(no requirement)"
      def requirementNumberToTake = 1
      def requirementTitle:String = s"The 'complete phrase' of the first requirement is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
      with Given_the_demo_specification
      with When_taking_the_requirement_number[Int]
      with When_taking_the_given_and_when_setup_of_the_requirement
      with Then_the_value_is {
      def expectedValue = "(no setup)"
      def requirementNumberToTake = 1
      def requirementTitle:String = s"The 'given and when setup' of the first requirement is '$expectedValue'"
    },


    new Requirement[Either[String, Unit]]
      with Given_the_demo_specification
      with When_taking_the_requirement_number[Int]
      with When_taking_the_number_of_expectations_of_the_requirement[Int]
      with Then_the_value_is {
      def expectedValue = 0
      def requirementNumberToTake = 1
      def requirementTitle:String = s"The number of expectations of the first requirement is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
    with Given_the_demo_specification
    with When_taking_the_requirement_number[Int]
    with When_taking_the_complete_phrase_of_the_requirement
    with Then_the_value_is {
      def expectedValue = "GIVEN a, b and c, WHEN the stars align and it feels right, THEN outcome is 42 and outcome is -13"
      def requirementNumberToTake = 2
      def requirementTitle:String = s"The 'complete phrase' of the second requirement is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
    with Given_the_demo_specification
    with When_taking_the_requirement_number[Int]
    with When_taking_the_given_and_when_setup_of_the_requirement
    with Then_the_value_is {
      def expectedValue = "GIVEN a, b and c, WHEN the stars align and it feels right"
      def requirementNumberToTake = 2
      def requirementTitle:String = s"The 'given and when setup' of the second requirement is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
    with Given_the_demo_specification
    with When_taking_the_requirement_number[Int]
    with When_taking_the_expectation_number[Int]
    with When_taking_the_expectations_description[Int]
    with Then_the_value_is {
      def expectedValue = "outcome is 42"
      def expectationNumberToTake = 1
      def requirementNumberToTake = 2
      def requirementTitle:String = s"The description of the first expectation of the second requirement is '$expectedValue'"
    },

    new Requirement[Either[String, Unit]]
      with Given_the_demo_specification
      with When_taking_the_requirement_number[Int]
      with When_taking_the_expectation_number[Int]
      with When_taking_the_expectations_outcome[Int]
      with Then_the_value_is {
      def expectedValue = -13
      def expectationNumberToTake = 2
      def requirementNumberToTake = 2
      def requirementTitle:String = s"The outcome of the second expectation of the second requirement is $expectedValue"
    },

    new Requirement[Either[String,Unit]]
    with Given_the_demo_specification
    with When_taking_the_requirement_number[Int]
    with When_calling_perform_in_the_requirement[Int]
    with Then_the_cleanup_counter_is
    with Then_the_perform_counter_is {
      def expectedCleanUpCounter = 0
      def expectedPerformCounter = 0
      def requirementNumberToTake = 1
      def requirementTitle:String = "Calling perform() on the first requirement has no effect"
    },

    new Requirement[Either[String,Unit]]
      with Given_the_demo_specification
      with When_taking_the_requirement_number[Int]
      with When_calling_cleanUp_in_the_requirement[Int]
      with Then_the_cleanup_counter_is
      with Then_the_perform_counter_is {
      def expectedCleanUpCounter = 0
      def expectedPerformCounter = 0
      def requirementNumberToTake = 1
      def requirementTitle:String = "Calling cleanUp() on the first requirement has no effect"
    },

    new Requirement[Either[String,Unit]]
      with Given_the_demo_specification
      with When_taking_the_requirement_number[Int]
      with When_calling_perform_in_the_requirement[Int]
      with Then_the_cleanup_counter_is
      with Then_the_perform_counter_is {
      def expectedCleanUpCounter = 0
      def expectedPerformCounter = 1
      def requirementNumberToTake = 2
      def requirementTitle:String = "Calling perform() on the second requirement increases the perform counter"
    },

    new Requirement[Either[String,Unit]]
      with Given_the_demo_specification
      with When_taking_the_requirement_number[Int]
      with When_calling_cleanUp_in_the_requirement[Int]
      with Then_the_cleanup_counter_is
      with Then_the_perform_counter_is {
      def expectedCleanUpCounter = 1
      def expectedPerformCounter = 0
      def requirementNumberToTake = 2
      def requirementTitle:String = "Calling cleanUp() on the second requirement increases the cleanUp counter"
    },

    new Requirement[Either[String, Unit]]
    with Given_the_demo_specification
    with Given_another_specification_that_is_mapped_to_string[Int]
    with Then_the_specifications_are_the_same_except_for_string_outcomes[Int] {
      def requirementTitle:String = "Mapping a specification retains most of its properties"
    }
  )
  def specificationTitle:String = "SpecDriven"
}
