package net.jackadull.specdriven.adapter.scalatest

import net.jackadull.specdriven.requirement.{Expectation, FeatureNotImplemented}

import scala.util.Try

trait ScalaTestAssertOutcome[-O] {
  def apply(outcome:O):Unit
}
object ScalaTestAssertOutcome {
  import org.scalatest.Assertions._

  def apply(expectation:Expectation[()=>Unit], acceptFeatureNotImplemented:Boolean, perform: =>Try[Unit]=Try(())):Unit =
    try {perform.get; expectation.outcome()()}
    catch {case notImplemented:FeatureNotImplemented =>
      Console.err.println("----- Feature not implemented")
      notImplemented.printStackTrace(Console.err)
      Console.err.println("-----")
      if(acceptFeatureNotImplemented) cancel("feature not implemented")
      else fail("feature not implemented‚")
    }

  implicit val ofEitherAny:ScalaTestAssertOutcome[Either[Any,Unit]] = {
    case Right(()) => ()
    case Left(error:Throwable) => fail(error)
    case Left(error) => fail(s"$error")
  }
}
