/*
 * Decompiled with CFR 0.152.
 */
package net.itrixlabs.cache.util;

public final class Assert {
    public static void assertNotNull(Object arg, String message) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNull(Object arg) throws IllegalArgumentException {
        Assert.assertNotNull(arg, "[Assertion Error]: Argument is null");
    }

    public static void assertNotNull(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Assert.assertNotNull(args[i], "[Assertion Error]: Atleast one argument is null");
        }
    }

    public static void assertEquals(Object arg1, Object arg2, String message) {
        Assert.assertNotNull(arg1, arg2);
        if (arg1.getClass().isAssignableFrom(arg2.getClass()) && !arg1.equals(arg2)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertEquals(Object arg1, Object arg2) {
        Assert.assertEquals(arg1, arg2, "[Assertion Error]: Arguments aren't equal");
    }

    public static void assertEquals(Object ... args) {
        for (int i = 0; i < args.length - 1; ++i) {
            Assert.assertEquals(args[i], args[i + 1], "[Assertion Error]: Atleast one argument is different");
        }
    }

    public static void assertNotEmpty(Object arg, String message) {
        Assert.assertNotNull(arg, message);
        if (arg instanceof String && ((String)arg).trim() == "") {
            throw new IllegalArgumentException(message);
        }
        if (arg instanceof StringBuilder && ((StringBuilder)arg).toString().trim().equals("")) {
            throw new IllegalArgumentException(message);
        }
        if (arg instanceof StringBuffer && ((StringBuffer)arg).toString().trim().equals("")) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(Object arg) {
        Assert.assertNotEmpty(arg, "[Assertion Error]: Either not a string type, null or empty");
    }

    public static void assertNotEmpty(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Assert.assertNotEmpty(args[i], "[Assertion Error]: Atleast one argument is either not a string type, null or empty");
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition, "[Assertion Error]: Condition is false");
    }

    public static void assertTrue(boolean ... conditions) {
        for (int i = 0; i < conditions.length; ++i) {
            Assert.assertTrue(conditions[i], "[Assertion Error]: Atleast one condition is false");
        }
    }
}

