/*
 * Decompiled with CFR 0.152.
 */
package net.itrixlabs.cache;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.itrixlabs.cache.SerializableCacheManagementWorker;
import net.itrixlabs.cache.auth.SerializableAuthCache;
import net.itrixlabs.cache.core.CacheManager;
import net.itrixlabs.cache.csrf.SerializableCsrfCache;
import net.itrixlabs.cache.user.SerializableUserCache;
import net.itrixlabs.cache.util.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerializableCacheManager<U, A, C>
implements CacheManager {
    private static final Log logger = LogFactory.getLog(SerializableCacheManager.class);
    private SerializableUserCache<U> userCache;
    private SerializableAuthCache<A> authCache;
    private SerializableCsrfCache<C> csrfCache;
    private ScheduledThreadPoolExecutor cacheManagementExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(10);
    private SerializableCacheManagementWorker<U, A, C> serializableCacheManagementWorker = new SerializableCacheManagementWorker();

    public void afterPropertiesSet() {
        this.serializableCacheManagementWorker.setAuthCache(this.authCache);
        this.serializableCacheManagementWorker.setUserCache(this.userCache);
        this.serializableCacheManagementWorker.setCsrfCache(this.csrfCache);
        Assert.assertNotNull((Object)this.cacheManagementExecutor, "Cache management executor is not initialized!");
        Assert.assertNotNull(this.serializableCacheManagementWorker, "Cache management worker thread pool can't be null!");
        this.cacheManagementExecutor.scheduleAtFixedRate(this.serializableCacheManagementWorker, 60L, 600L, TimeUnit.SECONDS);
    }

    public void destroy() {
        logger.info((Object)"Shutting down Cache Management System. Please do not interrupt this operation. It is best that you stay away from the management console for now!");
        try {
            this.cacheManagementExecutor.shutdown();
            if (this.cacheManagementExecutor.isShutdown()) {
                logger.info((Object)"Cache Management System was shut down successfully.");
            } else {
                this.cacheManagementExecutor.awaitTermination(60L, TimeUnit.SECONDS);
                logger.error((Object)"Problems encountered while trying to shutdown Cache Management System. This would lead to problems! I recommend you to contact support.");
            }
        }
        catch (InterruptedException e) {
            logger.fatal((Object)"Cache Management Executor was interrupted while it was shutting down! This will cause a memory leak.");
        }
    }

    public void setUserCache(SerializableUserCache<U> userCache) {
        this.userCache = userCache;
    }

    public void setAuthCache(SerializableAuthCache<A> authCache) {
        this.authCache = authCache;
    }

    public void setCsrfCache(SerializableCsrfCache<C> csrfCache) {
        this.csrfCache = csrfCache;
    }
}

