/*
 * Decompiled with CFR 0.152.
 */
package net.itrixlabs.cache;

import net.itrixlabs.cache.auth.SerializableAuthCache;
import net.itrixlabs.cache.csrf.SerializableCsrfCache;
import net.itrixlabs.cache.user.SerializableUserCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerializableCacheManagementWorker<U, A, C>
implements Runnable {
    private static final Log logger = LogFactory.getLog(SerializableCacheManagementWorker.class);
    private SerializableUserCache<U> userCache;
    private SerializableAuthCache<A> authCache;
    private SerializableCsrfCache<C> csrfCache;

    SerializableCacheManagementWorker() {
    }

    @Override
    public void run() {
        logger.info((Object)"Commencing cache management task.");
        if (this.userCache != null) {
            this.userCache.flush();
        }
        if (this.authCache != null) {
            this.authCache.flush();
        }
        if (this.csrfCache != null) {
            this.csrfCache.flush();
        }
        logger.info((Object)"Cache management task completed.");
    }

    SerializableCacheManagementWorker<U, A, C> setUserCache(SerializableUserCache<U> userCache) {
        this.userCache = userCache;
        return this;
    }

    SerializableCacheManagementWorker<U, A, C> setAuthCache(SerializableAuthCache<A> authCache) {
        this.authCache = authCache;
        return this;
    }

    SerializableCacheManagementWorker<U, A, C> setCsrfCache(SerializableCsrfCache<C> csrfCache) {
        this.csrfCache = csrfCache;
        return this;
    }
}

