/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public class SnmpWalkToSnmpsimConvertor2 {
    static Pattern startPattern = Pattern.compile("^((\\.\\d+)+)\\.?.*");
    static Pattern oidPattern = Pattern.compile("^((\\.\\d+)+)\\.?\\s?");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Missing input parameters");
            System.out.println(" Example usage: /home/test/huawei.snmpwalout /usr/snmpsim/data/huawei.snmpwalk");
            return;
        }
        String inputFile = args[0];
        if (inputFile == null) {
            System.out.println("Missing input snmpwalk file");
            System.out.println(" Example usage: /home/test/huawei.snmpwalout /usr/snmpsim/data/huawei.snmpwalk");
            return;
        }
        String outputFile = args[1];
        if (inputFile == null) {
            System.out.println("Missing output snmpsim file");
            System.out.println(" Example usage: /home/test/huawei.snmpwalout /usr/snmpsim/data/huawei.snmpwalk");
            return;
        }
        File tmpFile = File.createTempFile("temp", ".snmpawalk");
        try {
            BufferedReader reader = null;
            PrintWriter printWriter = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(inputFile));
                printWriter = new PrintWriter(tmpFile);
                String lastLine = null;
                while ((line = reader.readLine()) != null) {
                    if (lastLine != null) {
                        if (!startPattern.matcher(line).matches()) {
                            printWriter.print(lastLine);
                        } else {
                            printWriter.println(lastLine);
                        }
                    }
                    lastLine = line;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            reader = null;
            printWriter = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(tmpFile));
                printWriter = new PrintWriter(new File(outputFile));
                while ((line = reader.readLine()) != null) {
                    if (oidPattern.matcher(line).matches()) {
                        printWriter.print(line);
                        continue;
                    }
                    printWriter.println(line);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        finally {
            tmpFile.delete();
        }
        System.out.println("Done! please review the converted file " + outputFile);
    }
}

