/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.IOException;
import java.util.Vector;
import net.itransformers.snmp2xml4j.snmptoolkit.Walk;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.DefaultMessageDispatcherFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.MessageDispatcherAbstractFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.TransportMappingAbstractFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.UdpTransportMappingFactory;
import org.apache.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpSet {
    static Logger logger = Logger.getLogger(Walk.class);
    String oid;
    String address;
    String community;
    String value;
    int retries;
    long timeout;
    int version;
    UdpAddress localAddress;
    TransportMappingAbstractFactory transportFactory;
    MessageDispatcherAbstractFactory messageDispatcherFactory;

    public SnmpSet(String oid, String address, int version, int retries, long timeout, String community, String value, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherAbstractFactory) throws IOException {
        this.oid = oid;
        this.address = address;
        this.version = version;
        this.timeout = timeout;
        this.retries = retries;
        this.community = community;
        this.transportFactory = transportFactory;
        this.messageDispatcherFactory = messageDispatcherAbstractFactory;
        this.localAddress = new UdpAddress("0.0.0.0/0");
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setSNMPValue() throws IOException {
        String result = "";
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        OctetString var = new OctetString(this.value);
        VariableBinding vb = new VariableBinding(new OID(this.oid), (Variable)var);
        Vector<VariableBinding> vbs = new Vector<VariableBinding>();
        vbs.add(vb);
        TransportMapping transport = this.transportFactory.createTransportMapping((TransportIpAddress)this.localAddress);
        MessageDispatcher dispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        Snmp snmp = new Snmp(dispatcher, transport);
        ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(new OctetString(MPv3.createLocalEngineID()).getValue());
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.community));
        target.setVersion(this.version);
        target.setAddress((Address)new UdpAddress(this.address));
        target.setRetries(this.retries);
        target.setTimeout(this.timeout);
        target.setMaxSizeRequestPDU(65535);
        snmp.listen();
        logger.debug((Object)("SNMP SET TO" + target + " with OID: " + this.oid + " and value: " + this.value));
        try {
            PDU request = new PDU();
            request.setType(-93);
            for (int i = 0; i < vbs.size(); ++i) {
                request.add((VariableBinding)vbs.get(i));
            }
            long startTime = System.currentTimeMillis();
            ResponseEvent responseEvent = snmp.set(request, (Target)target);
            PDU response = null;
            if (responseEvent != null) {
                response = responseEvent.getResponse();
                logger.debug((Object)("Received response after " + (System.currentTimeMillis() - startTime) + " millis"));
            }
            if (response == null) {
                throw new RuntimeException("SNMP response is null.");
            }
            for (int i = 0; i < response.size(); ++i) {
                VariableBinding vb1 = response.get(i);
                result = vb1.getVariable().toString();
            }
            logger.debug((Object)("Response value: " + result));
            String string = result;
            return string;
        }
        finally {
            snmp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSNMPOID(String oid, String address, int port, int version, int retries, long timeout, String community, String value) throws IOException {
        this.oid = oid;
        this.address = address + "/" + port;
        this.version = version;
        this.timeout = timeout;
        this.retries = retries;
        this.community = community;
        this.messageDispatcherFactory = new DefaultMessageDispatcherFactory();
        this.localAddress = new UdpAddress("0.0.0.0/0");
        this.value = value;
        String result = "";
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        OctetString var = new OctetString(value);
        VariableBinding vb = new VariableBinding(new OID(this.oid), (Variable)var);
        Vector<VariableBinding> vbs = new Vector<VariableBinding>();
        vbs.add(vb);
        TransportMapping transport = this.transportFactory.createTransportMapping((TransportIpAddress)this.localAddress);
        MessageDispatcher dispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        Snmp snmp = new Snmp(dispatcher, transport);
        ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(new OctetString(MPv3.createLocalEngineID()).getValue());
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.community));
        target.setVersion(version);
        target.setAddress((Address)new UdpAddress(this.address));
        target.setRetries(retries);
        target.setTimeout(timeout);
        target.setMaxSizeRequestPDU(65535);
        snmp.listen();
        logger.debug((Object)("SNMP SET TO" + target + " with OID: " + oid + " and value: " + value));
        try {
            PDU request = new PDU();
            request.setType(-93);
            for (int i = 0; i < vbs.size(); ++i) {
                request.add((VariableBinding)vbs.get(i));
            }
            long startTime = System.currentTimeMillis();
            ResponseEvent responseEvent = snmp.set(request, (Target)target);
            PDU response = null;
            if (responseEvent != null) {
                response = responseEvent.getResponse();
                logger.debug((Object)("Received response after " + (System.currentTimeMillis() - startTime) + " millis"));
            }
            if (response == null) {
                throw new RuntimeException("SNMP response is null.");
            }
            for (int i = 0; i < response.size(); ++i) {
                VariableBinding vb1 = response.get(i);
                result = vb1.getVariable().toString();
            }
            logger.debug((Object)("Response value: " + result));
            String string = result;
            return string;
        }
        finally {
            snmp.close();
        }
    }

    public static void main(String[] args) throws IOException {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        SnmpSet SetExampe = new SnmpSet(".1.3.6.1.2.1.1.4.0", "10.10.10.10/161", 0, 1, 200L, "publicw", "test123", new UdpTransportMappingFactory(), new DefaultMessageDispatcherFactory());
        SetExampe.setSNMPValue();
    }
}

