/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.Node;
import net.itransformers.snmp2xml4j.snmptoolkit.Walk;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.DefaultMessageDispatcherFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.UdpTransportMappingFactory;
import net.percederberg.mibble.MibLoaderException;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MainClass {
    public static void XML_parser(String input_file) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String discoveredNeighbors = "//DiscoveredDevice/object/object[objectType = 'Discovered Neighbor']/name";
        InputSource inputSource = new InputSource(input_file);
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpath.evaluate(discoveredNeighbors, inputSource, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            System.out.println(nodes.item(i).getTextContent());
        }
    }

    public static void main(String[] args) throws TransformerException, IOException, MibLoaderException {
        FileOutputStream outstream = new FileOutputStream("device.xml");
        Walk walker = new Walk(new File("snmptoolkit/mibs"), false, new UdpTransportMappingFactory(), new DefaultMessageDispatcherFactory());
        Properties parameters = new Properties();
        String[] includes = new String[]{"bgpPeerTable"};
        parameters.put("address", Arrays.asList("88.203.203.225/161"));
        parameters.put("c", Arrays.asList("test-r"));
        parameters.put("v", Arrays.asList("2c"));
        parameters.put("t", Arrays.asList(1000));
        parameters.put("r", Arrays.asList(1));
        parameters.put("Cr", Arrays.asList(65535));
        Node root = walker.walk(includes, parameters);
        String xml = Walk.printTreeAsXML(root);
        System.out.println(xml);
    }
}

