/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.util.ArrayList;
import net.itransformers.snmp2xml4j.snmptoolkit.Node;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import org.apache.log4j.Logger;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TableEvent;

public class SnmpXmlPrinter {
    protected Node node;
    static Logger logger = Logger.getLogger(SnmpXmlPrinter.class);
    protected MibLoader loader;

    public SnmpXmlPrinter(MibLoader loader, Node node) {
        this.loader = loader;
        this.node = node;
    }

    public String printTreeAsXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<root>\n");
        this.printTreeAsXML(this.node, "", sb, false);
        sb.append("</root>");
        logger.trace((Object)sb.toString());
        return sb.toString();
    }

    public String printTreeAsXML(boolean detailedInfoFlag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<root>\n");
        this.printTreeAsXML(this.node, "", sb, detailedInfoFlag);
        sb.append("</root>");
        logger.trace((Object)sb.toString());
        return sb.toString();
    }

    private void printTreeAsXML(Node node, String tabs, StringBuilder sb, boolean oidFlag) {
        SnmpObjectType symbolType;
        if (node == null) {
            return;
        }
        if (!node.isDoWalk()) {
            return;
        }
        ObjectIdentifierValue objectIdentifierValue = node.getObjectIdentifierValue();
        if (objectIdentifierValue == null) {
            return;
        }
        String tagName = objectIdentifierValue.getName();
        MibValueSymbol symbol = node.getObjectIdentifierValue().getSymbol();
        String syntaxString = "";
        String snmpSyntax = "";
        String accessString = "";
        String description = "";
        String units = "";
        if (null != symbol && symbol.getType() instanceof SnmpObjectType) {
            symbolType = (SnmpObjectType)symbol.getType();
            syntaxString = symbolType.getName();
            snmpSyntax = SnmpXmlPrinter.determineSyntaxType(symbolType.getSyntax());
            SnmpAccess access = symbolType.getAccess();
            accessString = access.toString();
            if (symbolType.getDescription() != null) {
                description = symbolType.getDescription().replaceAll("\\n", " ");
            }
            units = symbolType.getUnits();
        } else if (null != symbol && symbol.getType() instanceof ObjectIdentifierType) {
            symbolType = (ObjectIdentifierType)symbol.getType();
            syntaxString = symbolType.getName();
            snmpSyntax = SnmpXmlPrinter.determineSyntaxType((MibType)symbolType);
            accessString = "not-accessible";
            description = "";
        }
        if (node.getChildren() == null) {
            return;
        }
        if (node.getChildren().size() == 0) {
            String vb;
            VariableBinding vb1 = node.getVb();
            if (vb1 == null) {
                return;
            }
            Variable variable = vb1.getVariable();
            String string = vb = variable != null ? SnmpXmlPrinter.escapeForXML(variable.toString()) : "";
            if (oidFlag) {
                sb.append(String.format("\t%s<%s oid=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" access=\"%s\" units=\"%s\">", tabs, tagName, objectIdentifierValue, syntaxString, snmpSyntax, accessString, units));
                sb.append(String.format("\n\t\t%s<description><![CDATA[%s]]></description>", tabs, description));
                sb.append(String.format("\n\t\t%s<value>%s</value>", tabs, vb));
                sb.append(String.format("\n\t%s</%s>", tabs, tagName));
            } else {
                sb.append(String.format("\t%s<%s>%s</%s>", tabs, tagName, vb, tagName));
            }
            sb.append('\n');
            logger.trace((Object)sb.toString());
        } else if (node.getTable() != null) {
            this.printNodeTableAsXML(node, tabs, sb, oidFlag);
            logger.trace((Object)sb.toString());
        } else {
            StringBuilder sb1 = new StringBuilder();
            for (Node child : node.getChildren()) {
                this.printTreeAsXML(child, tabs + "\t", sb1, oidFlag);
            }
            if (oidFlag) {
                sb.append(String.format("%s<%s oid=\"%s\">", tabs, tagName, objectIdentifierValue));
            } else {
                sb.append(String.format("%s<%s>", tabs, tagName));
            }
            sb.append('\n');
            sb.append((CharSequence)sb1);
            sb.append(String.format("%s</%s>", tabs, tagName));
            sb.append('\n');
        }
    }

    static String escapeForXML(String s) {
        String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
        return s.replaceAll(xml10pattern, "").replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\u001c", "").replaceAll("\f", "").replaceAll("\u001a", "");
    }

    private void printNodeTableAsXML(Node node, String tabs, StringBuilder sb, boolean oidFlag) {
        String tagName = node.getObjectIdentifierValue().getName();
        int i = 0;
        for (TableEvent tableEvent : node.getTable()) {
            StringBuilder sbTable = new StringBuilder();
            StringBuilder sbIndex = new StringBuilder();
            StringBuilder sbRows = new StringBuilder();
            this.printTableIndexAsXML(node, tabs, sbIndex, tableEvent.getIndex(), ++i, oidFlag);
            SnmpXmlPrinter.printTableRowsAsXML(node, tabs, sbRows, tableEvent.getColumns(), oidFlag);
            MibValueSymbol symbol = node.getObjectIdentifierValue().getSymbol();
            SnmpObjectType symbolType = (SnmpObjectType)symbol.getType();
            MibType syntax = symbolType.getSyntax();
            String syntaxString = syntax.getName();
            String snmpSyntax = SnmpXmlPrinter.determineSyntaxType(syntax);
            SnmpAccess access = symbolType.getAccess();
            String accessString = access.toString();
            String description = symbolType.getDescription().replaceAll("\\n", " ");
            String units = symbolType.getUnits();
            if (oidFlag) {
                sbTable.append(String.format("%s<%s oid=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" access=\"%s\" units=\"%s\">", tabs, tagName, node.getObjectIdentifierValue(), syntaxString, snmpSyntax, accessString, units));
                sbTable.append(String.format("\n\t%s<description><![CDATA[%s]]></description>", tabs, description));
            } else {
                sbTable.append(String.format("%s<%s>", tabs, tagName));
            }
            sbTable.append('\n');
            sbTable.append((CharSequence)sbIndex);
            sbTable.append((CharSequence)sbRows);
            sbTable.append(String.format("\n%s</%s>", tabs, tagName));
            sbTable.append('\n');
            sb.append((CharSequence)sbTable);
        }
    }

    private static void printTableRowsAsXML(Node node, String tabs, StringBuilder sb4, VariableBinding[] cols, boolean oidFlag) {
        if (cols == null) {
            return;
        }
        for (VariableBinding vb : cols) {
            Variable variable;
            ObjectIdentifierValue objectIdentifierValue;
            if (vb == null) continue;
            String childTagName = null;
            for (Node child : node.getChildren()) {
                objectIdentifierValue = child.getObjectIdentifierValue();
                if (objectIdentifierValue == null) continue;
                try {
                    if (vb.getOid() == null || !vb.getOid().startsWith(new OID(objectIdentifierValue.toString()))) continue;
                    childTagName = objectIdentifierValue.getName();
                }
                catch (RuntimeException rte) {
                    logger.error((Object)rte.getMessage(), (Throwable)rte);
                }
            }
            if (childTagName == null || (variable = vb.getVariable()) == null) continue;
            String var = SnmpXmlPrinter.escapeForXML(variable.toString());
            if (oidFlag) {
                objectIdentifierValue = node.getObjectIdentifierValue();
                MibValueSymbol mibValueSymbol = objectIdentifierValue.getSymbol();
                if (mibValueSymbol == null) {
                    return;
                }
                ObjectIdentifierValue childByName = objectIdentifierValue.getChildByName(childTagName);
                MibValueSymbol symbol = childByName.getSymbol();
                SnmpObjectType symbolType = (SnmpObjectType)symbol.getType();
                MibType syntax = symbolType.getSyntax();
                String syntaxString = syntax.getName();
                String snmpSyntax = SnmpXmlPrinter.determineSyntaxType(syntax);
                SnmpAccess access = symbolType.getAccess();
                String description = symbolType.getDescription().replaceAll("\\n", " ");
                String accessString = access.toString();
                String units = symbolType.getUnits();
                sb4.append(String.format("\t%s<%s oid=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" access=\"%s\" units=\"%s\">", tabs, childTagName, vb.getOid(), syntaxString, snmpSyntax, accessString, units));
                sb4.append(String.format("\n\t\t%s<description><![CDATA[%s]]></description>", tabs, description));
                sb4.append(String.format("\n\t\t%s<value>%s</value>", tabs, var));
                sb4.append(String.format("\n\t%s</%s>", tabs, childTagName));
                continue;
            }
            sb4.append(String.format("\n\t%s<%s>%s</%s>", tabs, childTagName, var, childTagName));
        }
    }

    private void printTableIndexAsXML(Node node, String tabs, StringBuilder sb, OID indexOID, int instanceIndex, boolean oidFlag) {
        if (node == null) {
            return;
        }
        ObjectIdentifierValue objectIdentifierValue = node.getObjectIdentifierValue();
        if (objectIdentifierValue == null) {
            return;
        }
        MibValueSymbol mibValueSymbol = objectIdentifierValue.getSymbol();
        if (mibValueSymbol == null) {
            return;
        }
        SnmpObjectType snmpObjectType = (SnmpObjectType)mibValueSymbol.getType();
        if (snmpObjectType == null) {
            return;
        }
        ArrayList indexes = snmpObjectType.getIndex();
        if (indexOID != null) {
            StringBuilder instance = new StringBuilder();
            StringBuilder instanceValues = new StringBuilder();
            if (indexes != null && indexes.size() > 0) {
                int pos = 0;
                for (int i = 0; i < indexes.size(); ++i) {
                    try {
                        SnmpAccess access;
                        MibType syntax;
                        SnmpIndex index = (SnmpIndex)indexes.get(i);
                        String indexName = index.getValue().getName();
                        ObjectIdentifierValue childByName = objectIdentifierValue.getChildByName(indexName);
                        String syntaxString = "UNKNOWN";
                        String accessString = "UNKNOWN";
                        String snmpSyntax = "UNKNOWN";
                        if (childByName != null) {
                            MibValueSymbol symbol = childByName.getSymbol();
                            SnmpObjectType indexType = (SnmpObjectType)symbol.getType();
                            syntax = indexType.getSyntax();
                            syntaxString = syntax.getName();
                            access = indexType.getAccess();
                            accessString = access.toString();
                            String indexVal = new OID(indexOID.getValue(), pos, 1).toString();
                            snmpSyntax = SnmpXmlPrinter.determineSyntaxType(syntax);
                            boolean posIncremented = false;
                            if (syntax instanceof StringType && syntaxString.equals("OCTET STRING")) {
                                Constraint constraint = ((StringType)syntax).getConstraint();
                                if (constraint instanceof SizeConstraint) {
                                    ArrayList list = ((SizeConstraint)constraint).getValues();
                                    if (list.size() == 1) {
                                        Constraint constraint1 = (Constraint)list.get(0);
                                        if (constraint1 instanceof ValueConstraint) {
                                            MibValue val = ((ValueConstraint)constraint1).getValue();
                                            if (val instanceof NumberValue) {
                                                NumberValue numVal = (NumberValue)val;
                                                Number number = (Number)numVal.toObject();
                                                int size = number.intValue();
                                                indexVal = new OID(indexOID.getValue(), pos, size).toString();
                                                pos += size;
                                                posIncremented = true;
                                            }
                                        } else {
                                            indexVal = constraint1 instanceof ValueRangeConstraint ? OctetString.fromString((String)new OID(indexOID.getValue(), i + 1, indexOID.getValue().length - (i + 1)).toString(), (char)'.', (int)10).toString() : new OID(indexOID.getValue()).toString();
                                        }
                                    } else {
                                        indexVal = new OID(indexOID.getValue()).toString();
                                    }
                                } else {
                                    indexVal = new OID(indexOID.getValue()).toString();
                                }
                            }
                            if (oidFlag) {
                                sb.append(String.format("\t%s<index name=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" oid=\"%s\" access=\"%s\">%s</index>\n", tabs, indexName, syntaxString, snmpSyntax, index, accessString, SnmpXmlPrinter.escapeForXML(indexVal)));
                            } else {
                                sb.append(String.format("\t%s<index name=\"%s\">%s</index>\n", tabs, indexName, SnmpXmlPrinter.escapeForXML(indexVal)));
                            }
                            if (i != indexes.size() - 1) {
                                instance.append(indexName + "");
                                instanceValues.append(indexVal).append("");
                            } else {
                                instance.append(indexName);
                                instanceValues.append(indexVal);
                            }
                            if (posIncremented) continue;
                            ++pos;
                            continue;
                        }
                        MibValueSymbol symbol11 = this.findSymbolFromMibs(indexName);
                        if (symbol11 != null) {
                            syntax = symbol11.getType();
                            access = ((SnmpObjectType)syntax).getAccess();
                            accessString = access.toString();
                            syntaxString = ((SnmpObjectType)syntax).getSyntax().getName();
                            snmpSyntax = SnmpXmlPrinter.determineSyntaxType(((SnmpObjectType)syntax).getSyntax());
                        }
                        OID indexVal = new OID(indexOID.getValue(), pos, 1);
                        if (oidFlag) {
                            sb.append(String.format("\t%s<index name=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" oid=\"%s\" access=\"%s\">%s</index>\n", tabs, indexName, syntaxString, snmpSyntax, index, accessString, SnmpXmlPrinter.escapeForXML(indexVal.toString())));
                        } else {
                            sb.append(String.format("\t%s<index name=\"%s\">%s</index>\n", tabs, indexName, SnmpXmlPrinter.escapeForXML(indexVal.toString())));
                        }
                        if (i != indexes.size() - 1) {
                            instance.append(indexName).append("");
                            instanceValues.append(indexVal).append("");
                            continue;
                        }
                        instance.append(indexName).append(".");
                        instanceValues.append(indexVal).append(".");
                        continue;
                    }
                    catch (RuntimeException e) {
                        logger.trace((Object)sb.toString());
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            sb.append(String.format("\t%s<instance instanceIndex=\"%s\" instanceName=\"%s\" instanceValue=\"%s\">%s</instance>\n", tabs, instanceIndex, instance.toString(), SnmpXmlPrinter.escapeForXML(instanceValues.toString()), SnmpXmlPrinter.escapeForXML(indexOID.toString())));
        }
    }

    private static String determineSyntaxType(MibType syntax) {
        if (syntax.getTag() != null) {
            if (syntax.getTag().getCategory() == 1) {
                return syntax.getReferenceSymbol().getName();
            }
            if (syntax.getTag().getCategory() == 0) {
                return syntax.getName();
            }
            if (syntax.getTag().getCategory() == 2) {
                return syntax.getName();
            }
            return syntax.getName();
        }
        return syntax.getName();
    }

    private MibValueSymbol findSymbolFromMibs(String oidName) {
        Mib[] mibs = this.loader.getAllMibs();
        MibValueSymbol symbol11 = null;
        for (Mib mib : mibs) {
            symbol11 = (MibValueSymbol)mib.findSymbol(oidName, true);
            if (symbol11 == null) continue;
            return symbol11;
        }
        return null;
    }
}

