/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.IOException;
import java.util.Map;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpManager;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.DefaultMessageDispatcherFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.TcpTransportMappingFactory;
import net.percederberg.mibble.MibLoader;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TransportIpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpTcpV1Manager
extends SnmpManager {
    protected String snmpCommunity;
    protected TcpAddress tcpAddress;

    public SnmpTcpV1Manager(MibLoader loader, String ipAddress, String snmpCommunity, int retries, int timeout, int maxSizeRequestPDU, int maxRepetitions, int destinationPort) throws IOException {
        super(loader, retries, timeout, maxSizeRequestPDU, maxRepetitions, new TcpTransportMappingFactory(), (TransportIpAddress)new TcpAddress("0.0.0.0/0"));
        this.snmpCommunity = snmpCommunity;
        this.tcpAddress = new TcpAddress(ipAddress + "/" + destinationPort);
    }

    public SnmpTcpV1Manager(MibLoader loader) {
        super(loader, new TcpTransportMappingFactory(), new DefaultMessageDispatcherFactory(), (TransportIpAddress)new TcpAddress("0.0.0.0/0"));
    }

    @Override
    protected void doInit() throws IOException {
    }

    @Override
    protected void doSetParameters(Map<String, String> conParams) {
        int destinationPort = super.convertStringToIntParam("destinationPort", conParams.get("destinationPort"), 161);
        this.tcpAddress = new TcpAddress(conParams.get("ipAddress") + "/" + destinationPort);
        this.snmpCommunity = conParams.get("snmpCommunity");
    }

    @Override
    protected Target getTarget() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.snmpCommunity));
        target.setAddress((Address)this.tcpAddress);
        target.setRetries(this.retries);
        target.setTimeout((long)this.timeout);
        target.setVersion(0);
        return target;
    }

    @Override
    protected PDU createPDU() {
        return new PDU();
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public TcpAddress getTcpAddress() {
        return this.tcpAddress;
    }

    public void setTcpAddress(TcpAddress tcpAddress) {
        this.tcpAddress = tcpAddress;
    }
}

