/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.service.mail.transport.javamail;

import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.israfil.service.mail.api.MailHeader;
import net.israfil.service.mail.api.MailMessage;
import net.israfil.service.mail.api.MailMessageBody;
import net.israfil.service.mail.api.smtp.PlaintextMessageBody;
import net.israfil.service.mail.api.smtp.SMTPHeaderType;
import net.israfil.service.mail.api.smtp.SMTPHeaderTypes;
import net.israfil.service.mail.api.smtp.SMTPMessage;
import net.israfil.service.mail.api.smtp.SMTPTransport;
import net.israfil.service.mail.transport.javamail.ContentAdapter;

public class JavaMailTransport
extends SMTPTransport {
    private final Session session;

    public JavaMailTransport(Session session) {
        this.session = session;
    }

    public boolean send(MailMessage message) {
        if (!message.getType().equals("smtp")) {
            throw new IllegalArgumentException("Cannot send a non SMTP message to an SMTP transport");
        }
        SMTPMessage smtpMessage = (SMTPMessage)message;
        MimeMessage m = this.createMimeMessage(smtpMessage);
        try {
            Transport.send((Message)m);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Cannot connect to message transport service.", e);
        }
        return false;
    }

    MimeMessage createMimeMessage(SMTPMessage smtpMessage) {
        MimeMessage m = new MimeMessage(this.session);
        for (final MailHeader header : smtpMessage.getHeaders().values()) {
            try {
                Object type = null;
                try {
                    type = SMTPHeaderTypes.valueOfCanonicalString((String)header.getName());
                }
                catch (IllegalArgumentException e) {
                    type = new SMTPHeaderType(){

                        public boolean isSingleton() {
                            return false;
                        }

                        public String getCanonicalRepresentation() {
                            return header.getName();
                        }
                    };
                }
                if (type.isSingleton()) {
                    m.setHeader(type.getCanonicalRepresentation(), MimeUtility.decodeText((String)header.getStringRepresentation()));
                    continue;
                }
                m.addHeader(type.getCanonicalRepresentation(), MimeUtility.decodeText((String)header.getStringRepresentation()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Default coding invalid", e);
            }
            catch (MessagingException e) {
                throw new IllegalArgumentException("Error converting header to RFC 2047 compliance.", e);
            }
        }
        try {
            m.setDataHandler(JavaMailTransport.getContentAdapter(smtpMessage.getBody()).adapt(smtpMessage.getBody()));
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException("Error setting message body.", e);
        }
        return m;
    }

    public static ContentAdapter getContentAdapter(MailMessageBody body) {
        if (PlaintextMessageBody.class.equals(body.getClass())) {
            return new ContentAdapter(){

                public DataHandler adapt(MailMessageBody body) {
                    DataHandler dh = new DataHandler((Object)new String(body.getBytes("ASCII")), body.getContentType());
                    return dh;
                }
            };
        }
        throw new IllegalArgumentException("Unsupported message body type: " + body.getClass());
    }
}

