/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.service.mail.api.smtp;

import java.util.Collection;
import net.israfil.service.mail.api.MailHeader;
import net.israfil.service.mail.api.smtp.SMTPAddress;
import net.israfil.service.mail.api.smtp.SMTPHeaderTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMTPUtils {
    public static String assertASCII(String string) {
        int length;
        if (string == null || (length = string.length()) == 0) {
            return string;
        }
        char[] chars = new char[length];
        string.getChars(0, length - 1, chars, 0);
        for (int i = 0; i < length; ++i) {
            if (chars[i] <= '\u007f') continue;
            throw new IllegalArgumentException("String contains non-ASCII characters: " + string);
        }
        return string;
    }

    public static String getLocal(String address) {
        if (address == null) {
            throw new IllegalArgumentException("SMTP must be constructed with at least a local address.");
        }
        if (!address.contains("@")) {
            return address;
        }
        String local = address.split("@")[0];
        return local == null || local.equals("") ? null : local;
    }

    public static String getDomain(String address) {
        if (address == null) {
            throw new IllegalArgumentException("SMTP must be constructed with at least a local address.");
        }
        if (!address.contains("@")) {
            return null;
        }
        String[] parts = address.split("@");
        return parts.length > 1 ? parts[1] : null;
    }

    public static void validateSpecialHeader(SMTPHeaderTypes type, MailHeader<?> header) {
        if (type == null) {
            return;
        }
        if (header == null) {
            throw new IllegalArgumentException("Error attempting to set a null value as a header object.");
        }
        switch (type) {
            case Bcc: 
            case To: 
            case Cc: {
                try {
                    Collection contents = (Collection)header.getContent();
                    for (SMTPAddress address : contents) {
                    }
                    break;
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("Header " + type + " does not contain a valid collection of SMTPAddress instances");
                }
            }
            case Subject: {
                try {
                    String contents = (String)header.getContent();
                    break;
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("Header " + type + " does not contain a valid collection of SMTPAddress instances");
                }
            }
            case From: {
                try {
                    SMTPAddress contents = (SMTPAddress)header.getContent();
                    break;
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("Header " + type + " does not contain a valid collection of SMTPAddress instances");
                }
            }
        }
    }
}

