/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.service.mail.api.smtp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.israfil.service.mail.api.MailAddress;
import net.israfil.service.mail.api.MailHeader;
import net.israfil.service.mail.api.MailMessage;
import net.israfil.service.mail.api.MailMessageBody;
import net.israfil.service.mail.api.smtp.PlaintextMessageBody;
import net.israfil.service.mail.api.smtp.SMTPAddress;
import net.israfil.service.mail.api.smtp.SMTPHeaderType;
import net.israfil.service.mail.api.smtp.SMTPHeaderTypes;
import net.israfil.service.mail.api.smtp.SMTPUtils;
import net.israfil.service.mail.api.smtp.header.AbstractSMTPHeader;
import net.israfil.service.mail.api.smtp.header.SMTPAddressHeader;
import net.israfil.service.mail.api.smtp.header.SMTPAddressesHeader;
import net.israfil.service.mail.api.smtp.header.SMTPStringHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPMessage
implements MailMessage {
    private final Map<String, MailHeader<?>> headers = new HashMap();
    private MailMessageBody body;

    public SMTPMessage() {
        this(null, null);
    }

    protected SMTPMessage(Collection<AbstractSMTPHeader<?>> headers) {
        this(headers, null);
    }

    protected SMTPMessage(Collection<AbstractSMTPHeader<?>> headers, MailMessageBody body) {
        if (headers != null) {
            this.addHeaders(headers);
        }
        this.setBody(body);
    }

    private Object getHeaderValue(String name, Map<String, MailHeader<?>> headers) {
        MailHeader<?> h = headers.get(name);
        if (h == null) {
            return null;
        }
        return h.getContent();
    }

    public void addAddress(SMTPHeaderTypes type, SMTPAddress ... addresses) {
        switch (type) {
            case From: {
                throw new IllegalArgumentException("You may not set the From: header from the addAddress method - use setFromAddress() instead.");
            }
            case Subject: {
                throw new IllegalArgumentException("You may not set the Subject: header from the addAddress method - use setSubject() instead.");
            }
            case To: 
            case Bcc: 
            case Cc: {
                SMTPAddressesHeader header = (SMTPAddressesHeader)this.headers.get(type.getCanonicalRepresentation());
                if (header == null) {
                    header = new SMTPAddressesHeader(type.getCanonicalRepresentation(), (Collection<SMTPAddress>)new ArrayList<SMTPAddress>());
                    this.headers.put(type.getCanonicalRepresentation(), header);
                }
                Collection _addresses = (Collection)header.getContent();
                for (SMTPAddress address : addresses) {
                    _addresses.add(address);
                }
                break;
            }
        }
    }

    public void clearAddresses(SMTPHeaderType type) {
        this.headers.put(type.getCanonicalRepresentation(), new SMTPAddressesHeader(type.getCanonicalRepresentation(), (Collection<SMTPAddress>)new ArrayList<SMTPAddress>()));
    }

    @Override
    public Collection<MailAddress> getBccAddresses() {
        return (Collection)this.getHeaderValue(SMTPHeaderTypes.Bcc.getCanonicalRepresentation(), this.headers);
    }

    @Override
    public Collection<MailAddress> getToAddresses() {
        return (Collection)this.getHeaderValue(SMTPHeaderTypes.To.getCanonicalRepresentation(), this.headers);
    }

    @Override
    public Collection<MailAddress> getCcAddresses() {
        return (Collection)this.getHeaderValue(SMTPHeaderTypes.Cc.getCanonicalRepresentation(), this.headers);
    }

    @Override
    public MailMessageBody getBody() {
        return this.body;
    }

    public void setBody(MailMessageBody body) {
        this.body = body == null ? new PlaintextMessageBody() : body;
    }

    @Override
    public MailAddress getFromAddress() {
        return (SMTPAddress)this.getHeaderValue(SMTPHeaderTypes.From.getCanonicalRepresentation(), this.headers);
    }

    public void setFromAddress(SMTPAddress address) {
        this.headers.put(SMTPHeaderTypes.From.getCanonicalRepresentation(), new SMTPAddressHeader(SMTPHeaderTypes.From.getCanonicalRepresentation(), address));
    }

    @Override
    public String getSubject() {
        return (String)this.getHeaderValue(SMTPHeaderTypes.Subject.getCanonicalRepresentation(), this.headers);
    }

    public void setSubject(String subject) {
        this.headers.put(SMTPHeaderTypes.Subject.getCanonicalRepresentation(), new SMTPStringHeader(SMTPHeaderTypes.Subject.getCanonicalRepresentation(), subject));
    }

    @Override
    public Map<String, MailHeader<?>> getHeaders() {
        return new HashMap(this.headers);
    }

    public void addHeader(AbstractSMTPHeader<?> ... headers) {
        this.addHeaders(Arrays.asList(headers));
    }

    public void addHeaders(Collection<AbstractSMTPHeader<?>> headers) {
        for (AbstractSMTPHeader<?> header : headers) {
            SMTPHeaderTypes type = null;
            try {
                type = SMTPHeaderTypes.valueOfCanonicalString(header.getName());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            SMTPUtils.validateSpecialHeader(type, header);
            this.headers.put(header.getName(), header);
        }
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public MailHeader<?> removeHeader(String name) {
        return this.headers.remove(name);
    }

    public MailHeader<?> getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public String getType() {
        return "smtp";
    }
}

