/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.service.mail.api.smtp;

import net.israfil.service.mail.api.MailAddress;
import net.israfil.service.mail.api.smtp.SMTPUtils;

public class SMTPAddress
implements MailAddress {
    private final String displayName;
    private final String local;
    private final String domain;

    public SMTPAddress(String address) {
        this(null, address);
    }

    public SMTPAddress(String displayName, String address) {
        this(displayName, SMTPUtils.getLocal(address), SMTPUtils.getDomain(address));
    }

    public SMTPAddress(String displayName, String local, String domain) {
        String string = this.displayName = displayName == null || "".equals(displayName) ? null : SMTPUtils.assertASCII(displayName);
        if (local == null || "".equals(local)) {
            throw new IllegalArgumentException("SMTP must be constructed with at least a local address.");
        }
        this.local = SMTPUtils.assertASCII(local);
        this.domain = domain == null || "".equals(domain) ? null : SMTPUtils.assertASCII(domain);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAddress() {
        if (this.domain == null) {
            return this.local;
        }
        return String.format("%s@%s", this.local, this.domain);
    }

    public String getCanonicalAddress() {
        if (this.displayName == null) {
            if (this.domain == null) {
                return String.format("<%s>", this.local);
            }
            return String.format("<%s@%s>", this.local, this.domain);
        }
        if (this.domain == null) {
            return String.format("\"%s\" <%s>", this.displayName, this.local);
        }
        return String.format("\"%s\" <%s@%s>", this.displayName, this.local, this.domain);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getCanonicalAddress());
    }

    public String getType() {
        return "smtp";
    }
}

