/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.service.mail.api.smtp;

import java.io.UnsupportedEncodingException;
import net.israfil.service.mail.api.MailMessageBody;
import net.israfil.service.mail.api.smtp.SMTPUtils;

public class PlaintextMessageBody
implements MailMessageBody {
    private String content;

    public PlaintextMessageBody() {
        this("");
    }

    public PlaintextMessageBody(String content) {
        this.setContent(content);
    }

    public String getContentType() {
        return "text/plain";
    }

    public byte[] getBytes(String charset) {
        try {
            return this.content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid character set: " + charset, e);
        }
    }

    public void setContent(String newContent) {
        if (newContent == null) {
            this.content = "";
        }
        this.content = SMTPUtils.assertASCII(newContent);
    }

    public String getType() {
        return "smtp";
    }
}

