package net.israfil.service.mail.api.smtp.header;

import java.util.Collection;

import net.israfil.service.mail.api.smtp.SMTPAddress;


public class SMTPAddressesHeader extends AbstractSMTPHeader<Collection<SMTPAddress>> {
	
	public SMTPAddressesHeader(String name, Collection<SMTPAddress> content) {
		super(name,content);
	}

	public String getStringRepresentation() {
		Collection<SMTPAddress> addresses = this.getContent();
		StringBuffer sb = new StringBuffer();
		boolean first = true;
		for (SMTPAddress address : addresses) {
			if (!first) sb.append(", ");
			else first = false;
			sb.append(address.getCanonicalAddress());
		}
		return sb.toString();
	}

}

