package net.israfil.service.mail.api.smtp.header;

import net.israfil.service.mail.api.AbstractMailHeader;
import net.israfil.service.mail.api.smtp.SMTPTransport;


public abstract class AbstractSMTPHeader<T> 
	extends AbstractMailHeader<T> {
	
	public AbstractSMTPHeader(String name, T content) {
		super(name,content);
	}

	public String getType() { return SMTPTransport.TRANSPORT_TYPE; }

	@Override
	public String toString() {
		return String.format("%s[%s=%s]",this.getClass().getSimpleName(),getName(),getContent());
	}
}

