/**
 * 
 */
package net.israfil.service.mail.api.smtp;

public enum SMTPHeaderTypes implements SMTPHeaderType {
	Cc(true, "Cc"), 
	Bcc(true, "Bcc"), 
	To(true, "To"), 
	Subject(true, "Subject"), 
	From(true, "From"),
	ReplyTo(true, "Reply-to");
	
	private final boolean singleton;
	private final String canonical;
	
	private SMTPHeaderTypes(boolean singleton, String canonical) {
		this.singleton = singleton;
		this.canonical = canonical;
	}
	
	public boolean isSingleton() { return singleton; }
	
	public String getCanonicalRepresentation() { return canonical; }
	
	public static SMTPHeaderTypes valueOfCanonicalString(String canonical) {
		for (SMTPHeaderTypes h : SMTPHeaderTypes.values()) {
			if (h.canonical.equals(canonical)) return h;
		}
        throw new IllegalArgumentException( "No SMTPHeaderType with canonical rendering " + canonical + " can be found.");
	}
}