package net.israfil.service.mail.api.smtp;

import java.io.UnsupportedEncodingException;

import net.israfil.service.mail.api.MailMessageBody;

/**
 * An ASCII plaintext message body.
 * 
 * @author cgruber
 *
 */
public class PlaintextMessageBody implements MailMessageBody {

	private String content;
	
	public PlaintextMessageBody() {
		this("");
	}
	
	public PlaintextMessageBody(String content) {
		setContent(content);
	}
	
	public String getContentType() {
		return "text/plain";
	}
	
	public byte[] getBytes(String charset) {
		try {
			return content.getBytes(charset);
		} catch (UnsupportedEncodingException e) {
			throw new IllegalArgumentException("Invalid character set: " + charset, e);
		}
	}

	/** 
	 * Sets the context of this message body, returning itself to
	 * the caller so it can be 
	 * @param newContent
	 * @return
	 */
	public void setContent(String newContent) {
		if (newContent == null) this.content = "";
		this.content = SMTPUtils.assertASCII(newContent);
	}

	public String getType() {
		return SMTPTransport.TRANSPORT_TYPE;
	}		

}
