package net.israfil.service.mail;


import net.israfil.service.mail.api.MailMessage;
import net.israfil.service.mail.api.MailTransport;

/**
 * Class for sending e-mail messages based on Velocity templates
 * or with attachments.
 * 
 * @author Matt Raible
 */
public class MailEngineImpl implements MailService {
   	
	private final MailTransport transport;
    
	
    public MailEngineImpl(
    		MailTransport transport
    ) {
    	this.transport = transport;
    }


    /**
     * Send a simple message with pre-populated values.
     * @param msg the message to send
     * @throws org.springframework.mail.MailException when SMTP server is down
     */
    public boolean send(MailMessage message) {
    	return transport.send(message);
    }


}
