/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.micro.util;

import java.io.PrintStream;

public class CausedRuntimeException
extends RuntimeException {
    private final Throwable cause;

    public CausedRuntimeException() {
        this.cause = null;
    }

    public CausedRuntimeException(Throwable t) {
        this.cause = t;
    }

    public CausedRuntimeException(String message) {
        super(message);
        this.cause = null;
    }

    public CausedRuntimeException(String message, Throwable t) {
        super(message);
        this.cause = t;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this);
            StackTraceElement[] elements = this.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                s.println("\tat " + elements[i]);
            }
            CausedRuntimeException.tryToPrintUnderlyingCause(this, s);
        }
    }

    protected static void tryToPrintUnderlyingCause(Throwable t, PrintStream ps) {
        try {
            CausedRuntimeException cre = (CausedRuntimeException)t;
            Throwable deeperCause = cre.getCause();
            if (deeperCause != null) {
                CausedRuntimeException.printCauseStackTrace(cre, deeperCause, ps);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected static void printCauseStackTrace(CausedRuntimeException original, Throwable cause, PrintStream ps) {
        int traceLength;
        StackTraceElement[] trace = original.getStackTrace();
        StackTraceElement[] causedTrace = cause.getStackTrace();
        int causeTraceLength = causedTrace.length - 1;
        for (traceLength = trace.length - 1; traceLength >= 0 && causeTraceLength >= 0 && trace[traceLength].equals(causedTrace[causeTraceLength]); --traceLength, --causeTraceLength) {
        }
        int commonFrames = trace.length - traceLength - 1;
        ps.println("Caused by: " + cause);
        for (int i = 0; i <= traceLength; ++i) {
            ps.println("\tat " + trace[i]);
        }
        if (commonFrames != 0) {
            ps.println("\t... " + commonFrames + " more");
        }
        CausedRuntimeException.tryToPrintUnderlyingCause(cause, ps);
    }
}

