/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.micro.container;

import java.util.Enumeration;
import java.util.Hashtable;
import net.israfil.micro.container.AbstractContainer;
import net.israfil.micro.container.AutoWiringAdaptableContainer;
import net.israfil.micro.container.AutoWiringAdapter;
import net.israfil.micro.container.Container;
import net.israfil.micro.container.adapters.IndependentAutoWiringAdapter;
import net.israfil.micro.container.error.ComponentAlreadyRegisteredError;
import net.israfil.micro.container.error.CouldNotCreateComponentError;
import net.israfil.micro.container.error.UnsatisfiedDependencyError;
import net.israfil.micro.container.util.CyclicalReferenceDetectionUtil;
import net.israfil.micro.container.util.NonDuplicateStack;

public class DefaultAutoWiringAdaptableContainer
extends AbstractContainer
implements AutoWiringAdaptableContainer {
    private Hashtable registry = new Hashtable();
    private final boolean failEarly;
    private boolean starting = false;
    private final Object CREATION_MUTEX = new Object();

    public DefaultAutoWiringAdaptableContainer() {
        this.failEarly = false;
    }

    public DefaultAutoWiringAdaptableContainer(boolean failEarly) {
        this.failEarly = failEarly;
    }

    public DefaultAutoWiringAdaptableContainer(Container parent) {
        super(parent);
        this.failEarly = false;
    }

    public DefaultAutoWiringAdaptableContainer(Container parent, boolean failEarly) {
        super(parent);
        this.failEarly = failEarly;
    }

    public synchronized void start() {
        if (this.isRunning() || this.starting) {
            return;
        }
        if (this.getParent() != null && !this.getParent().isRunning()) {
            throw new RuntimeException("Parent container is not started.");
        }
        this.starting = true;
        if (this.failEarly) {
            Enumeration i = this.registry.keys();
            while (i.hasMoreElements()) {
                this.getComponent(i.nextElement());
            }
        }
        super.start();
    }

    public void registerType(Object key, Class componentType) {
        this.registerType(key, new IndependentAutoWiringAdapter(componentType));
    }

    public void registerType(Object key, AutoWiringAdapter componentAdapter) {
        if (this.isRunning()) {
            throw new RuntimeException("Cannot register when container is started.");
        }
        if (this.registry.containsKey(key)) {
            throw new ComponentAlreadyRegisteredError("Component already registered for " + key);
        }
        this.detectCircularDependencies(key, componentAdapter);
        this.registry.put(key, componentAdapter);
    }

    private void detectCircularDependencies(Object key, AutoWiringAdapter componentAdapter) {
        NonDuplicateStack nds = new NonDuplicateStack();
        nds.push(key);
        CyclicalReferenceDetectionUtil.detectCircularDependencies(this.registry, nds, componentAdapter);
    }

    private Object wireObject(Object originalKey, AutoWiringAdapter adapter) {
        Hashtable<Object, Object> parameters = new Hashtable<Object, Object>(adapter.dependencies().length);
        Object[] dependencies = adapter.dependencies();
        for (int depn = 0; depn < adapter.dependencies().length; ++depn) {
            Object key = adapter.dependencies()[depn];
            Object parameter = this.getComponent(key);
            if (parameter == null) {
                throw new UnsatisfiedDependencyError("Could not materialize dependency for key " + key);
            }
            parameters.put(key, parameter);
        }
        try {
            return adapter.create(parameters);
        }
        catch (IllegalAccessException e) {
            throw new CouldNotCreateComponentError("Could not create component " + originalKey + " of type " + adapter.getType(), e);
        }
        catch (InstantiationException e) {
            throw new CouldNotCreateComponentError("Could not create component " + originalKey + " of type " + adapter.getType(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponent(Object key) {
        Object component = super.getStoredComponent(key);
        if (component == null && this.registry.containsKey(key)) {
            Object object = this.CREATION_MUTEX;
            synchronized (object) {
                if (component == null && (component = this.wireObject(key, (AutoWiringAdapter)this.registry.get(key))) != null) {
                    this.store(key, component);
                }
            }
        }
        return component;
    }
}

