/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.micro.container;

import java.util.Hashtable;
import net.israfil.micro.container.Container;
import net.israfil.micro.container.error.ComponentAlreadyRegisteredError;

public abstract class AbstractContainer
implements Container {
    private final Hashtable components = new Hashtable();
    private final Container parent;
    private boolean running = false;

    public AbstractContainer() {
        this.parent = null;
    }

    public AbstractContainer(Container parent) {
        this.parent = parent;
    }

    protected boolean isStored(Object key) {
        return this.components.containsKey(key);
    }

    public boolean hasComponent(Object key) {
        return this.components.containsKey(key) || this.parent != null && this.parent.hasComponent(key);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.running = true;
    }

    protected Container getParent() {
        return this.parent;
    }

    protected Object getStoredComponent(Object key) {
        Object result = this.components.get(key);
        if (result == null && this.parent != null) {
            result = this.parent.getComponent(key);
        }
        return result;
    }

    protected void store(Object key, Object component) {
        if (this.hasComponent(key)) {
            if (this.getComponent(key) == component) {
                return;
            }
            throw new ComponentAlreadyRegisteredError("Object already registered for key: " + key);
        }
        this.components.put(key, component);
    }

    public abstract /* synthetic */ Object getComponent(Object var1);
}

