/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.valuemodel;

import java.util.HashMap;
import java.util.Map;
import net.israfil.foundation.core.DynamicUtil;
import net.israfil.foundation.valuemodel.MutableValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueHolder<E>
implements MutableValue<E> {
    private E _value = null;
    private Map<Integer, ObserverHolder> _observers = new HashMap<Integer, ObserverHolder>();
    private Map<Integer, VetoerHolder> _vetoers = new HashMap<Integer, VetoerHolder>();

    public ValueHolder(E o) {
        this.set(o);
    }

    protected ValueHolder() {
    }

    @Override
    public E get() {
        return this._value;
    }

    @Override
    public void set(E newValue) {
        boolean approved = true;
        E oldValue = this._value;
        for (VetoerHolder vetoer : this._vetoers.values()) {
            approved &= vetoer.evaluate(this, oldValue, newValue).booleanValue();
        }
        if (!approved) {
            return;
        }
        this._value = newValue;
        for (ObserverHolder observer : this._observers.values()) {
            observer.notify(this, oldValue, newValue);
        }
    }

    @Override
    public void addObservers(String callback, Object ... observers) {
        for (Object observer : observers) {
            this._observers.put(observer.hashCode(), new ObserverHolder(observer, callback));
        }
    }

    @Override
    public void removeObservers(Object ... observers) {
        for (Object observer : observers) {
            this._observers.remove(observer.hashCode());
        }
    }

    @Override
    public void addVetoers(String callback, Object ... vetoers) {
        for (Object vetoer : vetoers) {
            this._vetoers.put(vetoer.hashCode(), new VetoerHolder(vetoer, callback));
        }
    }

    @Override
    public void removeVetoers(Object ... vetoers) {
        for (Object vetoer : vetoers) {
            this._vetoers.remove(vetoer.hashCode());
        }
    }

    protected class VetoerHolder
    extends CallbackObjectHolder {
        public VetoerHolder(Object vetoer, String callback) {
            super(vetoer, callback);
        }

        public Boolean evaluate(Object notifier, Object oldValue, Object newValue) {
            Boolean result = (Boolean)DynamicUtil.performOn((Object)this.receiver, (String)this.callback, (Object[])new Object[]{notifier, oldValue, newValue});
            return result == null ? true : result;
        }
    }

    protected class ObserverHolder
    extends CallbackObjectHolder {
        public ObserverHolder(Object observer, String callback) {
            super(observer, callback);
        }

        public void notify(Object notifier, Object oldValue, Object newValue) {
            DynamicUtil.performOn((Object)this.receiver, (String)this.callback, (Object[])new Object[]{notifier, oldValue, newValue});
        }
    }

    protected class CallbackObjectHolder {
        public final Object receiver;
        protected final String callback;

        public CallbackObjectHolder(Object receiver, String callback) {
            this.receiver = receiver;
            this.callback = callback;
        }
    }
}

