/* 
 * Copyright (c) 2003-2007 Israfil Consulting Services Corporation
 * Copyright (c) 2003-2007 Christian Edward Gruber
 * All Rights Reserved
 *
 * $Id: Types.java 129 2006-12-31 23:20:02Z cgruber $
 */
package net.israfil.foundation.valuemodel;

/**
 * An interface for objects that can notify observers of changes to itself 
 * before the change.  The objects thus notified can veto the change.  The
 * specific behaviour for vetoing is undefined and is dependent upon the
 * particular implementation of the vetoable object and its vetoers.
 * The changing object should call the provided callback signature, with the 
 * parameter being the object that was changed in its new state. The vetoer
 * is responsible for knowing what it needs to know in order to validate or
 * veto the change.
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber</a>
 * @author Latest: $Author: cgruber $
 * @version $Revision: 129 $
 */
//@Copyright(years={"2003","2004","2005","2006","2007"},owner="Israfil Consulting Services Corporation",license="BSD")
public interface Vetoable {
    
    /** Add one or more vetoers to this object, with a callback method spec 
     * that will be invoked upon a data change.  The callback method should 
     * contain two parameters.  The first is the notification source (the 
     * holder or whatever) and the new value. It also should return a boolean.
     */
    public void addVetoers(String callback, Object ... approvers);
    
    /** 
     * Remove one or more vetoers from vetoable object.
     */
    public void removeVetoers(Object ... approvers);

}
