/* 
 * Copyright (c) 2003-2007 Israfil Consulting Services Corporation
 * Copyright (c) 2003-2007 Christian Edward Gruber
 * All Rights Reserved
 *
 * $Id: Types.java 129 2006-12-31 23:20:02Z cgruber $
 */
package net.israfil.foundation.valuemodel;

/**
 * An interface for objects that can notify observers of changes to itself.  The
 * changing object should call the provided callback signature, with the 
 * parameter being the object that was changed in its new state.
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber</a>
 * @author Latest: $Author: cgruber $
 * @version $Revision: 129 $
 */
//@Copyright(years={"2003","2004","2005","2006","2007"},owner="Israfil Consulting Services Corporation",license="BSD")
public interface Observable {

    /** Add an observer to this object, with a callback method spec that will
     * be invoked upon a data change.  The callback method should contain only
     * one Object parameter which will be the sender when the callback is
     * invoked.
     */
    public void addObservers(String callback, Object ... observers);
    /** 
     * Remove observer from observable object.
     */
    public void removeObservers(Object ... observers);
    
}
