/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.mock.sql;

import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MockResultSetMetaData
implements ResultSetMetaData {
    public static int ZERO_ORDER_LIST_OFFSET = 1;
    List<ColSpec> columns;

    MockResultSetMetaData(String ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException("Cannot construct a MockResultSet with no columns.");
        }
        ColSpec[] colspecs = new ColSpec[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            colspecs[i] = new ColSpec(columns[i]);
        }
        this.prepColumns(colspecs);
    }

    MockResultSetMetaData(ColSpec ... columns) {
        this.prepColumns(columns);
    }

    private void prepColumns(ColSpec ... columns) {
        if (columns == null || columns.length <= 0) {
            throw new IllegalArgumentException("Cannot construct a MockResultSet with no columns.");
        }
        this.columns = new ArrayList<ColSpec>(Arrays.asList(columns));
    }

    public void finalize() throws Throwable {
        this.columns = null;
    }

    public int getColumnNumber(String name) {
        for (int i = 1; i <= this.columns.size(); ++i) {
            if (!this.columns.get((int)(i - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).name.equalsIgnoreCase(name)) continue;
            return i;
        }
        return 0;
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).width;
    }

    public String getColumnLabel(int column) throws SQLException {
        if (column < 1) {
            throw new IllegalArgumentException("Column number must be greater than 0.");
        }
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).name;
    }

    public String getColumnName(int column) throws SQLException {
        if (column < 1) {
            throw new IllegalArgumentException("Column number must be greater than 0.");
        }
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).name;
    }

    public int getColumnType(int column) throws SQLException {
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).type.sqltype;
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.columns.get((int)column).type.name();
    }

    public int getPrecision(int column) throws SQLException {
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).precision;
    }

    public int getScale(int column) throws SQLException {
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).scale;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public int isNullable(int column) throws SQLException {
        return this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET)).nullable ? 1 : 0;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        BLOB(byte[].class, 2004, DBTypeGroup.Other),
        BIT(Boolean.TYPE, -7, DBTypeGroup.Number),
        CHAR(Character.TYPE, 1, DBTypeGroup.Number),
        DECIMAL(BigDecimal.class, 3, DBTypeGroup.Number),
        FLOAT(Float.TYPE, 6, DBTypeGroup.Number),
        DOUBLE(Double.TYPE, 8, DBTypeGroup.Number),
        SHORT(Short.TYPE, 5, DBTypeGroup.Number),
        INTEGER(Integer.TYPE, 4, DBTypeGroup.Number),
        LONG(Long.TYPE, -5, DBTypeGroup.Number),
        BYTE(Byte.TYPE, -6, DBTypeGroup.Number),
        STRING(String.class, 12, DBTypeGroup.String),
        TIMESTAMP(Timestamp.class, 93, DBTypeGroup.Time),
        OBJECT(Object.class, 2000, DBTypeGroup.Complex);

        public final Class javaClass;
        public final int sqltype;
        public final DBTypeGroup group;

        private DBType(Class javaClass, int sqltype, DBTypeGroup group) {
            this.javaClass = javaClass;
            this.sqltype = sqltype;
            this.group = group;
        }

        public static DBType valueOf(int sqlType) {
            switch (sqlType) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    return BLOB;
                }
                case -5: {
                    return LONG;
                }
                case -7: 
                case 16: {
                    return BIT;
                }
                case 1: {
                    return CHAR;
                }
                case 8: {
                    return DOUBLE;
                }
                case 6: {
                    return FLOAT;
                }
                case 4: {
                    return INTEGER;
                }
                case 5: {
                    return SHORT;
                }
                case -6: {
                    return BYTE;
                }
                case 2: 
                case 3: 
                case 7: {
                    return DECIMAL;
                }
                case -1: 
                case 12: {
                    return STRING;
                }
                case 91: 
                case 92: 
                case 93: {
                    return TIMESTAMP;
                }
                case 2000: 
                case 2002: 
                case 2003: {
                    return OBJECT;
                }
            }
            throw new IllegalArgumentException("Unsupported JDBC type");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBTypeGroup {
        Time(0),
        Number(1),
        String(2),
        Complex(3),
        Other(4);

        public int value;

        private DBTypeGroup(int i) {
            this.value = i;
        }
    }

    public static class ColSpec {
        public final String name;
        public final DBType type;
        public final int width;
        public final int precision;
        public final int scale;
        public final boolean nullable;

        public ColSpec(String name) {
            this.name = name;
            this.type = DBType.OBJECT;
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = true;
        }

        public ColSpec(String name, boolean nullable) {
            this.name = name;
            this.type = DBType.OBJECT;
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = nullable;
        }

        public ColSpec(String name, DBType type) {
            this.name = name;
            this.type = type;
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = true;
        }

        public ColSpec(String name, DBType type, boolean nullable) {
            this.name = name;
            this.type = type;
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = nullable;
        }

        public ColSpec(String name, DBType type, int width) {
            this.name = name;
            this.type = type;
            this.width = width;
            this.precision = 0;
            this.scale = 0;
            this.nullable = true;
        }

        public ColSpec(String name, DBType type, int precision, int scale) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.scale = scale;
            this.width = 0;
            this.nullable = true;
        }

        public ColSpec(String name, DBType type, int width, boolean nullable) {
            this.name = name;
            this.type = type;
            this.width = width;
            this.precision = 0;
            this.scale = 0;
            this.nullable = nullable;
        }

        public ColSpec(String name, DBType type, int precision, int scale, boolean nullable) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.scale = scale;
            this.width = 0;
            this.nullable = nullable;
        }
    }
}

