/*
 * Copyright (c) 2003, 2004, 2005, 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2003, 2004, 2005, 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: Row.java 27 2006-02-13 19:40:43Z cgruber $
 */
package net.israfil.foundation.mock.sql;

import java.sql.SQLException;
import java.util.List;

/**
 * An object representing row data in a MockResultSet.
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber </a>
 */
public class Row {
	
	MockResultSetMetaData metadata = null;
    List<Object> data;
    
    int cursorPosition;
    final boolean insertRow;
    public boolean dirty = true;

    public Row(MockResultSetMetaData metadata, List<Object> rowData) {
        this(metadata,rowData,false);
    }
    
    public Row(MockResultSetMetaData metadata, List<Object> rowData, boolean isInsertRow) {
    	this.metadata = metadata;
        this.data = rowData;
        this.insertRow = isInsertRow;
        this.dirty = false;
    }
    
    public void finalize() throws Throwable {
		data = null;
		metadata = null;
    	super.finalize();
    }
    
    public void validateColumn(int i) throws SQLException {
    	if (i <= 0 || i > metadata.columns.size()) throw new SQLException("No such column #" + i);
    }
    
    public List<Object> getData() { return data; } 
    
    public Object get(int i) throws SQLException {
    	validateColumn(i);
    	return data.get(i-1);
    }
    
    public Object get(String columnName) throws SQLException {
    	return get(metadata.getColumnNumber(columnName));
    }
   
    public void set(int i,Object o) throws SQLException {
    	validateColumn(i);
    	data.set(i-1,o);
    	dirty = true;
    }
    
    public void set(String columnName,Object o) throws SQLException {
    	set(metadata.getColumnNumber(columnName),o);
    }
    
    public boolean isDirty() {
    	return dirty;
    }
}
