/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.dynamic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.israfil.foundation.collections.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicUtil {
    private static Logger logger = Logger.getLogger(DynamicUtil.class.getName());
    static Map<String, Class> _primitiveTypes = new HashMap<String, Class>();
    static Map<Class, Class> _primitiveTypeEquivalents = new HashMap<Class, Class>();
    static Map<Class, Class> _boxedTypeEquivalents = new HashMap<Class, Class>();
    protected static final Map<Class, Set<Class>> classes;

    private DynamicUtil() {
    }

    public static boolean hasPrimitiveTypeEquivalent(Class c) {
        return _primitiveTypeEquivalents.containsKey(c);
    }

    public static Class getPrimitiveTypeEquivalent(Class c) {
        return _primitiveTypeEquivalents.get(c);
    }

    public static boolean hasBoxedTypeEquivalent(Class c) {
        return _boxedTypeEquivalents.containsKey(c);
    }

    public static Class getBoxedTypeEquivalent(Class c) {
        return _boxedTypeEquivalents.get(c);
    }

    public static Set<Class> getAllParentTypes(Class c) {
        if (!classes.containsKey(c)) {
            HashSet<Class> parents = new HashSet<Class>();
            for (Class cType = c; cType != Object.class && cType != null; cType = cType.getSuperclass()) {
                parents.add(cType);
                DynamicUtil.addSuperInterfaces(parents, cType);
            }
            parents.add(Object.class);
            parents.remove(c);
            classes.put(c, parents);
        }
        return classes.get(c);
    }

    public static void addSuperInterfaces(Set<Class> set, Class c) {
        if (c == null || c.getInterfaces() == null) {
            return;
        }
        for (Class<?> i : c.getInterfaces()) {
            set.add(i);
            DynamicUtil.addSuperInterfaces(set, i);
        }
    }

    public static Field getField(Object receiver, String attributeName) {
        Field f = null;
        try {
            f = receiver.getClass().getField(attributeName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        return f;
    }

    public static boolean respondsTo(Object receiver, String selector) {
        return DynamicUtil.getMethodForSelector(receiver, selector) != null;
    }

    public static Method getMethodForSelector(Object receiver, String selector) {
        if (receiver instanceof Class) {
            return DynamicUtil.getMethodForSelector((Class)receiver, selector);
        }
        return DynamicUtil.getMethodForSelector(receiver.getClass(), selector);
    }

    public static Method getMethodForSelector(Class receiverClass, String selector) {
        try {
            return DynamicUtil._getMethodForSelector(receiverClass, selector);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected static Method _getMethodForSelector(Class receiverClass, String selector) throws ClassNotFoundException, NoSuchMethodException {
        StringTokenizer st = new StringTokenizer(selector, ":");
        Class[] paramTypes = new Class[st.countTokens() - 1];
        String methodName = st.nextToken();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        int i = 0;
        while (st.hasMoreTokens()) {
            String className = st.nextToken();
            paramTypes[i] = _primitiveTypes.containsKey(className) ? _primitiveTypes.get(className) : loader.loadClass(className);
            ++i;
        }
        return receiverClass.getMethod(methodName, paramTypes);
    }

    public static Object performOn(Object receiver, String selector, Object ... parameters) {
        if (parameters == null) {
            parameters = new Object[]{};
        }
        Method m = DynamicUtil.getMethodForSelector(receiver, selector);
        try {
            if (m != null) {
                return m.invoke(receiver, parameters);
            }
            throw new NoSuchMethodError("No public method defined with selector \"" + selector + "\"");
        }
        catch (InvocationTargetException ite) {
            logger.log(Level.FINE, ite.getClass().getName() + " thrown attempting to invoke selector: " + selector + " on " + receiver, ite);
            if (ite.getCause() != null) {
                throw new RuntimeException(ite.getCause());
            }
            throw new RuntimeException(ite);
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.FINE, iae.getClass().getName() + " thrown attempting to invoke selector: " + selector + " on " + receiver, iae);
            throw new RuntimeException(iae);
        }
    }

    public static Object construct(String className, Object ... parameters) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return DynamicUtil.construct(clazz, parameters);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, e.getClass().getName() + " thrown attempting to construct a " + className + ".", e);
            return null;
        }
    }

    public static <T> T construct(Class<T> c, Object ... parameters) {
        Class[] parmTypes = new Class[parameters.length];
        for (int i = 0; i < parmTypes.length; ++i) {
            parmTypes[i] = parameters[i].getClass();
        }
        return DynamicUtil.construct(c, parmTypes, parameters);
    }

    public static Object construct(String className, Class[] parameterTypes, Object ... parameters) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return DynamicUtil.construct(clazz, parameterTypes, parameters);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, e.getClass().getName() + " thrown attempting to construct a " + className + ".", e);
            return null;
        }
    }

    public static <T> T construct(Class<T> c, Class[] parameterTypes, Object ... parameters) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = c.getDeclaredConstructors()) {
                if (!ArrayUtils.equivalent((Object[])parameterTypes, (Object[])constructor.getParameterTypes())) continue;
                return (T)constructor.newInstance(parameters);
            }
            return null;
        }
        catch (Exception e) {
            logger.log(Level.FINE, e.getClass().getName() + " thrown attempting to construct a " + c.getName() + ".", e);
            return null;
        }
    }

    static {
        _primitiveTypes.put("boolean", Boolean.TYPE);
        _primitiveTypeEquivalents.put(Boolean.class, Boolean.TYPE);
        _boxedTypeEquivalents.put(Boolean.TYPE, Boolean.class);
        _primitiveTypes.put("int", Integer.TYPE);
        _primitiveTypeEquivalents.put(Integer.class, Integer.TYPE);
        _boxedTypeEquivalents.put(Integer.TYPE, Integer.class);
        _primitiveTypes.put("long", Long.TYPE);
        _primitiveTypeEquivalents.put(Long.class, Long.TYPE);
        _boxedTypeEquivalents.put(Long.TYPE, Long.class);
        _primitiveTypes.put("short", Short.TYPE);
        _primitiveTypeEquivalents.put(Short.class, Short.TYPE);
        _boxedTypeEquivalents.put(Short.TYPE, Short.class);
        _primitiveTypes.put("byte", Byte.TYPE);
        _primitiveTypeEquivalents.put(Byte.class, Byte.TYPE);
        _boxedTypeEquivalents.put(Byte.TYPE, Byte.class);
        _primitiveTypes.put("char", Character.TYPE);
        _primitiveTypeEquivalents.put(Character.class, Character.TYPE);
        _boxedTypeEquivalents.put(Character.TYPE, Character.class);
        _primitiveTypes.put("double", Double.TYPE);
        _primitiveTypeEquivalents.put(Double.class, Double.TYPE);
        _boxedTypeEquivalents.put(Double.TYPE, Double.class);
        _primitiveTypes.put("float", Float.TYPE);
        _primitiveTypeEquivalents.put(Float.class, Float.TYPE);
        _boxedTypeEquivalents.put(Float.TYPE, Float.class);
        classes = new HashMap<Class, Set<Class>>();
    }
}

