/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.notification;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.israfil.foundation.core.DynamicUtil;
import net.israfil.foundation.notification.Notification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationCentre {
    private static NotificationCentre _shared = new NotificationCentre();
    private Set<ObservationSpec> observers = new HashSet<ObservationSpec>();

    protected NotificationCentre() {
    }

    public static NotificationCentre defaultCentre() {
        return _shared;
    }

    public void addObserver(Object observer, String callbackSignature, String notification, Object sender) {
        if (observer == null) {
            return;
        }
        if (callbackSignature == null) {
            throw new IllegalArgumentException("Reciever did not pass in a callback method.");
        }
        if (!this.checkSignature(observer, callbackSignature)) {
            throw new IllegalArgumentException("Reciever does not implement specified callback method.");
        }
        this.observers.add(new ObservationSpec(sender, notification, callbackSignature, observer));
    }

    public void postNotification(Notification notification) {
        Iterator<ObservationSpec> i = this.observers.iterator();
        while (i.hasNext()) {
            i.next().postNotification(notification);
        }
    }

    public void postNotification(Object sender, String notification) {
        this.postNotification(new Notification(sender, notification));
    }

    public void postNotification(Object sender, String notification, Map<String, Object> info) {
        this.postNotification(new Notification(sender, notification, info));
    }

    public void removeObserver(Object observer, String notification, Object sender) {
        for (ObservationSpec obs : this.observers) {
            if (obs.observer != observer || obs.sender != sender || obs.notification != null && !obs.notification.equals(notification)) continue;
            this.observers.remove(obs);
        }
    }

    public void clearObservers() {
        this.observers.clear();
    }

    private boolean checkSignature(Object receiver, String selector) {
        if (!DynamicUtil.respondsTo(receiver, selector)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(selector, ":");
        if (st.countTokens() != 2) {
            return false;
        }
        st.nextToken();
        String parameter = st.nextToken();
        if (Notification.class.getName().equals(parameter)) {
            return true;
        }
        return Object.class.getName().equals(parameter);
    }

    public class ObservationSpec {
        public final Object sender;
        public final String notification;
        public final String callback;
        public final Object observer;
        private final int _hashCode;

        public ObservationSpec(Object sender, String notification, String callback, Object observer) {
            if (observer == null) {
                throw new IllegalArgumentException("Both sender and notification cannot be null");
            }
            this.sender = sender;
            this.notification = notification;
            this.callback = callback;
            this.observer = observer;
            int code = 13;
            if (sender != null) {
                code *= sender.hashCode();
            }
            if (notification != null) {
                code *= notification.hashCode();
            }
            this._hashCode = code *= observer.hashCode();
        }

        public void postNotification(Notification notification) {
            if (this.sender == null && this.notification == null) {
                this._post(notification);
            } else if (this.sender == null) {
                if (notification.notification.equals(this.notification)) {
                    this._post(notification);
                }
            } else if (this.notification == null) {
                if (notification.sender.equals(this.sender)) {
                    this._post(notification);
                }
            } else if (notification.notification.equals(this.notification) && notification.sender.equals(this.sender)) {
                this._post(notification);
            }
        }

        private void _post(Notification notification) {
            DynamicUtil.performOn(this.observer, this.callback, notification);
        }

        public int hashCode() {
            return this._hashCode;
        }
    }
}

