/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.israfil.foundation.core.DynamicObject;
import net.israfil.foundation.core.DynamicUtil;
import net.israfil.foundation.core.DynamicallyAccessible;
import net.israfil.foundation.core.Strings;

public abstract class DynamicallyAccessibleObject
extends DynamicObject
implements DynamicallyAccessible {
    private static Logger logger = Logger.getLogger(DynamicallyAccessibleObject.class.getName());
    protected static final String[] accessPrefixes = new String[]{"get", "is"};

    public Object get(String attributeName) {
        return DynamicallyAccessibleObject.get(this, attributeName);
    }

    public static Object get(Object receiver, String attributeName) {
        try {
            return DynamicallyAccessibleObject._get(receiver, attributeName);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.FINE, "Object attempted to dynamically access a non-existant or unreadable field.", e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, "Object attempted to dynamically access a inaccessible field.", e);
            throw new RuntimeException(e);
        }
    }

    Object _get(String attributeName) throws NoSuchFieldException, IllegalAccessException {
        return DynamicallyAccessibleObject._get(this, attributeName);
    }

    static Object _get(Object receiver, String attributeName) throws NoSuchFieldException, IllegalAccessException {
        if (DynamicallyAccessibleObject.hasAccessor(receiver, attributeName)) {
            return DynamicUtil.performOn(receiver, DynamicallyAccessibleObject._getAccessorSelector(receiver, attributeName), new Object[0]);
        }
        return receiver.getClass().getField(attributeName).get(receiver);
    }

    public boolean hasAttribute(String attributeName) {
        return DynamicallyAccessibleObject.hasAttribute(this, attributeName);
    }

    public static boolean hasAttribute(Object receiver, String attributeName) {
        try {
            DynamicallyAccessibleObject._get(receiver, attributeName);
            return true;
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.FINEST, "Object attempted to dynamically access a non-existant or unreadable field.", e);
            return false;
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINEST, "Object attempted to dynamically access a inaccessible field.", e);
            return false;
        }
    }

    protected String getAccessorSelector(String attributeName) {
        return DynamicallyAccessibleObject._getAccessorSelector(this, attributeName);
    }

    protected static String _getAccessorSelector(Object receiver, String attributeName) {
        if (attributeName == null || attributeName.equals("")) {
            return null;
        }
        String camelAttr = DynamicallyAccessibleObject.camel(attributeName);
        for (String prefix : accessPrefixes) {
            String selector = prefix + camelAttr;
            if (!DynamicUtil.respondsTo(receiver, selector)) continue;
            return selector;
        }
        if (DynamicUtil.respondsTo(receiver, attributeName)) {
            return attributeName;
        }
        return null;
    }

    public boolean hasAccessor(String attributeName) {
        return DynamicallyAccessibleObject.hasAccessor(this, attributeName);
    }

    public static boolean hasAccessor(Object receiver, String attributeName) {
        return DynamicallyAccessibleObject._getAccessorSelector(receiver, attributeName) != null;
    }

    public static String camel(String string) {
        return Strings.camel(string);
    }
}

